// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpcollectorlog "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportLogsServiceResponse(t *testing.T) {
	src := &otlpcollectorlog.ExportLogsServiceResponse{}
	dest := &otlpcollectorlog.ExportLogsServiceResponse{}
	CopyOrigExportLogsServiceResponse(dest, src)
	assert.Equal(t, &otlpcollectorlog.ExportLogsServiceResponse{}, dest)
	FillOrigTestExportLogsServiceResponse(src)
	CopyOrigExportLogsServiceResponse(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportLogsServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpcollectorlog.ExportLogsServiceResponse{}
	UnmarshalJSONOrigExportLogsServiceResponse(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpcollectorlog.ExportLogsServiceResponse{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExportLogsServiceResponse(t *testing.T) {
	for name, src := range getEncodingTestValuesExportLogsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExportLogsServiceResponse(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpcollectorlog.ExportLogsServiceResponse{}
			UnmarshalJSONOrigExportLogsServiceResponse(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportLogsServiceResponse(t *testing.T) {
	for name, src := range getEncodingTestValuesExportLogsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportLogsServiceResponse(src))
			gotSize := MarshalProtoOrigExportLogsServiceResponse(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpcollectorlog.ExportLogsServiceResponse{}
			require.NoError(t, UnmarshalProtoOrigExportLogsServiceResponse(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExportLogsServiceResponse() map[string]*otlpcollectorlog.ExportLogsServiceResponse {
	return map[string]*otlpcollectorlog.ExportLogsServiceResponse{
		"empty": {},
		"fill_test": func() *otlpcollectorlog.ExportLogsServiceResponse {
			src := &otlpcollectorlog.ExportLogsServiceResponse{}
			FillOrigTestExportLogsServiceResponse(src)
			return src
		}(),
	}
}
