// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigAttributeUnit(t *testing.T) {
	src := &otlpprofiles.AttributeUnit{}
	dest := &otlpprofiles.AttributeUnit{}
	CopyOrigAttributeUnit(dest, src)
	assert.Equal(t, &otlpprofiles.AttributeUnit{}, dest)
	FillOrigTestAttributeUnit(src)
	CopyOrigAttributeUnit(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigAttributeUnitUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.AttributeUnit{}
	UnmarshalJSONOrigAttributeUnit(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.AttributeUnit{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigAttributeUnit(t *testing.T) {
	for name, src := range getEncodingTestValuesAttributeUnit() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigAttributeUnit(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.AttributeUnit{}
			UnmarshalJSONOrigAttributeUnit(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigAttributeUnit(t *testing.T) {
	for name, src := range getEncodingTestValuesAttributeUnit() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigAttributeUnit(src))
			gotSize := MarshalProtoOrigAttributeUnit(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.AttributeUnit{}
			require.NoError(t, UnmarshalProtoOrigAttributeUnit(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesAttributeUnit() map[string]*otlpprofiles.AttributeUnit {
	return map[string]*otlpprofiles.AttributeUnit{
		"empty": {},
		"fill_test": func() *otlpprofiles.AttributeUnit {
			src := &otlpprofiles.AttributeUnit{}
			FillOrigTestAttributeUnit(src)
			return src
		}(),
	}
}
