// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

package internal // import "go.opentelemetry.io/collector/internal/cmd/pdatagen/internal"

var pcommon = &Package{
	info: &PackageInfo{
		name: "pcommon",
		path: "pcommon",
		imports: []string{
			`"encoding/binary"`,
			`"iter"`,
			`"math"`,
			`"sort"`,
			``,
			`"go.opentelemetry.io/collector/pdata/internal"`,
			`"go.opentelemetry.io/collector/pdata/internal/json"`,
			`"go.opentelemetry.io/collector/pdata/internal/proto"`,
			`otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"`,
			`otlpresource "go.opentelemetry.io/collector/pdata/internal/data/protogen/resource/v1"`,
		},
		testImports: []string{
			`"testing"`,
			``,
			`"github.com/stretchr/testify/assert"`,
			``,
			`"go.opentelemetry.io/collector/pdata/internal"`,
			`"go.opentelemetry.io/collector/pdata/internal/json"`,
		},
	},
	structs: []baseStruct{
		sliceStruct,
		scope,
		resource,
		byteSlice,
		float64Slice,
		uInt64Slice,
		int64Slice,
		int32Slice,
		stringSlice,
	},
}

var scope = &messageStruct{
	structName:     "InstrumentationScope",
	packageName:    "pcommon",
	description:    "// InstrumentationScope is a message representing the instrumentation scope information.",
	originFullName: "otlpcommon.InstrumentationScope",
	fields: []Field{
		&PrimitiveField{
			fieldName: "Name",
			protoID:   1,
			protoType: ProtoTypeString,
		},
		&PrimitiveField{
			fieldName: "Version",
			protoID:   2,
			protoType: ProtoTypeString,
		},
		&SliceField{
			fieldName:   "Attributes",
			protoType:   ProtoTypeMessage,
			protoID:     3,
			returnSlice: mapStruct,
		},
		&PrimitiveField{
			fieldName: "DroppedAttributesCount",
			protoID:   4,
			protoType: ProtoTypeUint32,
		},
	},
}

// This will not be generated by this class.
// Defined here just to be available as returned message for the fields.
var mapStruct = &sliceOfValues{
	structName:  "Map",
	packageName: "pcommon",
	element:     attribute,
}

var sliceStruct = &sliceOfValues{
	structName:  "Slice",
	packageName: "pcommon",
	element:     anyValue,
}

var traceState = &messageStruct{
	structName:     "TraceState",
	packageName:    "pcommon",
	originFullName: "otlpcommon.TraceState", // Fake name to generate correct CopyOrig* name.
}

var timestampType = &TypedType{
	structName:  "Timestamp",
	packageName: "pcommon",
	protoType:   ProtoTypeFixed64,
	defaultVal:  "0",
	testVal:     "1234567890",
}

var anyValue = &messageStruct{
	structName:     "Value",
	packageName:    "pcommon",
	originFullName: "otlpcommon.AnyValue",
}

var traceIDType = &TypedType{
	structName:  "TraceID",
	packageName: "pcommon",
	protoType:   ProtoTypeMessage,
	messageName: "data.TraceID",
	defaultVal:  "data.TraceID([16]byte{})",
	testVal:     "data.TraceID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})",
}

var spanIDType = &TypedType{
	structName:  "SpanID",
	packageName: "pcommon",
	protoType:   ProtoTypeMessage,
	messageName: "data.SpanID",
	defaultVal:  "data.SpanID([8]byte{})",
	testVal:     "data.SpanID([8]byte{8, 7, 6, 5, 4, 3, 2, 1})",
}

var resource = &messageStruct{
	structName:     "Resource",
	packageName:    "pcommon",
	description:    "// Resource is a message representing the resource information.",
	originFullName: "otlpresource.Resource",
	fields: []Field{
		&SliceField{
			fieldName:   "Attributes",
			protoType:   ProtoTypeMessage,
			protoID:     1,
			returnSlice: mapStruct,
		},
		&PrimitiveField{
			fieldName: "DroppedAttributesCount",
			protoID:   2,
			protoType: ProtoTypeUint32,
		},
		&SliceField{
			fieldName:   "EntityRefs",
			protoType:   ProtoTypeMessage,
			protoID:     3,
			returnSlice: entityRefSlice,
			// Hide accessors for this field from 1.x public API since the proto field is experimental.
			// It's available via the xpdata/entity.ResourceEntityRefs.
			hideAccessors: true,
		},
	},
}

var byteSlice = &primitiveSliceStruct{
	structName:           "ByteSlice",
	packageName:          "pcommon",
	itemType:             "byte",
	testOrigVal:          "1, 2, 3",
	testInterfaceOrigVal: []any{1, 2, 3},
	testSetVal:           "5",
	testNewVal:           "1, 5, 3",
}

var float64Slice = &primitiveSliceStruct{
	structName:           "Float64Slice",
	packageName:          "pcommon",
	itemType:             "float64",
	testOrigVal:          "1.1, 2.2, 3.3",
	testInterfaceOrigVal: []any{1.1, 2.2, 3.3},
	testSetVal:           "5.5",
	testNewVal:           "1.1, 5.5, 3.3",
}

var uInt64Slice = &primitiveSliceStruct{
	structName:           "UInt64Slice",
	packageName:          "pcommon",
	itemType:             "uint64",
	testOrigVal:          "1, 2, 3",
	testInterfaceOrigVal: []any{1, 2, 3},
	testSetVal:           "5",
	testNewVal:           "1, 5, 3",
}

var int64Slice = &primitiveSliceStruct{
	structName:           "Int64Slice",
	packageName:          "pcommon",
	itemType:             "int64",
	testOrigVal:          "1, 2, 3",
	testInterfaceOrigVal: []any{1, 2, 3},
	testSetVal:           "5",
	testNewVal:           "1, 5, 3",
}

var int32Slice = &primitiveSliceStruct{
	structName:           "Int32Slice",
	packageName:          "pcommon",
	itemType:             "int32",
	testOrigVal:          "1, 2, 3",
	testInterfaceOrigVal: []any{1, 2, 3},
	testSetVal:           "5",
	testNewVal:           "1, 5, 3",
}

var stringSlice = &primitiveSliceStruct{
	structName:           "StringSlice",
	packageName:          "pcommon",
	itemType:             "string",
	testOrigVal:          `"a", "b", "c"`,
	testInterfaceOrigVal: []any{`"a"`, `"b"`, `"c"`},
	testSetVal:           `"d"`,
	testNewVal:           `"a", "d", "c"`,
}
