// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/internal/data"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1experimental"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestProfileContainer_MoveTo(t *testing.T) {
	ms := generateTestProfileContainer()
	dest := NewProfileContainer()
	ms.MoveTo(dest)
	assert.Equal(t, NewProfileContainer(), ms)
	assert.Equal(t, generateTestProfileContainer(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newProfileContainer(&otlpprofiles.ProfileContainer{}, &sharedState)) })
	assert.Panics(t, func() { newProfileContainer(&otlpprofiles.ProfileContainer{}, &sharedState).MoveTo(dest) })
}

func TestProfileContainer_CopyTo(t *testing.T) {
	ms := NewProfileContainer()
	orig := NewProfileContainer()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestProfileContainer()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newProfileContainer(&otlpprofiles.ProfileContainer{}, &sharedState)) })
}

func TestProfileContainer_ProfileID(t *testing.T) {
	ms := NewProfileContainer()
	assert.Equal(t, ProfileID(data.ProfileID([16]byte{})), ms.ProfileID())
	testValProfileID := ProfileID(data.ProfileID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetProfileID(testValProfileID)
	assert.Equal(t, testValProfileID, ms.ProfileID())
}

func TestProfileContainer_StartTime(t *testing.T) {
	ms := NewProfileContainer()
	assert.Equal(t, pcommon.Timestamp(0), ms.StartTime())
	testValStartTime := pcommon.Timestamp(1234567890)
	ms.SetStartTime(testValStartTime)
	assert.Equal(t, testValStartTime, ms.StartTime())
}

func TestProfileContainer_EndTime(t *testing.T) {
	ms := NewProfileContainer()
	assert.Equal(t, pcommon.Timestamp(0), ms.EndTime())
	testValEndTime := pcommon.Timestamp(1234567890)
	ms.SetEndTime(testValEndTime)
	assert.Equal(t, testValEndTime, ms.EndTime())
}

func TestProfileContainer_Attributes(t *testing.T) {
	ms := NewProfileContainer()
	assert.Equal(t, pcommon.NewMap(), ms.Attributes())
	internal.FillTestMap(internal.Map(ms.Attributes()))
	assert.Equal(t, pcommon.Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestProfileContainer_DroppedAttributesCount(t *testing.T) {
	ms := NewProfileContainer()
	assert.Equal(t, uint32(0), ms.DroppedAttributesCount())
	ms.SetDroppedAttributesCount(uint32(17))
	assert.Equal(t, uint32(17), ms.DroppedAttributesCount())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() {
		newProfileContainer(&otlpprofiles.ProfileContainer{}, &sharedState).SetDroppedAttributesCount(uint32(17))
	})
}

func TestProfileContainer_Profile(t *testing.T) {
	ms := NewProfileContainer()
	fillTestProfile(ms.Profile())
	assert.Equal(t, generateTestProfile(), ms.Profile())
}

func generateTestProfileContainer() ProfileContainer {
	tv := NewProfileContainer()
	fillTestProfileContainer(tv)
	return tv
}

func fillTestProfileContainer(tv ProfileContainer) {
	tv.orig.ProfileId = data.ProfileID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1})
	tv.orig.StartTimeUnixNano = 1234567890
	tv.orig.EndTimeUnixNano = 1234567890
	internal.FillTestMap(internal.NewMap(&tv.orig.Attributes, tv.state))
	tv.orig.DroppedAttributesCount = uint32(17)
	fillTestProfile(newProfile(&tv.orig.Profile, tv.state))
}
