// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"context"
	"errors"

	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/metric"
	"go.opentelemetry.io/otel/metric/noop"
	"go.opentelemetry.io/otel/trace"

	"go.opentelemetry.io/collector/component"
	"go.opentelemetry.io/collector/config/configtelemetry"
)

func Meter(settings component.TelemetrySettings) metric.Meter {
	return settings.MeterProvider.Meter("go.opentelemetry.io/collector/service")
}

func Tracer(settings component.TelemetrySettings) trace.Tracer {
	return settings.TracerProvider.Tracer("go.opentelemetry.io/collector/service")
}

// TelemetryBuilder provides an interface for components to report telemetry
// as defined in metadata and user config.
type TelemetryBuilder struct {
	meter                                    metric.Meter
	ProcessCPUSeconds                        metric.Float64ObservableCounter
	observeProcessCPUSeconds                 func() float64
	ProcessMemoryRss                         metric.Int64ObservableGauge
	observeProcessMemoryRss                  func() int64
	ProcessRuntimeHeapAllocBytes             metric.Int64ObservableGauge
	observeProcessRuntimeHeapAllocBytes      func() int64
	ProcessRuntimeTotalAllocBytes            metric.Int64ObservableCounter
	observeProcessRuntimeTotalAllocBytes     func() int64
	ProcessRuntimeTotalSysMemoryBytes        metric.Int64ObservableGauge
	observeProcessRuntimeTotalSysMemoryBytes func() int64
	ProcessUptime                            metric.Float64ObservableCounter
	observeProcessUptime                     func() float64
	level                                    configtelemetry.Level
	attributeSet                             attribute.Set
}

// telemetryBuilderOption applies changes to default builder.
type telemetryBuilderOption func(*TelemetryBuilder)

// WithLevel sets the current telemetry level for the component.
func WithLevel(lvl configtelemetry.Level) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.level = lvl
	}
}

// WithAttributeSet applies a set of attributes for asynchronous instruments.
func WithAttributeSet(set attribute.Set) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.attributeSet = set
	}
}

// WithProcessCPUSecondsCallback sets callback for observable ProcessCPUSeconds metric.
func WithProcessCPUSecondsCallback(cb func() float64) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.observeProcessCPUSeconds = cb
	}
}

// WithProcessMemoryRssCallback sets callback for observable ProcessMemoryRss metric.
func WithProcessMemoryRssCallback(cb func() int64) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.observeProcessMemoryRss = cb
	}
}

// WithProcessRuntimeHeapAllocBytesCallback sets callback for observable ProcessRuntimeHeapAllocBytes metric.
func WithProcessRuntimeHeapAllocBytesCallback(cb func() int64) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.observeProcessRuntimeHeapAllocBytes = cb
	}
}

// WithProcessRuntimeTotalAllocBytesCallback sets callback for observable ProcessRuntimeTotalAllocBytes metric.
func WithProcessRuntimeTotalAllocBytesCallback(cb func() int64) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.observeProcessRuntimeTotalAllocBytes = cb
	}
}

// WithProcessRuntimeTotalSysMemoryBytesCallback sets callback for observable ProcessRuntimeTotalSysMemoryBytes metric.
func WithProcessRuntimeTotalSysMemoryBytesCallback(cb func() int64) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.observeProcessRuntimeTotalSysMemoryBytes = cb
	}
}

// WithProcessUptimeCallback sets callback for observable ProcessUptime metric.
func WithProcessUptimeCallback(cb func() float64) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.observeProcessUptime = cb
	}
}

// NewTelemetryBuilder provides a struct with methods to update all internal telemetry
// for a component
func NewTelemetryBuilder(settings component.TelemetrySettings, options ...telemetryBuilderOption) (*TelemetryBuilder, error) {
	builder := TelemetryBuilder{level: configtelemetry.LevelBasic}
	for _, op := range options {
		op(&builder)
	}
	var err, errs error
	if builder.level >= configtelemetry.LevelBasic {
		builder.meter = Meter(settings)
	} else {
		builder.meter = noop.Meter{}
	}
	builder.ProcessCPUSeconds, err = builder.meter.Float64ObservableCounter(
		"process_cpu_seconds",
		metric.WithDescription("Total CPU user and system time in seconds"),
		metric.WithUnit("s"),
	)
	errs = errors.Join(errs, err)
	_, err = builder.meter.RegisterCallback(func(_ context.Context, o metric.Observer) error {
		o.ObserveFloat64(builder.ProcessCPUSeconds, builder.observeProcessCPUSeconds(), metric.WithAttributeSet(builder.attributeSet))
		return nil
	}, builder.ProcessCPUSeconds)
	errs = errors.Join(errs, err)
	builder.ProcessMemoryRss, err = builder.meter.Int64ObservableGauge(
		"process_memory_rss",
		metric.WithDescription("Total physical memory (resident set size)"),
		metric.WithUnit("By"),
	)
	errs = errors.Join(errs, err)
	_, err = builder.meter.RegisterCallback(func(_ context.Context, o metric.Observer) error {
		o.ObserveInt64(builder.ProcessMemoryRss, builder.observeProcessMemoryRss(), metric.WithAttributeSet(builder.attributeSet))
		return nil
	}, builder.ProcessMemoryRss)
	errs = errors.Join(errs, err)
	builder.ProcessRuntimeHeapAllocBytes, err = builder.meter.Int64ObservableGauge(
		"process_runtime_heap_alloc_bytes",
		metric.WithDescription("Bytes of allocated heap objects (see 'go doc runtime.MemStats.HeapAlloc')"),
		metric.WithUnit("By"),
	)
	errs = errors.Join(errs, err)
	_, err = builder.meter.RegisterCallback(func(_ context.Context, o metric.Observer) error {
		o.ObserveInt64(builder.ProcessRuntimeHeapAllocBytes, builder.observeProcessRuntimeHeapAllocBytes(), metric.WithAttributeSet(builder.attributeSet))
		return nil
	}, builder.ProcessRuntimeHeapAllocBytes)
	errs = errors.Join(errs, err)
	builder.ProcessRuntimeTotalAllocBytes, err = builder.meter.Int64ObservableCounter(
		"process_runtime_total_alloc_bytes",
		metric.WithDescription("Cumulative bytes allocated for heap objects (see 'go doc runtime.MemStats.TotalAlloc')"),
		metric.WithUnit("By"),
	)
	errs = errors.Join(errs, err)
	_, err = builder.meter.RegisterCallback(func(_ context.Context, o metric.Observer) error {
		o.ObserveInt64(builder.ProcessRuntimeTotalAllocBytes, builder.observeProcessRuntimeTotalAllocBytes(), metric.WithAttributeSet(builder.attributeSet))
		return nil
	}, builder.ProcessRuntimeTotalAllocBytes)
	errs = errors.Join(errs, err)
	builder.ProcessRuntimeTotalSysMemoryBytes, err = builder.meter.Int64ObservableGauge(
		"process_runtime_total_sys_memory_bytes",
		metric.WithDescription("Total bytes of memory obtained from the OS (see 'go doc runtime.MemStats.Sys')"),
		metric.WithUnit("By"),
	)
	errs = errors.Join(errs, err)
	_, err = builder.meter.RegisterCallback(func(_ context.Context, o metric.Observer) error {
		o.ObserveInt64(builder.ProcessRuntimeTotalSysMemoryBytes, builder.observeProcessRuntimeTotalSysMemoryBytes(), metric.WithAttributeSet(builder.attributeSet))
		return nil
	}, builder.ProcessRuntimeTotalSysMemoryBytes)
	errs = errors.Join(errs, err)
	builder.ProcessUptime, err = builder.meter.Float64ObservableCounter(
		"process_uptime",
		metric.WithDescription("Uptime of the process"),
		metric.WithUnit("s"),
	)
	errs = errors.Join(errs, err)
	_, err = builder.meter.RegisterCallback(func(_ context.Context, o metric.Observer) error {
		o.ObserveFloat64(builder.ProcessUptime, builder.observeProcessUptime(), metric.WithAttributeSet(builder.attributeSet))
		return nil
	}, builder.ProcessUptime)
	errs = errors.Join(errs, err)
	return &builder, errs
}
