// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"context"
	"errors"

	"go.opentelemetry.io/otel/attribute"
	"go.opentelemetry.io/otel/metric"
	"go.opentelemetry.io/otel/metric/noop"
	"go.opentelemetry.io/otel/trace"

	"go.opentelemetry.io/collector/component"
	"go.opentelemetry.io/collector/config/configtelemetry"
)

func Meter(settings component.TelemetrySettings) metric.Meter {
	return settings.MeterProvider.Meter("go.opentelemetry.io/collector/processor/batchprocessor")
}

func Tracer(settings component.TelemetrySettings) trace.Tracer {
	return settings.TracerProvider.Tracer("go.opentelemetry.io/collector/processor/batchprocessor")
}

// TelemetryBuilder provides an interface for components to report telemetry
// as defined in metadata and user config.
type TelemetryBuilder struct {
	meter                                    metric.Meter
	ProcessorBatchBatchSendSize              metric.Int64Histogram
	ProcessorBatchBatchSendSizeBytes         metric.Int64Histogram
	ProcessorBatchBatchSizeTriggerSend       metric.Int64Counter
	ProcessorBatchMetadataCardinality        metric.Int64ObservableUpDownCounter
	observeProcessorBatchMetadataCardinality func() int64
	ProcessorBatchTimeoutTriggerSend         metric.Int64Counter
	level                                    configtelemetry.Level
	attributeSet                             attribute.Set
}

// telemetryBuilderOption applies changes to default builder.
type telemetryBuilderOption func(*TelemetryBuilder)

// WithLevel sets the current telemetry level for the component.
func WithLevel(lvl configtelemetry.Level) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.level = lvl
	}
}

// WithAttributeSet applies a set of attributes for asynchronous instruments.
func WithAttributeSet(set attribute.Set) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.attributeSet = set
	}
}

// WithProcessorBatchMetadataCardinalityCallback sets callback for observable ProcessorBatchMetadataCardinality metric.
func WithProcessorBatchMetadataCardinalityCallback(cb func() int64) telemetryBuilderOption {
	return func(builder *TelemetryBuilder) {
		builder.observeProcessorBatchMetadataCardinality = cb
	}
}

// NewTelemetryBuilder provides a struct with methods to update all internal telemetry
// for a component
func NewTelemetryBuilder(settings component.TelemetrySettings, options ...telemetryBuilderOption) (*TelemetryBuilder, error) {
	builder := TelemetryBuilder{level: configtelemetry.LevelBasic}
	for _, op := range options {
		op(&builder)
	}
	var err, errs error
	if builder.level >= configtelemetry.LevelNormal {
		builder.meter = Meter(settings)
	} else {
		builder.meter = noop.Meter{}
	}
	builder.ProcessorBatchBatchSendSize, err = builder.meter.Int64Histogram(
		"processor_batch_batch_send_size",
		metric.WithDescription("Number of units in the batch"),
		metric.WithUnit("1"), metric.WithExplicitBucketBoundaries([]float64{10, 25, 50, 75, 100, 250, 500, 750, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000, 20000, 30000, 50000, 100000}...),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorBatchBatchSendSizeBytes, err = builder.meter.Int64Histogram(
		"processor_batch_batch_send_size_bytes",
		metric.WithDescription("Number of bytes in batch that was sent"),
		metric.WithUnit("By"), metric.WithExplicitBucketBoundaries([]float64{10, 25, 50, 75, 100, 250, 500, 750, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000, 20000, 30000, 50000, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000, 1e+06, 2e+06, 3e+06, 4e+06, 5e+06, 6e+06, 7e+06, 8e+06, 9e+06}...),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorBatchBatchSizeTriggerSend, err = builder.meter.Int64Counter(
		"processor_batch_batch_size_trigger_send",
		metric.WithDescription("Number of times the batch was sent due to a size trigger"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	builder.ProcessorBatchMetadataCardinality, err = builder.meter.Int64ObservableUpDownCounter(
		"processor_batch_metadata_cardinality",
		metric.WithDescription("Number of distinct metadata value combinations being processed"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	_, err = builder.meter.RegisterCallback(func(_ context.Context, o metric.Observer) error {
		o.ObserveInt64(builder.ProcessorBatchMetadataCardinality, builder.observeProcessorBatchMetadataCardinality(), metric.WithAttributeSet(builder.attributeSet))
		return nil
	}, builder.ProcessorBatchMetadataCardinality)
	errs = errors.Join(errs, err)
	builder.ProcessorBatchTimeoutTriggerSend, err = builder.meter.Int64Counter(
		"processor_batch_timeout_trigger_send",
		metric.WithDescription("Number of times the batch was sent due to a timeout trigger"),
		metric.WithUnit("1"),
	)
	errs = errors.Join(errs, err)
	return &builder, errs
}
