// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestExponentialHistogramDataPointBuckets_MoveTo(t *testing.T) {
	ms := generateTestExponentialHistogramDataPointBuckets()
	dest := NewExponentialHistogramDataPointBuckets()
	ms.MoveTo(dest)
	assert.Equal(t, NewExponentialHistogramDataPointBuckets(), ms)
	assert.Equal(t, generateTestExponentialHistogramDataPointBuckets(), dest)
}

func TestExponentialHistogramDataPointBuckets_CopyTo(t *testing.T) {
	ms := NewExponentialHistogramDataPointBuckets()
	orig := NewExponentialHistogramDataPointBuckets()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestExponentialHistogramDataPointBuckets()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestExponentialHistogramDataPointBuckets_Offset(t *testing.T) {
	ms := NewExponentialHistogramDataPointBuckets()
	assert.Equal(t, int32(0), ms.Offset())
	ms.SetOffset(int32(909))
	assert.Equal(t, int32(909), ms.Offset())
}

func TestExponentialHistogramDataPointBuckets_BucketCounts(t *testing.T) {
	ms := NewExponentialHistogramDataPointBuckets()
	assert.Equal(t, []uint64(nil), ms.BucketCounts().AsRaw())
	ms.BucketCounts().FromRaw([]uint64{1, 2, 3})
	assert.Equal(t, []uint64{1, 2, 3}, ms.BucketCounts().AsRaw())
}

func generateTestExponentialHistogramDataPointBuckets() ExponentialHistogramDataPointBuckets {
	tv := NewExponentialHistogramDataPointBuckets()
	fillTestExponentialHistogramDataPointBuckets(tv)
	return tv
}

func fillTestExponentialHistogramDataPointBuckets(tv ExponentialHistogramDataPointBuckets) {
	tv.orig.Offset = int32(909)
	tv.orig.BucketCounts = []uint64{1, 2, 3}
}
