---
title: "Local Registry"
menu:
  main:
    parent: "user"
    identifier: "user-local-registry"
    weight: 3
---
# Local Registry

With kind v0.6.0 there is a new config feature `containerdConfigPatches` that can
be leveraged to configure insecure registries.
The following recipe leverages this to enable a local registry.

## Create A Cluster And Registry

The following shell script will create a local docker registry and a kind cluster
with it enabled.

{{< codeFromFile file="static/examples/kind-with-registry.sh" >}}

## Using The Registry

The registry can be used like this.

1. First we'll pull an image `docker pull gcr.io/google-samples/hello-app:1.0`
2. Then we'll tag the image to use the local registry `docker tag gcr.io/google-samples/hello-app:1.0 localhost:5000/hello-app:1.0`
3. Then we'll push it to the registry `docker push localhost:5000/hello-app:1.0`
4. And now we can use the image `kubectl create deployment hello-server --image=registry:5000/hello-app:1.0`

If you build your own image and tag it like `localhost:5000/image:foo` and then use
it in kubernetes as `registry:5000/image:foo`.

> Note: you may update your local hosts file as well, for example by adding `127.0.0.1 registry` in your laptop's `/etc/hosts`, so you can reference it in a consistent way by simply using `registry:5000`.
