// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2017-2020 Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Port Layer 4 port / protocol pair
//
// +deepequal-gen=true
//
// swagger:model Port
type Port struct {

	// Optional layer 4 port name
	Name string `json:"name,omitempty"`

	// Layer 4 port number
	Port uint16 `json:"port,omitempty"`

	// Layer 4 protocol
	// Enum: [TCP UDP ANY]
	Protocol string `json:"protocol,omitempty"`
}

// Validate validates this port
func (m *Port) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var portTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["TCP","UDP","ANY"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		portTypeProtocolPropEnum = append(portTypeProtocolPropEnum, v)
	}
}

const (

	// PortProtocolTCP captures enum value "TCP"
	PortProtocolTCP string = "TCP"

	// PortProtocolUDP captures enum value "UDP"
	PortProtocolUDP string = "UDP"

	// PortProtocolANY captures enum value "ANY"
	PortProtocolANY string = "ANY"
)

// prop value enum
func (m *Port) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, portTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Port) validateProtocol(formats strfmt.Registry) error {

	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", m.Protocol); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Port) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Port) UnmarshalBinary(b []byte) error {
	var res Port
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
