// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package daemon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/cilium/cilium/api/v1/models"
)

// PatchConfigOKCode is the HTTP code returned for type PatchConfigOK
const PatchConfigOKCode int = 200

/*
PatchConfigOK Success

swagger:response patchConfigOK
*/
type PatchConfigOK struct {
}

// NewPatchConfigOK creates PatchConfigOK with default headers values
func NewPatchConfigOK() *PatchConfigOK {

	return &PatchConfigOK{}
}

// WriteResponse to the client
func (o *PatchConfigOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// PatchConfigBadRequestCode is the HTTP code returned for type PatchConfigBadRequest
const PatchConfigBadRequestCode int = 400

/*
PatchConfigBadRequest Bad configuration parameters

swagger:response patchConfigBadRequest
*/
type PatchConfigBadRequest struct {

	/*
	  In: Body
	*/
	Payload models.Error `json:"body,omitempty"`
}

// NewPatchConfigBadRequest creates PatchConfigBadRequest with default headers values
func NewPatchConfigBadRequest() *PatchConfigBadRequest {

	return &PatchConfigBadRequest{}
}

// WithPayload adds the payload to the patch config bad request response
func (o *PatchConfigBadRequest) WithPayload(payload models.Error) *PatchConfigBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the patch config bad request response
func (o *PatchConfigBadRequest) SetPayload(payload models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PatchConfigBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// PatchConfigForbiddenCode is the HTTP code returned for type PatchConfigForbidden
const PatchConfigForbiddenCode int = 403

/*
PatchConfigForbidden Forbidden

swagger:response patchConfigForbidden
*/
type PatchConfigForbidden struct {
}

// NewPatchConfigForbidden creates PatchConfigForbidden with default headers values
func NewPatchConfigForbidden() *PatchConfigForbidden {

	return &PatchConfigForbidden{}
}

// WriteResponse to the client
func (o *PatchConfigForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(403)
}

// PatchConfigFailureCode is the HTTP code returned for type PatchConfigFailure
const PatchConfigFailureCode int = 500

/*
PatchConfigFailure Recompilation failed

swagger:response patchConfigFailure
*/
type PatchConfigFailure struct {

	/*
	  In: Body
	*/
	Payload models.Error `json:"body,omitempty"`
}

// NewPatchConfigFailure creates PatchConfigFailure with default headers values
func NewPatchConfigFailure() *PatchConfigFailure {

	return &PatchConfigFailure{}
}

// WithPayload adds the payload to the patch config failure response
func (o *PatchConfigFailure) WithPayload(payload models.Error) *PatchConfigFailure {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the patch config failure response
func (o *PatchConfigFailure) SetPayload(payload models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *PatchConfigFailure) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}
