// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package policy

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPutPolicyParams creates a new PutPolicyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPutPolicyParams() *PutPolicyParams {
	return &PutPolicyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPutPolicyParamsWithTimeout creates a new PutPolicyParams object
// with the ability to set a timeout on a request.
func NewPutPolicyParamsWithTimeout(timeout time.Duration) *PutPolicyParams {
	return &PutPolicyParams{
		timeout: timeout,
	}
}

// NewPutPolicyParamsWithContext creates a new PutPolicyParams object
// with the ability to set a context for a request.
func NewPutPolicyParamsWithContext(ctx context.Context) *PutPolicyParams {
	return &PutPolicyParams{
		Context: ctx,
	}
}

// NewPutPolicyParamsWithHTTPClient creates a new PutPolicyParams object
// with the ability to set a custom HTTPClient for a request.
func NewPutPolicyParamsWithHTTPClient(client *http.Client) *PutPolicyParams {
	return &PutPolicyParams{
		HTTPClient: client,
	}
}

/*
PutPolicyParams contains all the parameters to send to the API endpoint

	for the put policy operation.

	Typically these are written to a http.Request.
*/
type PutPolicyParams struct {

	/* Policy.

	   Policy rules
	*/
	Policy string

	/* Replace.

	   If true, indicates that existing rules with identical labels should be replaced.
	*/
	Replace *bool

	/* ReplaceWithLabels.

	   If present, indicates that existing rules with the given labels should be deleted.
	*/
	ReplaceWithLabels []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the put policy params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutPolicyParams) WithDefaults() *PutPolicyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the put policy params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutPolicyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the put policy params
func (o *PutPolicyParams) WithTimeout(timeout time.Duration) *PutPolicyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the put policy params
func (o *PutPolicyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the put policy params
func (o *PutPolicyParams) WithContext(ctx context.Context) *PutPolicyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the put policy params
func (o *PutPolicyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the put policy params
func (o *PutPolicyParams) WithHTTPClient(client *http.Client) *PutPolicyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the put policy params
func (o *PutPolicyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithPolicy adds the policy to the put policy params
func (o *PutPolicyParams) WithPolicy(policy string) *PutPolicyParams {
	o.SetPolicy(policy)
	return o
}

// SetPolicy adds the policy to the put policy params
func (o *PutPolicyParams) SetPolicy(policy string) {
	o.Policy = policy
}

// WithReplace adds the replace to the put policy params
func (o *PutPolicyParams) WithReplace(replace *bool) *PutPolicyParams {
	o.SetReplace(replace)
	return o
}

// SetReplace adds the replace to the put policy params
func (o *PutPolicyParams) SetReplace(replace *bool) {
	o.Replace = replace
}

// WithReplaceWithLabels adds the replaceWithLabels to the put policy params
func (o *PutPolicyParams) WithReplaceWithLabels(replaceWithLabels []string) *PutPolicyParams {
	o.SetReplaceWithLabels(replaceWithLabels)
	return o
}

// SetReplaceWithLabels adds the replaceWithLabels to the put policy params
func (o *PutPolicyParams) SetReplaceWithLabels(replaceWithLabels []string) {
	o.ReplaceWithLabels = replaceWithLabels
}

// WriteToRequest writes these params to a swagger request
func (o *PutPolicyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Policy); err != nil {
		return err
	}

	if o.Replace != nil {

		// query param replace
		var qrReplace bool

		if o.Replace != nil {
			qrReplace = *o.Replace
		}
		qReplace := swag.FormatBool(qrReplace)
		if qReplace != "" {

			if err := r.SetQueryParam("replace", qReplace); err != nil {
				return err
			}
		}
	}

	if o.ReplaceWithLabels != nil {

		// binding items for replace-with-labels
		joinedReplaceWithLabels := o.bindParamReplaceWithLabels(reg)

		// query array param replace-with-labels
		if err := r.SetQueryParam("replace-with-labels", joinedReplaceWithLabels...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPutPolicy binds the parameter replace-with-labels
func (o *PutPolicyParams) bindParamReplaceWithLabels(formats strfmt.Registry) []string {
	replaceWithLabelsIR := o.ReplaceWithLabels

	var replaceWithLabelsIC []string
	for _, replaceWithLabelsIIR := range replaceWithLabelsIR { // explode []string

		replaceWithLabelsIIV := replaceWithLabelsIIR // string as string
		replaceWithLabelsIC = append(replaceWithLabelsIC, replaceWithLabelsIIV)
	}

	// items.CollectionFormat: ""
	replaceWithLabelsIS := swag.JoinByFormat(replaceWithLabelsIC, "")

	return replaceWithLabelsIS
}
