// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package ipam

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// PostIpamIPReader is a Reader for the PostIpamIP structure.
type PostIpamIPReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PostIpamIPReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPostIpamIPOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPostIpamIPInvalid()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPostIpamIPForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewPostIpamIPExists()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPostIpamIPFailure()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewPostIpamIPDisabled()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /ipam/{ip}] PostIpamIP", response, response.Code())
	}
}

// NewPostIpamIPOK creates a PostIpamIPOK with default headers values
func NewPostIpamIPOK() *PostIpamIPOK {
	return &PostIpamIPOK{}
}

/*
PostIpamIPOK describes a response with status code 200, with default header values.

Success
*/
type PostIpamIPOK struct {
}

// IsSuccess returns true when this post ipam Ip o k response has a 2xx status code
func (o *PostIpamIPOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this post ipam Ip o k response has a 3xx status code
func (o *PostIpamIPOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post ipam Ip o k response has a 4xx status code
func (o *PostIpamIPOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this post ipam Ip o k response has a 5xx status code
func (o *PostIpamIPOK) IsServerError() bool {
	return false
}

// IsCode returns true when this post ipam Ip o k response a status code equal to that given
func (o *PostIpamIPOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the post ipam Ip o k response
func (o *PostIpamIPOK) Code() int {
	return 200
}

func (o *PostIpamIPOK) Error() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpOK ", 200)
}

func (o *PostIpamIPOK) String() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpOK ", 200)
}

func (o *PostIpamIPOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPostIpamIPInvalid creates a PostIpamIPInvalid with default headers values
func NewPostIpamIPInvalid() *PostIpamIPInvalid {
	return &PostIpamIPInvalid{}
}

/*
PostIpamIPInvalid describes a response with status code 400, with default header values.

Invalid IP address
*/
type PostIpamIPInvalid struct {
}

// IsSuccess returns true when this post ipam Ip invalid response has a 2xx status code
func (o *PostIpamIPInvalid) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post ipam Ip invalid response has a 3xx status code
func (o *PostIpamIPInvalid) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post ipam Ip invalid response has a 4xx status code
func (o *PostIpamIPInvalid) IsClientError() bool {
	return true
}

// IsServerError returns true when this post ipam Ip invalid response has a 5xx status code
func (o *PostIpamIPInvalid) IsServerError() bool {
	return false
}

// IsCode returns true when this post ipam Ip invalid response a status code equal to that given
func (o *PostIpamIPInvalid) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the post ipam Ip invalid response
func (o *PostIpamIPInvalid) Code() int {
	return 400
}

func (o *PostIpamIPInvalid) Error() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpInvalid ", 400)
}

func (o *PostIpamIPInvalid) String() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpInvalid ", 400)
}

func (o *PostIpamIPInvalid) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPostIpamIPForbidden creates a PostIpamIPForbidden with default headers values
func NewPostIpamIPForbidden() *PostIpamIPForbidden {
	return &PostIpamIPForbidden{}
}

/*
PostIpamIPForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PostIpamIPForbidden struct {
}

// IsSuccess returns true when this post ipam Ip forbidden response has a 2xx status code
func (o *PostIpamIPForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post ipam Ip forbidden response has a 3xx status code
func (o *PostIpamIPForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post ipam Ip forbidden response has a 4xx status code
func (o *PostIpamIPForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this post ipam Ip forbidden response has a 5xx status code
func (o *PostIpamIPForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this post ipam Ip forbidden response a status code equal to that given
func (o *PostIpamIPForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the post ipam Ip forbidden response
func (o *PostIpamIPForbidden) Code() int {
	return 403
}

func (o *PostIpamIPForbidden) Error() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpForbidden ", 403)
}

func (o *PostIpamIPForbidden) String() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpForbidden ", 403)
}

func (o *PostIpamIPForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPostIpamIPExists creates a PostIpamIPExists with default headers values
func NewPostIpamIPExists() *PostIpamIPExists {
	return &PostIpamIPExists{}
}

/*
PostIpamIPExists describes a response with status code 409, with default header values.

IP already allocated
*/
type PostIpamIPExists struct {
}

// IsSuccess returns true when this post ipam Ip exists response has a 2xx status code
func (o *PostIpamIPExists) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post ipam Ip exists response has a 3xx status code
func (o *PostIpamIPExists) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post ipam Ip exists response has a 4xx status code
func (o *PostIpamIPExists) IsClientError() bool {
	return true
}

// IsServerError returns true when this post ipam Ip exists response has a 5xx status code
func (o *PostIpamIPExists) IsServerError() bool {
	return false
}

// IsCode returns true when this post ipam Ip exists response a status code equal to that given
func (o *PostIpamIPExists) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the post ipam Ip exists response
func (o *PostIpamIPExists) Code() int {
	return 409
}

func (o *PostIpamIPExists) Error() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpExists ", 409)
}

func (o *PostIpamIPExists) String() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpExists ", 409)
}

func (o *PostIpamIPExists) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPostIpamIPFailure creates a PostIpamIPFailure with default headers values
func NewPostIpamIPFailure() *PostIpamIPFailure {
	return &PostIpamIPFailure{}
}

/*
PostIpamIPFailure describes a response with status code 500, with default header values.

IP allocation failure. Details in message.
*/
type PostIpamIPFailure struct {
	Payload models.Error
}

// IsSuccess returns true when this post ipam Ip failure response has a 2xx status code
func (o *PostIpamIPFailure) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post ipam Ip failure response has a 3xx status code
func (o *PostIpamIPFailure) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post ipam Ip failure response has a 4xx status code
func (o *PostIpamIPFailure) IsClientError() bool {
	return false
}

// IsServerError returns true when this post ipam Ip failure response has a 5xx status code
func (o *PostIpamIPFailure) IsServerError() bool {
	return true
}

// IsCode returns true when this post ipam Ip failure response a status code equal to that given
func (o *PostIpamIPFailure) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the post ipam Ip failure response
func (o *PostIpamIPFailure) Code() int {
	return 500
}

func (o *PostIpamIPFailure) Error() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpFailure  %+v", 500, o.Payload)
}

func (o *PostIpamIPFailure) String() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpFailure  %+v", 500, o.Payload)
}

func (o *PostIpamIPFailure) GetPayload() models.Error {
	return o.Payload
}

func (o *PostIpamIPFailure) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostIpamIPDisabled creates a PostIpamIPDisabled with default headers values
func NewPostIpamIPDisabled() *PostIpamIPDisabled {
	return &PostIpamIPDisabled{}
}

/*
PostIpamIPDisabled describes a response with status code 501, with default header values.

Allocation for address family disabled
*/
type PostIpamIPDisabled struct {
}

// IsSuccess returns true when this post ipam Ip disabled response has a 2xx status code
func (o *PostIpamIPDisabled) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post ipam Ip disabled response has a 3xx status code
func (o *PostIpamIPDisabled) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post ipam Ip disabled response has a 4xx status code
func (o *PostIpamIPDisabled) IsClientError() bool {
	return false
}

// IsServerError returns true when this post ipam Ip disabled response has a 5xx status code
func (o *PostIpamIPDisabled) IsServerError() bool {
	return true
}

// IsCode returns true when this post ipam Ip disabled response a status code equal to that given
func (o *PostIpamIPDisabled) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the post ipam Ip disabled response
func (o *PostIpamIPDisabled) Code() int {
	return 501
}

func (o *PostIpamIPDisabled) Error() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpDisabled ", 501)
}

func (o *PostIpamIPDisabled) String() string {
	return fmt.Sprintf("[POST /ipam/{ip}][%d] postIpamIpDisabled ", 501)
}

func (o *PostIpamIPDisabled) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
