// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Tetragon

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/cilium/tetragon/pkg/k8s/apis/cilium.io/v1alpha1"
	scheme "github.com/cilium/tetragon/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PodInfoGetter has a method to return a PodInfoInterface.
// A group's client should implement this interface.
type PodInfoGetter interface {
	PodInfo(namespace string) PodInfoInterface
}

// PodInfoInterface has methods to work with PodInfo resources.
type PodInfoInterface interface {
	Create(ctx context.Context, podInfo *v1alpha1.PodInfo, opts v1.CreateOptions) (*v1alpha1.PodInfo, error)
	Update(ctx context.Context, podInfo *v1alpha1.PodInfo, opts v1.UpdateOptions) (*v1alpha1.PodInfo, error)
	UpdateStatus(ctx context.Context, podInfo *v1alpha1.PodInfo, opts v1.UpdateOptions) (*v1alpha1.PodInfo, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.PodInfo, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.PodInfoList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PodInfo, err error)
	PodInfoExpansion
}

// podInfo implements PodInfoInterface
type podInfo struct {
	client rest.Interface
	ns     string
}

// newPodInfo returns a PodInfo
func newPodInfo(c *CiliumV1alpha1Client, namespace string) *podInfo {
	return &podInfo{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the podInfo, and returns the corresponding podInfo object, and an error if there is any.
func (c *podInfo) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.PodInfo, err error) {
	result = &v1alpha1.PodInfo{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podinfo").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PodInfo that match those selectors.
func (c *podInfo) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.PodInfoList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.PodInfoList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("podinfo").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested podInfo.
func (c *podInfo) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("podinfo").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a podInfo and creates it.  Returns the server's representation of the podInfo, and an error, if there is any.
func (c *podInfo) Create(ctx context.Context, podInfo *v1alpha1.PodInfo, opts v1.CreateOptions) (result *v1alpha1.PodInfo, err error) {
	result = &v1alpha1.PodInfo{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("podinfo").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podInfo).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a podInfo and updates it. Returns the server's representation of the podInfo, and an error, if there is any.
func (c *podInfo) Update(ctx context.Context, podInfo *v1alpha1.PodInfo, opts v1.UpdateOptions) (result *v1alpha1.PodInfo, err error) {
	result = &v1alpha1.PodInfo{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podinfo").
		Name(podInfo.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podInfo).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *podInfo) UpdateStatus(ctx context.Context, podInfo *v1alpha1.PodInfo, opts v1.UpdateOptions) (result *v1alpha1.PodInfo, err error) {
	result = &v1alpha1.PodInfo{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("podinfo").
		Name(podInfo.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(podInfo).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the podInfo and deletes it. Returns an error if one occurs.
func (c *podInfo) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podinfo").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *podInfo) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("podinfo").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched podInfo.
func (c *podInfo) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PodInfo, err error) {
	result = &v1alpha1.PodInfo{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("podinfo").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
