// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ModulesHealth Reports health status of agent's modules
//
// swagger:model ModulesHealth
type ModulesHealth struct {

	// List out modules health status
	Modules []*ModuleHealth `json:"modules"`
}

// Validate validates this modules health
func (m *ModulesHealth) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateModules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ModulesHealth) validateModules(formats strfmt.Registry) error {
	if swag.IsZero(m.Modules) { // not required
		return nil
	}

	for i := 0; i < len(m.Modules); i++ {
		if swag.IsZero(m.Modules[i]) { // not required
			continue
		}

		if m.Modules[i] != nil {
			if err := m.Modules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("modules" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("modules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this modules health based on the context it is used
func (m *ModulesHealth) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateModules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ModulesHealth) contextValidateModules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Modules); i++ {

		if m.Modules[i] != nil {
			if err := m.Modules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("modules" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("modules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ModulesHealth) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ModulesHealth) UnmarshalBinary(b []byte) error {
	var res ModulesHealth
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
