// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package endpoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// PatchEndpointIDReader is a Reader for the PatchEndpointID structure.
type PatchEndpointIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PatchEndpointIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPatchEndpointIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPatchEndpointIDInvalid()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewPatchEndpointIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPatchEndpointIDTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPatchEndpointIDFailed()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPatchEndpointIDOK creates a PatchEndpointIDOK with default headers values
func NewPatchEndpointIDOK() *PatchEndpointIDOK {
	return &PatchEndpointIDOK{}
}

/*PatchEndpointIDOK handles this case with default header values.

Success
*/
type PatchEndpointIDOK struct {
}

func (o *PatchEndpointIDOK) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdOK ", 200)
}

func (o *PatchEndpointIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDInvalid creates a PatchEndpointIDInvalid with default headers values
func NewPatchEndpointIDInvalid() *PatchEndpointIDInvalid {
	return &PatchEndpointIDInvalid{}
}

/*PatchEndpointIDInvalid handles this case with default header values.

Invalid modify endpoint request
*/
type PatchEndpointIDInvalid struct {
	Payload models.Error
}

func (o *PatchEndpointIDInvalid) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdInvalid  %+v", 400, o.Payload)
}

func (o *PatchEndpointIDInvalid) GetPayload() models.Error {
	return o.Payload
}

func (o *PatchEndpointIDInvalid) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchEndpointIDNotFound creates a PatchEndpointIDNotFound with default headers values
func NewPatchEndpointIDNotFound() *PatchEndpointIDNotFound {
	return &PatchEndpointIDNotFound{}
}

/*PatchEndpointIDNotFound handles this case with default header values.

Endpoint does not exist
*/
type PatchEndpointIDNotFound struct {
}

func (o *PatchEndpointIDNotFound) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdNotFound ", 404)
}

func (o *PatchEndpointIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDTooManyRequests creates a PatchEndpointIDTooManyRequests with default headers values
func NewPatchEndpointIDTooManyRequests() *PatchEndpointIDTooManyRequests {
	return &PatchEndpointIDTooManyRequests{}
}

/*PatchEndpointIDTooManyRequests handles this case with default header values.

Rate-limiting too many requests in the given time frame
*/
type PatchEndpointIDTooManyRequests struct {
}

func (o *PatchEndpointIDTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdTooManyRequests ", 429)
}

func (o *PatchEndpointIDTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchEndpointIDFailed creates a PatchEndpointIDFailed with default headers values
func NewPatchEndpointIDFailed() *PatchEndpointIDFailed {
	return &PatchEndpointIDFailed{}
}

/*PatchEndpointIDFailed handles this case with default header values.

Endpoint update failed
*/
type PatchEndpointIDFailed struct {
	Payload models.Error
}

func (o *PatchEndpointIDFailed) Error() string {
	return fmt.Sprintf("[PATCH /endpoint/{id}][%d] patchEndpointIdFailed  %+v", 500, o.Payload)
}

func (o *PatchEndpointIDFailed) GetPayload() models.Error {
	return o.Payload
}

func (o *PatchEndpointIDFailed) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
