// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2017-2021 Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// WireguardPeer Status of a Wireguard peer
//
// +k8s:deepcopy-gen=true
//
// swagger:model WireguardPeer
type WireguardPeer struct {

	// List of IPs which may be routed through this peer
	AllowedIps []string `json:"allowed-ips"`

	// Endpoint on which we are connected to this peer
	Endpoint string `json:"endpoint,omitempty"`

	// Timestamp of the last handshake with this peer
	// Format: date-time
	LastHandshakeTime strfmt.DateTime `json:"last-handshake-time,omitempty"`

	// Public key of this peer
	PublicKey string `json:"public-key,omitempty"`

	// Number of received bytes
	TransferRx int64 `json:"transfer-rx,omitempty"`

	// Number of sent bytes
	TransferTx int64 `json:"transfer-tx,omitempty"`
}

// Validate validates this wireguard peer
func (m *WireguardPeer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLastHandshakeTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *WireguardPeer) validateLastHandshakeTime(formats strfmt.Registry) error {

	if swag.IsZero(m.LastHandshakeTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last-handshake-time", "body", "date-time", m.LastHandshakeTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *WireguardPeer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *WireguardPeer) UnmarshalBinary(b []byte) error {
	var res WireguardPeer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
