# v2.6 to 2.7

## Configure RBAC to account for new `extensions` resource

2.7 introduces the new [Proxy Extensions][1] feature with a new `extensions`
[RBAC resource][2].

When you upgrade to 2.7, RBAC policies with `*` in the *resource*
field and `*` in the action field, it will automatically grant the
`extensions` privilege.

The Proxy Extension feature is disabled by default, however it is
recommended to check your RBAC configurations to enforce the least
necessary privileges.

Example
Old:

```csv
p, role:org-admin, *, *, *, allow
```

New:

```csv
p, role:org-admin, clusters, create, my-proj/*, allow
p, role:org-admin, projects, create, my-proj/*, allow
p, role:org-admin, applications, create, my-proj/*, allow
p, role:org-admin, repositories, create, my-proj/*, allow
p, role:org-admin, certificates, create, my-proj/*, allow
p, role:org-admin, accounts, create, my-proj/*, allow
p, role:org-admin, gpgkeys, create, my-proj/*, allow
# If you don't want to grant the new permission, don't include the following line
p, role:org-admin, extensions, invoke, my-proj/*, allow
```

## Upgraded Helm Version

Note that bundled Helm version has been upgraded from 3.10.3 to 3.11.2.

## Upgraded Kustomize Version

Note that bundled Kustomize version has been upgraded from 4.5.7 to 5.0.1.

## Notifications: `^` behavior change in Sprig's semver functions
Argo CD 2.7 upgrades Sprig templating specifically within Argo CD notifications to v3. That upgrade includes an upgrade of [Masterminds/semver](https://github.com/Masterminds/semver/releases) to v3.

Masterminds/semver v3 changed the behavior of the `^` prefix in semantic version constraints. If you are using sprig template functions in your notifications templates which include references to [Sprig's semver functions](https://masterminds.github.io/sprig/semver.html) and use the `^` prefix, read the [Masterminds/semver changelog](https://github.com/Masterminds/semver/releases/tag/v3.0.0) to understand how your notifications' behavior may change.

## Tini as entrypoint

The manifests are now using [`tini` as entrypoint][3], instead of `entrypoint.sh`. Until 2.8, `entrypoint.sh` is retained for upgrade compatibility. This means that the deployment manifests have to be updated after upgrading to 2.7, and before upgrading to 2.8 later. In case the manifests are updated before moving to 2.8, the containers will not be able to start.

[1]: ../../developer-guide/extensions/proxy-extensions.md
[2]: https://argo-cd.readthedocs.io/en/stable/operator-manual/rbac/#the-extensions-resource
[3]: https://github.com/argoproj/argo-cd/pull/12707


## Deep Links template updates

Deep Links now allow you to access other values like `cluster`, `project`, `application` and `resource` in the url and condition templates for specific categories of links.
The templating syntax has also been updated to be prefixed with the type of resource you want to access for example previously if you had a `resource.links` config like :
```yaml
  resource.links: |
    - url: https://mycompany.splunk.com?search={{.metadata.name}}
      title: Splunk
      if: kind == "Pod" || kind == "Deployment"
```
This would become :
```yaml
  resource.links: |
    - url: https://mycompany.splunk.com?search={{.resource.metadata.name}}&env={{.project.metadata.label.env}}
      title: Splunk
      if: resource.kind == "Pod" || resource.kind == "Deployment"
```

Read the full [documentation](../deep_links.md) to see all possible combinations of values accessible fo each category of links.

## Support of `helm.sh/resource-policy` annotation

Argo CD now supports the `helm.sh/resource-policy` annotation to control the deletion of resources. The behavior is the same as the behavior of
`argocd.argoproj.io/sync-options: Delete=false` annotation: if the annotation is present and set to `keep`, the resource will not be deleted
when the application is deleted.

## Check your Kustomize patches for `--redis` changes

Starting in Argo CD 2.7, the install manifests no longer pass the Redis server name via `--redis`. 

If your environment uses Kustomize JSON patches to modify the Redis server name, the patch might break when you upgrade
to the 2.7 manifests. If it does, you can remove the patch and instead set the Redis server name via the `redis.server` 
field in the argocd-cmd-params-cm ConfigMap. That value will be passed to the necessary components via `valueFrom` 
environment variables.
