# v2.3 to 2.4

## KSonnet support is removed

The [https://ksonnet.io/] had been deprecated in [2019](https://github.com/ksonnet/ksonnet/pull/914/files) and no longer maintained.
The time has come to remove it from the ArgoCD.

## Helm 2 support is removed

Helm 2 is not been officially supported since [Nov 2020](https://helm.sh/blog/helm-2-becomes-unsupported/). In order to ensure a smooth transition
Helm 2 support was preserved in the Argo CD. We feel that Helm 3 is stable and it is time to drop Helm 2 support.


## Configure RBAC to account for new `exec` resource

2.4 introduces a new `exec` [RBAC resource](https://argo-cd.readthedocs.io/en/stable/operator-manual/rbac/#rbac-resources-and-actions).

When you upgrade to 2.4, RBAC policies with `*` in the resource field and `create` or `*` in the verb field will automatically grant the `exec` privilege.

To avoid granting the new privilege, replace the existing policy with a list of new policies explicitly listing the old resources.

The exec feature is [disabled by default](https://argo-cd.readthedocs.io/en/stable/operator-manual/rbac/#exec-resource), 
but it is still a good idea to double-check your RBAC configuration to enforce least necessary privileges.

### Example

Old:

```csv
p, role:org-admin, *, create, my-proj/*, allow
```

New:

```csv
p, role: org-admin, clusters, create, my-proj/*, allow
p, role: org-admin, projects, create, my-proj/*, allow
p, role: org-admin, applications, create, my-proj/*, allow
p, role: org-admin, repositories, create, my-proj/*, allow
p, role: org-admin, certificates, create, my-proj/*, allow
p, role: org-admin, accounts, create, my-proj/*, allow
p, role: org-admin, gpgkeys, create, my-proj/*, allow
```

## Remove the shared volume from any sidecar plugins

As a security enhancement, [sidecar plugins](../../user-guide/config-management-plugins.md#option-2-configure-plugin-via-sidecar)
no longer share the /tmp directory with the repo-server.

If you have one or more sidecar plugins enabled, remove the /tmp volume mount from the plugin container definition.

```yaml
apiVersion: apps/v1
kind: Deployment
metadata:
  name: argocd-repo-server
spec:
  template:
    spec:
      containers:
      - name: your-plugin-name
        volumeMounts:
        # Remove the next two lines:
        - mountPath: /tmp
          name: tmp
```
