# Annotations and Labels used by Argo CD

## Annotations

| Annotation key                             | Target resource(es) | Possible values                                                                                   | Description                                                                                                                                                                                                  |
|--------------------------------------------|---------------------|---------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| argocd.argoproj.io/application-set-refresh | ApplicationSet      | `"true"`                                                                                          | Added when an ApplicationSet is requested to be refreshed by a webhook. The ApplicationSet controller will remove this annotation at the end of reconciliation.                                              |
| argocd.argoproj.io/compare-options         | any                 | [see compare options docs](compare-options.md)                                                    | Configures how an app's current state is compared to its desired state.                                                                                                                                      |
| argocd.argoproj.io/hook                    | any                 | [see resource hooks docs](resource_hooks.md)                                                      | Used to configure [resource hooks](resource_hooks.md).                                                                                                                                                       |
| argocd.argoproj.io/hook-delete-policy      | any                 | [see resource hooks docs](resource_hooks.md#hook-deletion-policies)                               | Used to set a [resource hook's deletion policy](resource_hooks.md#hook-deletion-policies).                                                                                                                   |
| argocd.argoproj.io/manifest-generate-paths | Application         | [see scaling docs](../operator-manual/high_availability.md#webhook-and-manifest-paths-annotation) | Used to avoid unnecessary Application refreshes, especially in mono-repos.                                                                                                                                   |
| argocd.argoproj.io/refresh                 | Application         | `normal`, `hard`                                                                                  | Indicates that app needs to be refreshed. Removed by application controller after app is refreshed. Value `"hard"` means manifest cache and target cluster state cache should be invalidated before refresh. |
| argocd.argoproj.io/skip-reconcile          | Application         | `"true"`                                                                                          | Indicates to the Argo CD application controller that the Application should not be reconciled. See the [skip reconcile documentation](skip_reconcile.md) for use cases.                                      |
| argocd.argoproj.io/sync-options            | any                 | [see sync options docs](sync-options.md)                                                          | Provides a variety of settings to determine how an Application's resources are synced.                                                                                                                       |
| argocd.argoproj.io/sync-wave               | any                 | [see sync waves docs](sync-waves.md)                                                              |                                                                                                                                                                                                              |
| argocd.argoproj.io/tracking-id             | any                 | any                                                                                               | Used by Argo CD to track resources it manages. See [resource tracking docs](resource_tracking.md) for details.                                                                                               |
| argocd.argoproj.io/ignore-resource-updates | any                 | `"true"`, `false`                                                                                  | Used by Argo CD to ignore resource updates. See [reconcile docs](..%2Foperator-manual%2Freconcile.md)reconcile_docs for details.                                                                             |
| link.argocd.argoproj.io/{some link name}   | any                 | An http(s) URL                                                                                    | Adds a link to the Argo CD UI for the resource. See [external URL docs](external-url.md) for details.                                                                                                        |
| pref.argocd.argoproj.io/default-pod-sort   | Application         | [see UI customization docs](../operator-manual/ui-customization.md)                               | Sets the Application's default grouping mechanism.                                                                                                                                                           |
| pref.argocd.argoproj.io/default-view       | Application         | [see UI customization docs](../operator-manual/ui-customization.md)                               | Sets the Application's default view mode (e.g. "tree" or "list")                                                                                                                                             |

## Labels

| Label key                      | Target resource(es) | Possible values                       | Description                                                                                                                                                      |
|--------------------------------|---------------------|---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| argocd.argoproj.io/instance    | Application         | any                                   | Recommended tracking label to [avoid conflicts with other tools which use `app.kubernetes.io/instance`](../faq.md#why-is-my-app-out-of-sync-even-after-syncing). |
| argocd.argoproj.io/secret-type | Secret              | `cluster`, `repository`, `repo-creds` | Identifies certain types of Secrets used by Argo CD. See the [Declarative Setup docs](../operator-manual/declarative-setup.md) for details.                      |
