/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.crimson.parser.AttributeDecl;
import org.apache.crimson.parser.ContentModel;
import org.apache.crimson.parser.ContentModelState;
import org.apache.crimson.parser.ElementDecl;
import org.apache.crimson.parser.ElementValidator;
import org.apache.crimson.parser.EndOfInputException;
import org.apache.crimson.parser.ExternalEntity;
import org.apache.crimson.parser.Parser2;
import org.apache.crimson.parser.SimpleHashtable;
import org.apache.crimson.util.XmlNames;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingParser
extends Parser2 {
    private SimpleHashtable ids = new SimpleHashtable();
    private final EmptyValidator EMPTY = new EmptyValidator();

    public ValidatingParser() {
        this.setIsValidating(true);
    }

    public ValidatingParser(boolean rejectValidityErrors) {
        this();
        if (rejectValidityErrors) {
            this.setErrorHandler(new HandlerBase(){

                public void error(SAXParseException x) throws SAXException {
                    throw x;
                }
            });
        }
    }

    void afterRoot() throws SAXException {
        Enumeration e = this.ids.keys();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            Boolean value = (Boolean)this.ids.get(id);
            if (Boolean.FALSE != value) continue;
            this.error("V-024", new Object[]{id});
        }
    }

    void afterDocument() {
        this.ids.clear();
    }

    void validateAttributeSyntax(AttributeDecl attr, String value) throws SAXException {
        if ("ID" == attr.type) {
            Boolean b;
            if (!XmlNames.isName(value)) {
                this.error("V-025", new Object[]{value});
            }
            if ((b = (Boolean)this.ids.getNonInterned(value)) == null || b.equals(Boolean.FALSE)) {
                this.ids.put(value.intern(), Boolean.TRUE);
            } else {
                this.error("V-026", new Object[]{value});
            }
        } else if ("IDREF" == attr.type) {
            Boolean b;
            if (!XmlNames.isName(value)) {
                this.error("V-027", new Object[]{value});
            }
            if ((b = (Boolean)this.ids.getNonInterned(value)) == null) {
                this.ids.put(value.intern(), Boolean.FALSE);
            }
        } else if ("IDREFS" == attr.type) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            boolean sawValue = false;
            while (tokenizer.hasMoreTokens()) {
                Boolean b;
                value = tokenizer.nextToken();
                if (!XmlNames.isName(value)) {
                    this.error("V-027", new Object[]{value});
                }
                if ((b = (Boolean)this.ids.getNonInterned(value)) == null) {
                    this.ids.put(value.intern(), Boolean.FALSE);
                }
                sawValue = true;
            }
            if (!sawValue) {
                this.error("V-039", null);
            }
        } else if ("NMTOKEN" == attr.type) {
            if (!XmlNames.isNmtoken(value)) {
                this.error("V-028", new Object[]{value});
            }
        } else if ("NMTOKENS" == attr.type) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            boolean sawValue = false;
            while (tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
                if (!XmlNames.isNmtoken(value)) {
                    this.error("V-028", new Object[]{value});
                }
                sawValue = true;
            }
            if (!sawValue) {
                this.error("V-032", null);
            }
        } else if ("ENUMERATION" == attr.type) {
            int i = 0;
            while (i < attr.values.length) {
                if (value.equals(attr.values[i])) {
                    return;
                }
                ++i;
            }
            this.error("V-029", new Object[]{value});
        } else if ("NOTATION" == attr.type) {
            int i = 0;
            while (i < attr.values.length) {
                if (value.equals(attr.values[i])) {
                    return;
                }
                ++i;
            }
            this.error("V-030", new Object[]{value});
        } else if ("ENTITY" == attr.type) {
            if (!this.isUnparsedEntity(value)) {
                this.error("V-031", new Object[]{value});
            }
        } else if ("ENTITIES" == attr.type) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            boolean sawValue = false;
            while (tokenizer.hasMoreTokens()) {
                value = tokenizer.nextToken();
                if (!this.isUnparsedEntity(value)) {
                    this.error("V-031", new Object[]{value});
                }
                sawValue = true;
            }
            if (!sawValue) {
                this.error("V-040", null);
            }
        } else if ("CDATA" != attr.type) {
            throw new InternalError(attr.type);
        }
    }

    ContentModel newContentModel(String tag) {
        return new ContentModel(tag);
    }

    ContentModel newContentModel(char type, ContentModel next) {
        return new ContentModel(type, next);
    }

    ElementValidator newValidator(ElementDecl element) {
        if (element.validator != null) {
            return element.validator;
        }
        if (element.model != null) {
            return new ChildrenValidator(element);
        }
        element.validator = element.contentType == null || "ANY" == element.contentType ? ElementValidator.ANY : ("EMPTY" == element.contentType ? this.EMPTY : new MixedValidator(element));
        return element.validator;
    }

    private boolean isUnparsedEntity(String name) {
        Object e = this.entities.getNonInterned(name);
        if (e == null || !(e instanceof ExternalEntity)) {
            return false;
        }
        return ((ExternalEntity)e).notation != null;
    }

    class ChildrenValidator
    extends ElementValidator {
        private ContentModelState state;
        private String name;

        ChildrenValidator(ElementDecl element) {
            this.state = new ContentModelState(element.model);
            this.name = element.name;
        }

        public void consume(String token) throws SAXException {
            if (this.state == null) {
                ValidatingParser.this.error("V-035", new Object[]{this.name, token});
            } else {
                try {
                    this.state = this.state.advance(token);
                }
                catch (EndOfInputException e) {
                    ValidatingParser.this.error("V-036", new Object[]{this.name, token});
                }
            }
        }

        public void text() throws SAXException {
            ValidatingParser.this.error("V-037", new Object[]{this.name});
        }

        public void done() throws SAXException {
            if (this.state != null && !this.state.terminate()) {
                ValidatingParser.this.error("V-038", new Object[]{this.name});
            }
        }
    }

    class MixedValidator
    extends ElementValidator {
        private ElementDecl element;

        MixedValidator(ElementDecl element) {
            this.element = element;
        }

        public void consume(String type) throws SAXException {
            String model = this.element.contentType;
            int index = 8;
            while ((index = model.indexOf(type, index + 1)) >= 9) {
                char c;
                if (model.charAt(index - 1) != '|' || (c = model.charAt(index + type.length())) != '|' && c != ')') continue;
                return;
            }
            ValidatingParser.this.error("V-034", new Object[]{this.element.name, type, model});
        }
    }

    class EmptyValidator
    extends ElementValidator {
        EmptyValidator() {
        }

        public void consume(String token) throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }

        public void text() throws SAXException {
            ValidatingParser.this.error("V-033", null);
        }
    }
}

