/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wml.dom;

import org.apache.wml.WMLTemplateElement;

/**
 * @xerces.internal
 * @version $Id: WMLTemplateElementImpl.java 665720 2008-06-09 15:28:43Z mrglavas $
 * @author <a href="mailto:david@topware.com.tw">David Li</a>
 */
public class WMLTemplateElementImpl extends WMLElementImpl implements WMLTemplateElement {
    
    private static final long serialVersionUID = 4231732841621131049L;

    public WMLTemplateElementImpl (WMLDocumentImpl owner, String tagName) {
        super( owner, tagName);
    }
    
    public void setOnTimer(String newValue) {
        setAttribute("ontimer", newValue);
    }
    
    public String getOnTimer() {
        return getAttribute("ontimer");
    }
    
    public void setOnEnterBackward(String newValue) {
        setAttribute("onenterbackward", newValue);
    }
    
    public String getOnEnterBackward() {
        return getAttribute("onenterbackward");
    }
    
    public void setClassName(String newValue) {
        setAttribute("class", newValue);
    }
    
    public String getClassName() {
        return getAttribute("class");
    }
    
    public void setId(String newValue) {
        setAttribute("id", newValue);
    }
    
    public String getId() {
        return getAttribute("id");
    }
    
    public void setOnEnterForward(String newValue) {
        setAttribute("onenterforward", newValue);
    }
    
    public String getOnEnterForward() {
        return getAttribute("onenterforward");
    }
    
}
