/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tree.DefaultTreeState;
import org.apache.wicket.extensions.markup.html.tree.ITreeState;
import org.apache.wicket.extensions.markup.html.tree.ITreeStateListener;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.html.list.AbstractItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

@Deprecated
public abstract class AbstractTree
extends Panel
implements ITreeStateListener,
TreeModelListener,
AjaxRequestTarget.ITargetRespondListener {
    private static final long serialVersionUID = 1L;
    private boolean attached = false;
    private final AppendingStringBuffer deleteIds = new AppendingStringBuffer();
    private boolean dirtyAll = false;
    private final Set<TreeItem> dirtyItems = new HashSet<TreeItem>();
    private final Set<TreeItem> dirtyItemsCreateDOM = new HashSet<TreeItem>();
    private int idCounter = 0;
    private TreeItemContainer itemContainer;
    private final Map<Object, TreeItem> nodeToItemMap = new HashMap<Object, TreeItem>();
    private TreeModel previousModel = null;
    private TreeItem rootItem = null;
    private boolean rootLess = false;
    private ITreeState state;
    private static final ResourceReference JAVASCRIPT = new JavaScriptResourceReference(AbstractTree.class, "res/tree.js");

    public AbstractTree(String id) {
        super(id);
        this.init();
    }

    public AbstractTree(String id, IModel<? extends TreeModel> model) {
        super(id, model);
        this.init();
    }

    @Override
    public final void allNodesCollapsed() {
        this.invalidateAll();
    }

    @Override
    public final void allNodesExpanded() {
        this.invalidateAll();
    }

    public IModel<? extends TreeModel> getModel() {
        return this.getDefaultModel();
    }

    public TreeModel getModelObject() {
        return (TreeModel)this.getDefaultModelObject();
    }

    public MarkupContainer setModel(IModel<? extends TreeModel> model) {
        this.setDefaultModel(model);
        return this;
    }

    public MarkupContainer setModelObject(TreeModel model) {
        this.setDefaultModelObject(model);
        return this;
    }

    public ITreeState getTreeState() {
        if (this.state == null) {
            this.state = this.newTreeState();
            this.state.addTreeStateListener(this);
        }
        return this.state;
    }

    protected void onBeforeAttach() {
    }

    private void onBeforeRenderInternal() {
        if (!this.attached) {
            Object rootNode;
            this.onBeforeAttach();
            this.checkModel();
            if (this.dirtyAll && this.rootItem != null) {
                this.clearAllItem();
            } else {
                this.rebuildDirty();
            }
            if (this.rootItem == null && (rootNode = this.getModelObject().getRoot()) != null) {
                this.rootItem = this.isRootLess() ? this.newTreeItem(null, rootNode, -1) : this.newTreeItem(null, rootNode, 0);
                this.itemContainer.add(new Component[]{this.rootItem});
                this.buildItemChildren(this.rootItem);
            }
            this.attached = true;
        }
    }

    public void onBeforeRender() {
        this.onBeforeRenderInternal();
        super.onBeforeRender();
    }

    public void onDetach() {
        this.attached = false;
        super.onDetach();
        if (this.getTreeState() instanceof IDetachable) {
            ((IDetachable)this.getTreeState()).detach();
        }
    }

    public final void invalidateAll() {
        this.updated();
        this.dirtyAll = true;
    }

    public final boolean isRootLess() {
        return this.rootLess;
    }

    @Override
    public final void nodeCollapsed(Object node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNodeWithChildren(node);
        }
    }

    @Override
    public final void nodeExpanded(Object node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNodeWithChildren(node);
        }
    }

    @Override
    public final void nodeSelected(Object node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNode(node, this.isForceRebuildOnSelectionChange());
        }
    }

    @Override
    public final void nodeUnselected(Object node) {
        if (this.isNodeVisible(node)) {
            this.invalidateNode(node, this.isForceRebuildOnSelectionChange());
        }
    }

    protected boolean isForceRebuildOnSelectionChange() {
        return true;
    }

    public void setRootLess(boolean rootLess) {
        if (this.rootLess != rootLess) {
            this.rootLess = rootLess;
            this.invalidateAll();
            if (rootLess && this.getModelObject() != null) {
                this.getTreeState().expandNode(this.getModelObject().getRoot());
            }
        }
    }

    @Override
    public final void treeNodesChanged(TreeModelEvent e) {
        if (this.dirtyAll) {
            return;
        }
        if (e.getChildren() == null) {
            if (this.rootItem != null) {
                this.invalidateNode(this.rootItem.getModelObject(), true);
            }
        } else {
            Object[] children = e.getChildren();
            if (children != null) {
                for (Object node : children) {
                    if (!this.isNodeVisible(node)) continue;
                    this.invalidateNode(node, true);
                }
            }
        }
    }

    private void markTheLastButOneChildDirty(TreeItem parent, TreeItem child) {
        if (parent.getChildren().indexOf((Object)child) == parent.getChildren().size() - 1) {
            for (int i = parent.getChildren().size() - 2; i >= 0; --i) {
                TreeItem item = parent.getChildren().get(i);
                this.invalidateNodeWithChildren(item.getModelObject());
            }
        }
    }

    @Override
    public final void treeNodesInserted(TreeModelEvent e) {
        if (this.dirtyAll) {
            return;
        }
        Object parentNode = e.getTreePath().getLastPathComponent();
        TreeItem parentItem = this.nodeToItemMap.get(parentNode);
        if (parentItem != null && this.isNodeVisible(parentNode)) {
            boolean addingToHiddedRoot;
            List<Object> eventChildren = Arrays.asList(e.getChildren());
            boolean wasLeaf = true;
            int nodeChildCount = this.getChildCount(parentNode);
            for (int i = 0; wasLeaf && i < nodeChildCount; ++i) {
                wasLeaf = eventChildren.contains(this.getChildAt(parentNode, i));
            }
            boolean bl = addingToHiddedRoot = parentItem.getParentItem() == null && this.isRootLess();
            if (wasLeaf && !addingToHiddedRoot) {
                boolean addingToHiddedRootSon;
                Object grandparentNode = this.getParentNode(parentNode);
                boolean bl2 = addingToHiddedRootSon = grandparentNode != null && this.getParentNode(grandparentNode) == null && this.isRootLess();
                if (grandparentNode != null && !addingToHiddedRootSon) {
                    this.invalidateNodeWithChildren(grandparentNode);
                } else {
                    this.invalidateNode(parentNode, true);
                }
                this.getTreeState().expandNode(parentNode);
            } else if (this.isNodeExpanded(parentNode)) {
                List<TreeItem> itemChildren = parentItem.getChildren();
                int childLevel = parentItem.getLevel() + 1;
                int[] childIndices = e.getChildIndices();
                for (int i = 0; i < eventChildren.size(); ++i) {
                    TreeItem item = this.newTreeItem(parentItem, eventChildren.get(i), childLevel);
                    this.itemContainer.add(new Component[]{item});
                    if (itemChildren != null) {
                        itemChildren.add(childIndices[i], item);
                        this.markTheLastButOneChildDirty(parentItem, item);
                    }
                    if (!this.dirtyItems.contains((Object)item)) {
                        this.dirtyItems.add(item);
                    }
                    if (this.dirtyItemsCreateDOM.contains((Object)item) || item.hasParentWithChildrenMarkedToRecreation()) continue;
                    this.dirtyItemsCreateDOM.add(item);
                }
            }
        }
    }

    @Override
    public final void treeNodesRemoved(TreeModelEvent removalEvent) {
        if (this.dirtyAll) {
            return;
        }
        Object parentNode = removalEvent.getTreePath().getLastPathComponent();
        TreeItem parentItem = this.nodeToItemMap.get(parentNode);
        ArrayList<Object> selection = new ArrayList<Object>(this.getTreeState().getSelectedNodes());
        List<Object> removed = Arrays.asList(removalEvent.getChildren());
        Iterator i$ = selection.iterator();
        while (i$.hasNext()) {
            Object selectedNode;
            Object cursor = selectedNode = i$.next();
            while (cursor != null) {
                if (removed.contains(cursor)) {
                    this.getTreeState().selectNode(selectedNode, false);
                }
                if (cursor instanceof TreeNode) {
                    cursor = ((TreeNode)cursor).getParent();
                    continue;
                }
                cursor = null;
            }
        }
        if (parentItem != null && this.isNodeVisible(parentNode)) {
            if (this.isNodeExpanded(parentNode)) {
                for (Object deletedNode : removalEvent.getChildren()) {
                    TreeItem itemToDelete = this.nodeToItemMap.get(deletedNode);
                    if (itemToDelete == null) continue;
                    this.markTheLastButOneChildDirty(parentItem, itemToDelete);
                    this.visitItemChildren(itemToDelete, new IItemCallback(){

                        @Override
                        public void visitItem(TreeItem item) {
                            AbstractTree.this.removeItem(item);
                        }
                    });
                    parentItem.getChildren().remove((Object)itemToDelete);
                    this.removeItem(itemToDelete);
                }
            }
            if (!parentItem.hasChildTreeItems()) {
                this.invalidateNode(parentNode, true);
            }
        }
    }

    @Override
    public final void treeStructureChanged(TreeModelEvent e) {
        Object node;
        if (this.dirtyAll) {
            return;
        }
        Object object = node = e.getTreePath() != null ? e.getTreePath().getLastPathComponent() : null;
        if (node == null || e.getTreePath().getPathCount() == 1) {
            this.invalidateAll();
        } else {
            this.invalidateNodeWithChildren(node);
        }
    }

    protected void addComponent(AjaxRequestTarget target, Component component) {
        target.add(new Component[]{component});
    }

    public void onTargetRespond(AjaxRequestTarget target) {
        this.checkModel();
        if (this.dirtyAll) {
            this.addComponent(target, (Component)this);
        } else {
            if (this.deleteIds.length() != 0) {
                String js = this.getElementsDeleteJavaScript();
                target.prependJavaScript((CharSequence)js);
            }
            while (!this.dirtyItemsCreateDOM.isEmpty()) {
                Iterator<TreeItem> i = this.dirtyItemsCreateDOM.iterator();
                while (i.hasNext()) {
                    TreeItem previous;
                    TreeItem item = i.next();
                    TreeItem parent = item.getParentItem();
                    int index = parent.getChildren().indexOf((Object)item);
                    if (index == 0) {
                        previous = parent;
                    } else {
                        previous = parent.getChildren().get(index - 1);
                        while (previous.getChildren() != null && previous.getChildren().size() > 0) {
                            previous = previous.getChildren().get(previous.getChildren().size() - 1);
                        }
                    }
                    if (this.dirtyItemsCreateDOM.contains((Object)previous)) continue;
                    target.prependJavaScript((CharSequence)("Wicket.Tree.createElement(\"" + item.getMarkupId() + "\"," + "\"" + previous.getMarkupId() + "\")"));
                    i.remove();
                }
            }
            for (TreeItem item : this.dirtyItems) {
                if (item.getChildren() == null) {
                    this.buildItemChildren(item);
                    item.setRenderChildren(true);
                }
                this.addComponent(target, (Component)item);
            }
            this.updated();
        }
    }

    public final void updateTree() {
        AjaxRequestTarget target = (AjaxRequestTarget)this.getRequestCycle().find(AjaxRequestTarget.class);
        if (target == null) {
            throw new WicketRuntimeException("No AjaxRequestTarget available to execute updateTree(ART target)");
        }
        this.updateTree(target);
    }

    public final void updateTree(AjaxRequestTarget target) {
        Args.notNull((Object)target, (String)"target");
        target.registerRespondListener((AjaxRequestTarget.ITargetRespondListener)this);
    }

    protected final boolean isNodeExpanded(Object node) {
        if (this.isRootLess() && this.rootItem != null && this.rootItem.getModelObject().equals(node)) {
            return true;
        }
        return this.getTreeState().isNodeExpanded(node);
    }

    protected ITreeState newTreeState() {
        return new DefaultTreeState();
    }

    protected void onAfterRender() {
        super.onAfterRender();
        this.updated();
    }

    protected abstract void populateTreeItem(WebMarkupContainer var1, int var2);

    private void buildItemChildren(TreeItem item) {
        List<TreeItem> items = this.isNodeExpanded(item.getModelObject()) ? this.buildTreeItems(item, this.nodeChildren(item.getModelObject()), item.getLevel() + 1) : new ArrayList<TreeItem>(0);
        item.setChildren(items);
    }

    private List<TreeItem> buildTreeItems(TreeItem parent, Iterator<Object> nodes, int level) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        while (nodes.hasNext()) {
            Object node = nodes.next();
            TreeItem item = this.newTreeItem(parent, node, level);
            this.itemContainer.add(new Component[]{item});
            this.buildItemChildren(item);
            result.add(item);
        }
        return result;
    }

    private void checkModel() {
        TreeModel model = this.getModelObject();
        if (model != this.previousModel) {
            if (this.previousModel != null) {
                this.previousModel.removeTreeModelListener(this);
            }
            this.previousModel = model;
            if (model != null) {
                model.addTreeModelListener(this);
            }
            this.invalidateAll();
        }
    }

    private void clearAllItem() {
        this.visitItemAndChildren(this.rootItem, new IItemCallback(){

            @Override
            public void visitItem(TreeItem item) {
                item.remove();
            }
        });
        this.rootItem = null;
    }

    private String getElementsDeleteJavaScript() {
        AppendingStringBuffer buffer = new AppendingStringBuffer(100);
        buffer.append("Wicket.Tree.removeNodes(\"");
        buffer.append(this.getMarkupId() + "_\",[");
        buffer.append(this.deleteIds);
        if (buffer.endsWith((CharSequence)",")) {
            buffer.setLength(buffer.length() - 1);
        }
        buffer.append("]);");
        return buffer.toString();
    }

    private String getShortItemId(TreeItem item) {
        int skip = this.getMarkupId().length() + 1;
        return item.getMarkupId().substring(skip);
    }

    private void init() {
        this.setVersioned(false);
        this.setOutputMarkupId(true);
        this.itemContainer = new TreeItemContainer("i");
        this.add(new Component[]{this.itemContainer});
        this.checkModel();
    }

    public final void markNodeDirty(Object node) {
        this.invalidateNode(node, false);
    }

    public final void markNodeChildrenDirty(Object node) {
        TreeItem item = this.nodeToItemMap.get(node);
        if (item != null) {
            this.visitItemChildren(item, new IItemCallback(){

                @Override
                public void visitItem(TreeItem item) {
                    AbstractTree.this.invalidateNode(item.getModelObject(), false);
                }
            });
        }
    }

    private void invalidateNode(Object node, boolean forceRebuild) {
        TreeItem item;
        if (!this.dirtyAll && (item = this.nodeToItemMap.get(node)) != null) {
            boolean createDOM = false;
            if (forceRebuild) {
                int level = item.getLevel();
                List<TreeItem> children = item.getChildren();
                String id = item.getId();
                TreeItem parent = item.getParentItem();
                int index = parent != null ? parent.getChildren().indexOf((Object)item) : -1;
                createDOM = this.dirtyItemsCreateDOM.contains((Object)item);
                this.dirtyItems.remove((Object)item);
                this.dirtyItemsCreateDOM.remove((Object)item);
                item.remove();
                item = this.newTreeItem(parent, node, level, id);
                this.itemContainer.add(new Component[]{item});
                item.setChildren(children);
                if (parent == null) {
                    this.rootItem = item;
                } else {
                    parent.getChildren().set(index, item);
                }
            }
            if (!this.dirtyItems.contains((Object)item)) {
                this.dirtyItems.add(item);
            }
            if (createDOM && !this.dirtyItemsCreateDOM.contains((Object)item)) {
                this.dirtyItemsCreateDOM.add(item);
            }
        }
    }

    private void invalidateNodeWithChildren(Object node) {
        TreeItem item;
        if (!this.dirtyAll && (item = this.nodeToItemMap.get(node)) != null) {
            this.visitItemChildren(item, new IItemCallback(){

                @Override
                public void visitItem(TreeItem item) {
                    AbstractTree.this.removeItem(item);
                }
            });
            item.setChildren(null);
            if (!this.dirtyItems.contains((Object)item)) {
                this.dirtyItems.add(item);
            }
        }
    }

    private boolean isNodeVisible(Object node) {
        if (node == null) {
            return false;
        }
        Object parent = this.getParentNode(node);
        while (parent != null) {
            if (!this.isNodeExpanded(parent)) {
                return false;
            }
            parent = this.getParentNode(parent);
        }
        return true;
    }

    public Object getParentNode(Object node) {
        TreeItem item = this.nodeToItemMap.get(node);
        if (item == null) {
            return null;
        }
        TreeItem parent = item.getParentItem();
        return parent == null ? null : parent.getModelObject();
    }

    private TreeItem newTreeItem(TreeItem parent, Object node, int level) {
        return new TreeItem(parent, "" + this.idCounter++, node, level);
    }

    private TreeItem newTreeItem(TreeItem parent, Object node, int level, String id) {
        return new TreeItem(parent, id, node, level);
    }

    public final Iterator<Object> nodeChildren(Object node) {
        TreeModel model = this.getTreeModel();
        int count = model.getChildCount(node);
        ArrayList<Object> nodes = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            nodes.add(model.getChild(node, i));
        }
        return nodes.iterator();
    }

    public final Object getChildAt(Object parent, int index) {
        return this.getTreeModel().getChild(parent, index);
    }

    public final boolean isLeaf(Object node) {
        return this.getTreeModel().isLeaf(node);
    }

    public final int getChildCount(Object parent) {
        return this.getTreeModel().getChildCount(parent);
    }

    private TreeModel getTreeModel() {
        return this.getModelObject();
    }

    private void rebuildDirty() {
        for (TreeItem item : this.dirtyItems) {
            if (item.getChildren() != null) continue;
            this.buildItemChildren(item);
        }
    }

    private void removeItem(TreeItem item) {
        this.dirtyItems.remove((Object)item);
        if (this.dirtyItemsCreateDOM.contains((Object)item)) {
            this.dirtyItemsCreateDOM.remove((Object)item);
        } else {
            this.deleteIds.append(this.getShortItemId(item));
            this.deleteIds.append(",");
        }
        if (item.getParent() != null) {
            item.remove();
        }
    }

    private void updated() {
        this.dirtyAll = false;
        this.dirtyItems.clear();
        this.dirtyItemsCreateDOM.clear();
        this.deleteIds.clear();
    }

    private void visitItemAndChildren(TreeItem item, IItemCallback callback) {
        callback.visitItem(item);
        this.visitItemChildren(item, callback);
    }

    private void visitItemChildren(TreeItem item, IItemCallback callback) {
        if (item.getChildren() != null) {
            for (TreeItem child : item.getChildren()) {
                this.visitItemAndChildren(child, callback);
            }
        }
    }

    public Component getNodeComponent(Object node) {
        return (Component)this.nodeToItemMap.get(node);
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JAVASCRIPT));
    }

    private class TreeItemContainer
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public TreeItemContainer(String id) {
            super(id);
        }

        public TreeItemContainer remove(Component component) {
            if (component instanceof TreeItem) {
                AbstractTree.this.nodeToItemMap.remove(((TreeItem)component).getModelObject());
            }
            super.remove(component);
            return this;
        }

        protected void onRender() {
            if (AbstractTree.this.rootItem != null) {
                IItemCallback callback = new IItemCallback(){

                    @Override
                    public void visitItem(TreeItem item) {
                        item.render();
                    }
                };
                AbstractTree.this.visitItemAndChildren(AbstractTree.this.rootItem, callback);
            }
        }

        public IMarkupFragment getMarkup(Component child) {
            return this.getMarkup();
        }
    }

    private final class TreeItem
    extends AbstractItem {
        private static final int FLAG_RENDER_CHILDREN = 524288;
        private static final long serialVersionUID = 1L;
        private List<TreeItem> children;
        private final int level;
        private final TreeItem parent;

        public TreeItem(TreeItem parent, String id, Object node, int level) {
            super(id, (IModel)new Model((Serializable)node));
            this.children = null;
            this.parent = parent;
            AbstractTree.this.nodeToItemMap.put(node, this);
            this.level = level;
            this.setOutputMarkupId(true);
            if (level != -1) {
                AbstractTree.this.populateTreeItem((WebMarkupContainer)this, level);
            }
        }

        public TreeItem getParentItem() {
            return this.parent;
        }

        public List<TreeItem> getChildren() {
            return this.children;
        }

        public int getLevel() {
            return this.level;
        }

        public String getMarkupId() {
            return AbstractTree.this.getMarkupId() + "_" + this.getId();
        }

        public void setChildren(List<TreeItem> children) {
            this.children = children;
        }

        protected final boolean isRenderChildren() {
            return this.getFlag(524288);
        }

        public boolean hasChildTreeItems() {
            return this.children != null && !this.children.isEmpty();
        }

        protected void onRender() {
            if (this == AbstractTree.this.rootItem && AbstractTree.this.isRootLess()) {
                String tagName = ((ComponentTag)this.getMarkup().get(0)).getName();
                Response response = this.getResponse();
                response.write((CharSequence)("<" + tagName + " style=\"display:none\" id=\"" + this.getMarkupId() + "\">"));
                if ("table".equals(tagName)) {
                    response.write((CharSequence)"<tbody><tr><td></td></tr></tbody>");
                }
                response.write((CharSequence)("</" + tagName + ">"));
            } else {
                super.onRender();
                if (this.isRenderChildren()) {
                    AbstractTree.this.visitItemChildren(this, new IItemCallback(){

                        @Override
                        public void visitItem(TreeItem item) {
                            item.onRender();
                            List behaviors = item.getBehaviors();
                            for (Behavior behavior : behaviors) {
                                behavior.afterRender((Component)item);
                            }
                        }
                    });
                }
            }
        }

        public Object getModelObject() {
            return this.getDefaultModelObject();
        }

        public void renderHead(final HtmlHeaderContainer container) {
            super.renderHead(container);
            if (this.isRenderChildren()) {
                AbstractTree.this.visitItemChildren(this, new IItemCallback(){

                    @Override
                    public void visitItem(TreeItem item) {
                        if (item.isVisible()) {
                            item.renderHead(container);
                        }
                        item.visitChildren((IVisitor)new IVisitor<Component, Void>(){

                            public void component(Component component, IVisit<Void> visit) {
                                if (component.isVisible()) {
                                    component.renderHead(container);
                                } else {
                                    visit.dontGoDeeper();
                                }
                            }
                        });
                    }
                });
            }
        }

        protected final void setRenderChildren(boolean value) {
            this.setFlag(524288, value);
        }

        protected void onDetach() {
            super.onDetach();
            Object object = this.getModelObject();
            if (object instanceof IDetachable) {
                ((IDetachable)object).detach();
            }
            if (this.isRenderChildren()) {
                AbstractTree.this.visitItemChildren(this, new IItemCallback(){

                    @Override
                    public void visitItem(TreeItem item) {
                        item.detach();
                    }
                });
            }
            this.setRenderChildren(false);
        }

        protected void onBeforeRender() {
            AbstractTree.this.onBeforeRenderInternal();
            super.onBeforeRender();
            if (this.isRenderChildren()) {
                AbstractTree.this.visitItemChildren(this, new IItemCallback(){

                    @Override
                    public void visitItem(TreeItem item) {
                        item.prepareForRender();
                    }
                });
            }
        }

        protected void onAfterRender() {
            super.onAfterRender();
            if (this.isRenderChildren()) {
                AbstractTree.this.visitItemChildren(this, new IItemCallback(){

                    @Override
                    public void visitItem(TreeItem item) {
                        item.afterRender();
                    }
                });
            }
        }

        private boolean hasParentWithChildrenMarkedToRecreation() {
            return this.getParentItem() != null && (this.getParentItem().getChildren() == null || this.getParentItem().hasParentWithChildrenMarkedToRecreation());
        }
    }

    private static interface IItemCallback {
        public void visitItem(TreeItem var1);
    }
}

