/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;

public class ApiVersionsRequest
extends AbstractRequest {
    public ApiVersionsRequest(short version) {
        super(version);
    }

    public ApiVersionsRequest(Struct struct, short version) {
        super(version);
    }

    @Override
    protected Struct toStruct() {
        return new Struct(ApiKeys.API_VERSIONS.requestSchema(this.version()));
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new ApiVersionsResponse(Errors.forException(e), Collections.emptyList());
            }
            case 1: {
                return new ApiVersionsResponse(throttleTimeMs, Errors.forException(e), Collections.emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.API_VERSIONS.latestVersion()));
    }

    public static ApiVersionsRequest parse(ByteBuffer buffer, short version) {
        return new ApiVersionsRequest(ApiKeys.API_VERSIONS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<ApiVersionsRequest> {
        public Builder() {
            super(ApiKeys.API_VERSIONS);
        }

        public Builder(short version) {
            super(ApiKeys.API_VERSIONS, version);
        }

        @Override
        public ApiVersionsRequest build(short version) {
            return new ApiVersionsRequest(version);
        }

        public String toString() {
            return "(type=ApiVersionsRequest)";
        }
    }
}

