/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.schema.listener;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.unomi.schema.api.SchemaService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaListener
implements SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger((String)JsonSchemaListener.class.getName());
    public static final String ENTRIES_LOCATION = "META-INF/cxs/schemas";
    private SchemaService schemaService;
    private BundleContext bundleContext;

    public void setSchemaService(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void postConstruct() {
        logger.info("JSON schema listener initializing...");
        logger.debug("postConstruct {}", (Object)this.bundleContext.getBundle());
        this.loadPredefinedSchemas(this.bundleContext, true);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null || bundle.getBundleId() == this.bundleContext.getBundle().getBundleId()) continue;
            this.loadPredefinedSchemas(bundle.getBundleContext(), true);
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        logger.info("JSON schema listener initialized.");
    }

    public void preDestroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        logger.info("JSON schema listener shutdown.");
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.loadPredefinedSchemas(bundleContext, true);
    }

    private void processBundleStop(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.loadPredefinedSchemas(bundleContext, false);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.processBundleStartup(event.getBundle().getBundleContext());
                break;
            }
            case 256: {
                if (event.getBundle().getSymbolicName().equals(this.bundleContext.getBundle().getSymbolicName())) break;
                this.processBundleStop(event.getBundle().getBundleContext());
            }
        }
    }

    private void loadPredefinedSchemas(BundleContext bundleContext, boolean load) {
        Enumeration predefinedSchemas = bundleContext.getBundle().findEntries(ENTRIES_LOCATION, "*.json", true);
        if (predefinedSchemas == null) {
            return;
        }
        while (predefinedSchemas.hasMoreElements()) {
            URL predefinedSchemaURL = (URL)predefinedSchemas.nextElement();
            logger.debug("Found predefined JSON schema at {}, {}... ", (Object)predefinedSchemaURL, (Object)(load ? "loading" : "unloading"));
            try {
                InputStream schemaInputStream = predefinedSchemaURL.openStream();
                Throwable throwable = null;
                try {
                    if (load) {
                        this.schemaService.loadPredefinedSchema(schemaInputStream);
                        continue;
                    }
                    this.schemaService.unloadPredefinedSchema(schemaInputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (schemaInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            schemaInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    schemaInputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("Error while {} schema definition {}", new Object[]{load ? "loading" : "unloading", predefinedSchemaURL, e});
            }
        }
    }
}

