/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.access.NonStrictReadWriteAccessDelegate;
import com.hazelcast.hibernate.access.ReadOnlyAccessDelegate;
import com.hazelcast.hibernate.access.ReadWriteAccessDelegate;
import com.hazelcast.hibernate.region.AbstractTransactionalDataRegion;
import com.hazelcast.hibernate.region.NaturalIdRegionAccessStrategyAdapter;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;

public class HazelcastNaturalIdRegion<Cache extends RegionCache>
extends AbstractTransactionalDataRegion<Cache>
implements NaturalIdRegion {
    public HazelcastNaturalIdRegion(HazelcastInstance instance, String regionName, Properties props, CacheDataDescription metadata, Cache cache) {
        super(instance, regionName, props, metadata, cache);
    }

    public NaturalIdRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (AccessType.READ_ONLY.equals((Object)accessType)) {
            return new NaturalIdRegionAccessStrategyAdapter(new ReadOnlyAccessDelegate<HazelcastNaturalIdRegion>(this, this.props));
        }
        if (AccessType.NONSTRICT_READ_WRITE.equals((Object)accessType)) {
            return new NaturalIdRegionAccessStrategyAdapter(new NonStrictReadWriteAccessDelegate<HazelcastNaturalIdRegion>(this, this.props));
        }
        if (AccessType.READ_WRITE.equals((Object)accessType)) {
            return new NaturalIdRegionAccessStrategyAdapter(new ReadWriteAccessDelegate<HazelcastNaturalIdRegion>(this, this.props));
        }
        throw new CacheException("AccessType \"" + accessType + "\" is not currently supported by Hazelcast.");
    }
}

