/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.uima.InternationalizedException;
import org.apache.uima.InternationalizedRuntimeException;
import org.apache.uima.internal.util.I18nUtil;

public class I18nx_impl {
    private String mResourceBundleName;
    private String mMessageKey;
    private Object[] mArguments;
    private Throwable mCause;
    private final transient ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
    private final transient ResourceBundle default_localized_resourceBundle;
    private final transient Locale default_locale;
    private transient ResourceBundle user_specified_resourceBundle = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I18nx_impl(String aResourceBundleName, String aMessageKey, Object[] aArguments, Throwable aCause) {
        try {
            I18nUtil.setTccl(this.originalContextClassLoader);
            this.default_locale = Locale.getDefault();
            this.default_localized_resourceBundle = aMessageKey == null ? null : I18nUtil.resolveResourceBundle(aResourceBundleName, this.default_locale, null);
        }
        finally {
            I18nUtil.removeTccl();
        }
        this.mCause = aCause;
        this.mResourceBundleName = aResourceBundleName;
        this.mMessageKey = aMessageKey;
        this.mArguments = aArguments;
        if (this.mResourceBundleName == null && this.mMessageKey == null) {
            if (this.mCause instanceof InternationalizedException) {
                this.mResourceBundleName = ((InternationalizedException)this.mCause).getResourceBundleName();
                this.mMessageKey = ((InternationalizedException)this.mCause).getMessageKey();
                this.mArguments = ((InternationalizedException)this.mCause).getArguments();
            } else if (this.mCause instanceof InternationalizedRuntimeException) {
                this.mResourceBundleName = ((InternationalizedRuntimeException)this.mCause).getResourceBundleName();
                this.mMessageKey = ((InternationalizedRuntimeException)this.mCause).getMessageKey();
                this.mArguments = ((InternationalizedRuntimeException)this.mCause).getArguments();
            }
        }
    }

    public String getResourceBundleName() {
        return this.mResourceBundleName;
    }

    public String getMessageKey() {
        return this.mMessageKey;
    }

    public Object[] getArguments() {
        if (this.mArguments == null) {
            return new Object[0];
        }
        Object[] result = new Object[this.mArguments.length];
        System.arraycopy(this.mArguments, 0, result, 0, this.mArguments.length);
        return result;
    }

    public String getMessage() {
        return this.getLocalizedMessage(Locale.ENGLISH);
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale aLocale) {
        if (this.getMessageKey() == null) {
            return null;
        }
        if (this.default_localized_resourceBundle != null && aLocale == this.default_locale) {
            return I18nUtil.localizeMessage(this.default_localized_resourceBundle, aLocale, this.getMessageKey(), this.getArguments());
        }
        if (this.user_specified_resourceBundle != null) {
            return I18nUtil.localizeMessage(this.user_specified_resourceBundle, aLocale, this.getMessageKey(), this.getArguments());
        }
        try {
            I18nUtil.setTccl(this.originalContextClassLoader);
            String string = I18nUtil.localizeMessage(this.getResourceBundleName(), aLocale, this.getMessageKey(), this.getArguments());
            return string;
        }
        finally {
            I18nUtil.removeTccl();
        }
    }

    public Throwable getCause() {
        return this.mCause;
    }

    public void setCause(Throwable cause) {
        this.mCause = cause;
    }

    public boolean hasMessageKey(String messageKey) {
        if (messageKey.equals(this.getMessageKey())) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof InternationalizedException) {
            return ((InternationalizedException)cause).hasMessageKey(messageKey);
        }
        return false;
    }

    public void setResourceBundle(Locale aLocale) {
        this.user_specified_resourceBundle = I18nUtil.resolveResourceBundle(this.mResourceBundleName, aLocale, null);
    }
}

