/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RangeVariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.functions.Current;
import net.sf.saxon.sort.DocumentSorter;
import net.sf.saxon.sort.Reverser;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class PromotionOffer {
    public static final int FOCUS_INDEPENDENT = 10;
    public static final int RANGE_INDEPENDENT = 11;
    public static final int INLINE_VARIABLE_REFERENCES = 12;
    public static final int UNORDERED = 13;
    public static final int REPLACE_CURRENT = 14;
    private Optimizer optimizer;
    public int action;
    public boolean promoteDocumentDependent = false;
    public boolean promoteXSLTFunctions = true;
    public boolean mustEliminateDuplicates = true;
    public Binding[] bindingList;
    public Expression containingExpression;
    public boolean accepted = false;

    public PromotionOffer(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Expression accept(Expression expression) throws XPathException {
        switch (this.action) {
            case 11: {
                int n = expression.getSpecialProperties();
                if ((n & 0x400000) == 0 || ExpressionTool.dependsOnVariable(expression, this.bindingList) || (expression.getDependencies() & 0x1000000) != 0) break;
                return this.promote(expression);
            }
            case 10: {
                int n = expression.getDependencies();
                int n2 = expression.getSpecialProperties();
                if (!this.promoteXSLTFunctions && (n & 0x61) != 0 || (n & 0x1000000) != 0) break;
                if ((n & 0x1E) == 0 && (n2 & 0x400000) != 0) {
                    return this.promote(expression);
                }
                if (!this.promoteDocumentDependent || (n & 0xE) != 0 || (n2 & 0x400000) == 0) break;
                return this.promote(expression);
            }
            case 14: {
                if (!(expression instanceof Current)) break;
                VariableReference variableReference = new VariableReference(((Assignation)this.containingExpression).getVariableDeclaration());
                variableReference.setParentExpression(expression.getParentExpression());
                return variableReference;
            }
            case 12: {
                if (!(expression instanceof VariableReference) || ((VariableReference)expression).getBinding() != this.bindingList[0]) break;
                if (this.containingExpression instanceof ContextItemExpression) {
                    ContextItemExpression contextItemExpression = ((ContextItemExpression)this.containingExpression).copy();
                    return contextItemExpression;
                }
                if (this.containingExpression instanceof VariableReference) {
                    VariableReference variableReference = ((VariableReference)this.containingExpression).copy();
                    if (((VariableReference)this.containingExpression).binding instanceof LetExpression) {
                        LetExpression letExpression = (LetExpression)((VariableReference)this.containingExpression).binding;
                        letExpression.addReference(variableReference);
                    }
                    return variableReference;
                }
                return this.containingExpression;
            }
            case 13: {
                if (expression instanceof Reverser) {
                    Expression expression2 = ((Reverser)expression).getBaseExpression();
                    Expression.setParentExpression(expression2, expression.getParentExpression());
                    return expression2;
                }
                if (!(expression instanceof DocumentSorter) || this.mustEliminateDuplicates) break;
                Expression expression3 = ((DocumentSorter)expression).getBaseExpression();
                Expression.setParentExpression(expression3, expression.getParentExpression());
                return expression3;
            }
            default: {
                throw new UnsupportedOperationException("Unknown promotion action " + this.action);
            }
        }
        return null;
    }

    private Expression promote(Expression expression) {
        RangeVariableDeclaration rangeVariableDeclaration = new RangeVariableDeclaration();
        rangeVariableDeclaration.setVariableName("zz:" + rangeVariableDeclaration.hashCode());
        TypeHierarchy typeHierarchy = this.optimizer.getConfiguration().getTypeHierarchy();
        SequenceType sequenceType = SequenceType.makeSequenceType(expression.getItemType(typeHierarchy), expression.getCardinality());
        rangeVariableDeclaration.setRequiredType(sequenceType);
        boolean bl = false;
        if (expression.getParentExpression() instanceof GeneralComparison && ((GeneralComparison)expression.getParentExpression()).getOperator() == 6) {
            bl = true;
        }
        VariableReference variableReference = new VariableReference(rangeVariableDeclaration);
        ExpressionTool.copyLocationInfo(this.containingExpression, variableReference);
        variableReference.setParentExpression(expression.getParentExpression());
        Container container = this.containingExpression.getParentExpression();
        LetExpression letExpression = new LetExpression();
        letExpression.setVariableDeclaration(rangeVariableDeclaration);
        letExpression.setSequence(LazyExpression.makeLazyExpression(expression));
        letExpression.setAction(this.containingExpression);
        letExpression.setParentExpression(container);
        letExpression.adoptChildExpression(this.containingExpression);
        if (bl) {
            letExpression.setIndexedVariable();
        }
        this.containingExpression = letExpression;
        this.accepted = true;
        return variableReference;
    }
}

