/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.IfExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Copy;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.UseAttributeSets;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Validation;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class XSLCopy
extends StyleElement {
    private String use;
    private AttributeSet[] attributeSets = null;
    private boolean copyNamespaces = true;
    private boolean inheritNamespaces = true;
    private int validationAction = 3;
    private SchemaType schemaType = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string5 = this.getNamePool().getClarkName(n);
            if (string5 == "use-attribute-sets") {
                this.use = attributeCollection.getValue(i);
                continue;
            }
            if (string5 == "copy-namespaces") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string5 == "type") {
                string3 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string5 == "validation") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string5 == "inherit-namespaces") {
                string4 = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.copyNamespaces = true;
        } else if (string.equals("yes")) {
            this.copyNamespaces = true;
        } else if (string.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'", "XTSE0020");
        }
        if (string3 != null && string2 != null) {
            this.compileError("The type and validation attributes must not both be specified", "XTSE1505");
        }
        if (string2 != null) {
            this.validationAction = Validation.getCode(string2);
            if (this.validationAction != 4 && !this.getConfiguration().isSchemaAware(50)) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
        } else {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        }
        if (string3 != null) {
            this.schemaType = this.getSchemaType(string3);
            if (!this.getConfiguration().isSchemaAware(50)) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.validationAction = 8;
        }
        if (string4 != null) {
            if (string4.equals("yes")) {
                this.inheritNamespaces = true;
            } else if (string4.equals("no")) {
                this.inheritNamespaces = false;
            } else {
                this.compileError("The @inherit-namespaces attribute has permitted values (yes, no)", "XTSE0020");
            }
        }
    }

    public void validate() throws XPathException {
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        Copy copy = new Copy(this.copyNamespaces, this.inheritNamespaces, this.schemaType, this.validationAction);
        Expression expression = this.compileSequenceConstructor(executable, this.iterateAxis((byte)3), true);
        if (this.attributeSets != null) {
            UseAttributeSets useAttributeSets = new UseAttributeSets(this.attributeSets);
            InstanceOfExpression instanceOfExpression = new InstanceOfExpression(new ContextItemExpression(), SequenceType.makeSequenceType(NodeKindTest.ELEMENT, 16384));
            IfExpression ifExpression = new IfExpression(instanceOfExpression, useAttributeSets, Literal.makeLiteral(EmptySequence.getInstance()));
            if (expression == null) {
                expression = ifExpression;
            } else {
                expression = Block.makeBlock(ifExpression, expression);
                expression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (expression == null) {
            expression = Literal.makeLiteral(EmptySequence.getInstance());
        }
        copy.setContentExpression(expression);
        ExpressionTool.makeParentReferences(copy);
        return copy;
    }
}

