/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FormatNumber2
extends SystemFunction
implements XSLTFunction {
    private NamespaceResolver nsContext = null;
    private DecimalSymbols decimalFormatSymbols = null;
    private transient String picture = null;
    private SubPicture[] subPictures = null;
    private boolean requireFixup = false;
    private transient boolean checked = false;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(staticContext);
        if (this.argument[1] instanceof StringLiteral) {
            this.picture = ((StringLiteral)this.argument[1]).getStringValue();
        }
        if (this.argument.length == 3) {
            if (this.argument[2] instanceof StringLiteral) {
                String string;
                String string2;
                Object object;
                String string3 = ((StringLiteral)this.argument[2]).getStringValue();
                try {
                    object = staticContext.getConfiguration().getNameChecker().getQNameParts(string3);
                    string2 = object[1];
                    string = staticContext.getURIForPrefix(object[0]);
                }
                catch (QNameException qNameException) {
                    throw new StaticError("Invalid decimal format name. " + qNameException.getMessage());
                }
                object = ((ExpressionContext)staticContext).getXSLStylesheet().getDecimalFormatManager();
                this.requireFixup = true;
                ((DecimalFormatManager)object).registerUsage(string, string2, this);
            } else {
                this.nsContext = staticContext.getNamespaceResolver();
            }
        } else if (staticContext instanceof ExpressionContext) {
            DecimalFormatManager decimalFormatManager = ((ExpressionContext)staticContext).getXSLStylesheet().getDecimalFormatManager();
            decimalFormatManager.registerUsage("", "", this);
        }
    }

    public void fixup(DecimalSymbols decimalSymbols) {
        this.requireFixup = false;
        this.decimalFormatSymbols = decimalSymbols;
        if (this.picture != null) {
            try {
                this.subPictures = this.getSubPictures(this.picture, decimalSymbols);
            }
            catch (XPathException xPathException) {
                this.subPictures = null;
            }
        }
    }

    private SubPicture[] getSubPictures(String string, DecimalSymbols decimalSymbols) throws XPathException {
        int[] nArray = StringValue.expand(string);
        SubPicture[] subPictureArray = new SubPicture[2];
        if (nArray.length == 0) {
            DynamicError dynamicError = new DynamicError("format-number() picture is zero-length");
            dynamicError.setErrorCode("XTDE1310");
            throw dynamicError;
        }
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != decimalSymbols.patternSeparator) continue;
            if (i == 0) {
                this.grumble("first subpicture is zero-length");
            } else if (n >= 0) {
                this.grumble("more than one pattern separator");
            } else if (n == nArray.length - 1) {
                this.grumble("second subpicture is zero-length");
            }
            n = i;
        }
        if (n < 0) {
            subPictureArray[0] = new SubPicture(nArray, decimalSymbols);
            subPictureArray[1] = null;
        } else {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            int[] nArray3 = new int[nArray.length - n - 1];
            System.arraycopy(nArray, n + 1, nArray3, 0, nArray.length - n - 1);
            subPictureArray[0] = new SubPicture(nArray2, decimalSymbols);
            subPictureArray[1] = new SubPicture(nArray3, decimalSymbols);
        }
        return subPictureArray;
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        return this;
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        String string;
        SubPicture[] subPictureArray;
        int n = this.argument.length;
        Controller controller = xPathContext.getController();
        DecimalSymbols decimalSymbols = this.decimalFormatSymbols;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            atomicValue = DoubleValue.NaN;
        }
        NumericValue numericValue = (NumericValue)atomicValue;
        if (decimalSymbols == null) {
            if (this.requireFixup) {
                this.dynamicError("Unknown decimal format name", "XTDE1280", xPathContext);
                return null;
            }
            subPictureArray = controller.getExecutable().getDecimalFormatManager();
            if (n == 2) {
                decimalSymbols = subPictureArray.getDefaultDecimalFormat();
            } else {
                string = this.argument[2].evaluateItem(xPathContext).getStringValue();
                try {
                    String[] stringArray = controller.getConfiguration().getNameChecker().getQNameParts(string);
                    String string2 = stringArray[1];
                    String string3 = this.nsContext.getURIForPrefix(stringArray[0], false);
                    if (string3 == null) {
                        this.dynamicError("Namespace prefix '" + stringArray[0] + "' has not been defined", "XTDE1280", xPathContext);
                        return null;
                    }
                    decimalSymbols = subPictureArray.getNamedDecimalFormat(string3, string2);
                    if (decimalSymbols == null) {
                        this.dynamicError("format-number function: decimal-format '" + string2 + "' is not defined", "XTDE1280", xPathContext);
                        return null;
                    }
                }
                catch (QNameException qNameException) {
                    this.dynamicError("Invalid decimal format name. " + qNameException.getMessage(), "XTDE1280", xPathContext);
                }
            }
        }
        if ((subPictureArray = this.subPictures) == null) {
            string = this.argument[1].evaluateItem(xPathContext).getStringValue();
            subPictureArray = this.getSubPictures(string, decimalSymbols);
        }
        return ((Object)this.formatNumber(numericValue, subPictureArray, decimalSymbols)).toString();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return new StringValue(this.evaluateAsString(xPathContext));
    }

    private CharSequence formatNumber(NumericValue numericValue, SubPicture[] subPictureArray, DecimalSymbols decimalSymbols) {
        SubPicture subPicture;
        NumericValue numericValue2 = numericValue;
        String string = "";
        if (numericValue.signum() < 0.0) {
            numericValue2 = numericValue.negate();
            if (subPictureArray[1] == null) {
                subPicture = subPictureArray[0];
                string = "" + FormatNumber2.unicodeChar(decimalSymbols.minusSign);
            } else {
                subPicture = subPictureArray[1];
            }
        } else {
            subPicture = subPictureArray[0];
        }
        return subPicture.format(numericValue2, decimalSymbols, string);
    }

    private void grumble(String string) throws XPathException {
        this.dynamicError("format-number picture: " + string, "XTDE1310", null);
    }

    public static BigDecimal adjustToDecimal(double d, int n) {
        String string = n == 1 ? "00000" : "000000000";
        String string2 = n == 1 ? "99999" : "999999999";
        BigDecimal bigDecimal = new BigDecimal(d);
        BigDecimal bigDecimal2 = null;
        String string3 = ((Object)DecimalValue.decimalToString(bigDecimal)).toString();
        int n2 = string3.charAt(0) == '-' ? 1 : 0;
        int n3 = string3.indexOf(".");
        int n4 = string3.lastIndexOf(string);
        if (n4 > 0) {
            if (n3 < 0 || n4 < n3) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(string3.length());
                fastStringBuffer.append(string3.substring(0, n4));
                for (int i = n4; i < string3.length(); ++i) {
                    fastStringBuffer.append(string3.charAt(i) == '.' ? (char)'.' : '0');
                }
                bigDecimal2 = new BigDecimal(fastStringBuffer.toString());
            } else {
                bigDecimal2 = new BigDecimal(string3.substring(0, n4));
            }
        } else {
            n4 = string3.indexOf(string2);
            if (n4 >= 0) {
                if (n4 == n2) {
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(string3.length() + 1);
                    if (n2 == 1) {
                        fastStringBuffer.append('-');
                    }
                    fastStringBuffer.append('1');
                    for (int i = n2; i < string3.length(); ++i) {
                        fastStringBuffer.append(string3.charAt(i) == '.' ? (char)'.' : '0');
                    }
                    bigDecimal2 = new BigDecimal(fastStringBuffer.toString());
                } else {
                    while (n4 >= 0 && (string3.charAt(n4) == '9' || string3.charAt(n4) == '.')) {
                        --n4;
                    }
                    if (n4 < 0 || string3.charAt(n4) == '-') {
                        return bigDecimal;
                    }
                    if (n3 < 0 || n4 < n3) {
                        FastStringBuffer fastStringBuffer = new FastStringBuffer(string3.length());
                        fastStringBuffer.append(string3.substring(0, n4));
                        fastStringBuffer.append((char)(string3.charAt(n4) + '\u0001'));
                        for (int i = n4; i < string3.length(); ++i) {
                            fastStringBuffer.append(string3.charAt(i) == '.' ? (char)'.' : '0');
                        }
                        bigDecimal2 = new BigDecimal(fastStringBuffer.toString());
                    } else {
                        String string4 = string3.substring(0, n4) + (char)(string3.charAt(n4) + '\u0001');
                        bigDecimal2 = new BigDecimal(string4);
                    }
                }
            }
        }
        if (bigDecimal2 != null && (n == 1 ? (double)bigDecimal2.floatValue() == d : bigDecimal2.doubleValue() == d)) {
            return bigDecimal2;
        }
        return bigDecimal;
    }

    private static CharSequence unicodeChar(int n) {
        if (n < 65536) {
            return "" + (char)n;
        }
        char[] cArray = new char[]{(char)((n -= 65536) / 1024 + 55296), (char)(n % 1024 + 56320)};
        return new CharSlice(cArray, 0, 2);
    }

    private static int[] insert(int[] nArray, int n, int n2, int n3) {
        if (n + 1 > nArray.length) {
            int[] nArray2 = new int[n + 10];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        for (int i = n - 1; i >= n3; --i) {
            nArray[i + 1] = nArray[i];
        }
        nArray[n3] = n2;
        return nArray;
    }

    private class SubPicture
    implements Serializable {
        int minWholePartSize = 0;
        int maxWholePartSize = 0;
        int minFractionPartSize = 0;
        int maxFractionPartSize = 0;
        boolean isPercent = false;
        boolean isPerMille = false;
        String prefix = "";
        String suffix = "";
        int[] wholePartGroupingPositions = null;
        int[] fractionalPartGroupingPositions = null;

        public SubPicture(int[] nArray, DecimalSymbols decimalSymbols) throws XPathException {
            int n;
            int n2;
            int n3;
            int n4 = decimalSymbols.percent;
            int n5 = decimalSymbols.permill;
            int n6 = decimalSymbols.decimalSeparator;
            int n7 = decimalSymbols.groupingSeparator;
            int n8 = decimalSymbols.digit;
            int n9 = decimalSymbols.zeroDigit;
            ArrayList<Integer> arrayList = null;
            ArrayList<Integer> arrayList2 = null;
            boolean bl = false;
            boolean bl2 = false;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] != n8 && nArray[n3] != n9) continue;
                bl = true;
                break;
            }
            if (!bl) {
                FormatNumber2.this.grumble("subpicture contains no digit or zero-digit sign");
            }
            n3 = 0;
            block30: for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                if (n == n4 || n == n5) {
                    if (this.isPercent || this.isPerMille) {
                        FormatNumber2.this.grumble("Cannot have more than one percent or per-mille character in a sub-picture");
                    }
                    this.isPercent = n == n4;
                    this.isPerMille = n == n5;
                    switch (n3) {
                        case 0: {
                            this.prefix = this.prefix + FormatNumber2.unicodeChar(n);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            n3 = 5;
                            this.suffix = this.suffix + FormatNumber2.unicodeChar(n);
                        }
                    }
                    continue;
                }
                if (n == n8) {
                    switch (n3) {
                        case 0: 
                        case 1: {
                            n3 = 1;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 2: {
                            FormatNumber2.this.grumble("Digit sign must not appear after a zero-digit sign in the integer part of a sub-picture");
                            break;
                        }
                        case 3: 
                        case 4: {
                            n3 = 4;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 5: {
                            FormatNumber2.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                    continue;
                }
                if (n == n9) {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: {
                            n3 = 2;
                            ++this.minWholePartSize;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 3: {
                            ++this.minFractionPartSize;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 4: {
                            FormatNumber2.this.grumble("Zero digit sign must not appear after a digit sign in the fractional part of a sub-picture");
                            break;
                        }
                        case 5: {
                            FormatNumber2.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                    continue;
                }
                if (n == n6) {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: {
                            n3 = 3;
                            bl2 = true;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            if (bl2) {
                                FormatNumber2.this.grumble("There must only be one decimal separator in a sub-picture");
                                break;
                            }
                            FormatNumber2.this.grumble("Decimal separator cannot come after a character in the suffix");
                        }
                    }
                    continue;
                }
                if (n == n7) {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: {
                            if (arrayList == null) {
                                arrayList = new ArrayList<Integer>(3);
                            }
                            arrayList.add(new Integer(this.maxWholePartSize));
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (this.maxFractionPartSize == 0) {
                                FormatNumber2.this.grumble("Grouping separator cannot be adjacent to decimal separator");
                            }
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<Integer>(3);
                            }
                            arrayList2.add(new Integer(this.maxFractionPartSize));
                            break;
                        }
                        case 5: {
                            FormatNumber2.this.grumble("Grouping separator found in suffix of sub-picture");
                        }
                    }
                    continue;
                }
                switch (n3) {
                    case 0: {
                        this.prefix = this.prefix + FormatNumber2.unicodeChar(n);
                        continue block30;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n3 = 5;
                        this.suffix = this.suffix + FormatNumber2.unicodeChar(n);
                    }
                }
            }
            if (arrayList != null) {
                n2 = arrayList.size();
                this.wholePartGroupingPositions = new int[n2];
                for (n = 0; n < n2; ++n) {
                    this.wholePartGroupingPositions[n] = this.maxWholePartSize - (Integer)arrayList.get(n2 - n - 1);
                }
                if (n2 > 1) {
                    n = 1;
                    int n10 = this.wholePartGroupingPositions[0];
                    for (int i = 1; i < n2; ++i) {
                        if (this.wholePartGroupingPositions[i] == i * n10) continue;
                        n = 0;
                        break;
                    }
                    if (n != 0) {
                        this.wholePartGroupingPositions = new int[1];
                        this.wholePartGroupingPositions[0] = n10;
                    }
                }
                if (this.wholePartGroupingPositions[0] == 0) {
                    FormatNumber2.this.grumble("Cannot have a grouping separator adjacent to the decimal separator");
                }
            }
            if (arrayList2 != null) {
                n2 = arrayList2.size();
                this.fractionalPartGroupingPositions = new int[n2];
                for (n = 0; n < n2; ++n) {
                    this.fractionalPartGroupingPositions[n] = (Integer)arrayList2.get(n);
                }
            }
        }

        public CharSequence format(NumericValue numericValue, DecimalSymbols decimalSymbols, String string) {
            int n;
            int n2;
            Object object;
            if (numericValue.isNaN()) {
                return decimalSymbols.NaN;
            }
            if (numericValue instanceof DoubleValue && Double.isInfinite(numericValue.getDoubleValue())) {
                return string + this.prefix + decimalSymbols.infinity + this.suffix;
            }
            if (numericValue instanceof FloatValue && Double.isInfinite(numericValue.getDoubleValue())) {
                return string + this.prefix + decimalSymbols.infinity + this.suffix;
            }
            int n3 = 1;
            if (this.isPercent) {
                n3 = 100;
            } else if (this.isPerMille) {
                n3 = 1000;
            }
            if (n3 != 1) {
                try {
                    numericValue = numericValue.arithmetic(17, new Int64Value(n3), null);
                }
                catch (XPathException xPathException) {
                    numericValue = new DoubleValue(numericValue.getDoubleValue() * (double)n3);
                }
            }
            StringBuffer stringBuffer = new StringBuffer(20);
            if (numericValue instanceof DoubleValue || numericValue instanceof FloatValue) {
                object = FormatNumber2.adjustToDecimal(numericValue.getDoubleValue(), 2);
                this.formatDecimal((BigDecimal)object, stringBuffer);
            } else if (numericValue instanceof Int64Value || numericValue instanceof BigIntegerValue) {
                this.formatInteger(numericValue, stringBuffer);
            } else if (numericValue instanceof DecimalValue) {
                this.formatDecimal(((DecimalValue)numericValue).getDecimalValue(), stringBuffer);
            }
            object = StringValue.expand(stringBuffer);
            int n4 = ((Object)object).length;
            int n5 = stringBuffer.indexOf(".");
            if (n5 == -1) {
                n5 = stringBuffer.length();
            } else {
                object[n5] = decimalSymbols.decimalSeparator;
                if (this.maxFractionPartSize == 0) {
                    --n4;
                }
            }
            if (decimalSymbols.zeroDigit != 48) {
                n2 = decimalSymbols.zeroDigit;
                for (n = 0; n < n4; ++n) {
                    Object object2 = object[n];
                    if (object2 < 48 || object2 > 57) continue;
                    object[n] = object2 - 48 + n2;
                }
            }
            if (this.wholePartGroupingPositions != null) {
                if (this.wholePartGroupingPositions.length == 1) {
                    n2 = this.wholePartGroupingPositions[0];
                    for (n = n5 - n2; n > 0; n -= n2) {
                        object = FormatNumber2.insert((int[])object, n4++, decimalSymbols.groupingSeparator, n);
                    }
                } else {
                    for (n2 = 0; n2 < this.wholePartGroupingPositions.length; ++n2) {
                        n = n5 - this.wholePartGroupingPositions[n2];
                        if (n <= 0) continue;
                        object = FormatNumber2.insert((int[])object, n4++, decimalSymbols.groupingSeparator, n);
                    }
                }
            }
            if (this.fractionalPartGroupingPositions != null) {
                for (n2 = 0; n2 < this.fractionalPartGroupingPositions.length && (n = n5 + 1 + this.fractionalPartGroupingPositions[n2] + n2) < n4 - 1; ++n2) {
                    object = FormatNumber2.insert((int[])object, n4++, decimalSymbols.groupingSeparator, n);
                }
            }
            FastStringBuffer fastStringBuffer = new FastStringBuffer(this.prefix.length() + string.length() + this.suffix.length() + n4);
            fastStringBuffer.append(string);
            fastStringBuffer.append(this.prefix);
            fastStringBuffer.append(StringValue.contract((int[])object, n4));
            fastStringBuffer.append(this.suffix);
            return fastStringBuffer;
        }

        private void formatDecimal(BigDecimal bigDecimal, StringBuffer stringBuffer) {
            int n;
            int n2;
            bigDecimal = bigDecimal.setScale(this.maxFractionPartSize, 6);
            stringBuffer.append(bigDecimal.toString());
            int n3 = stringBuffer.indexOf(".");
            if (n3 >= 0) {
                for (n2 = this.maxFractionPartSize - this.minFractionPartSize; n2 > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '0'; --n2) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                n = n3;
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '.') {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
            } else {
                n = stringBuffer.length();
            }
            for (n2 = 0; n2 < this.minWholePartSize - n; ++n2) {
                stringBuffer.insert(0, '0');
            }
        }

        private void formatInteger(NumericValue numericValue, StringBuffer stringBuffer) {
            int n;
            stringBuffer.append(numericValue.toString());
            int n2 = this.minWholePartSize - stringBuffer.length();
            for (n = 0; n < n2; ++n) {
                stringBuffer.insert(0, '0');
            }
            if (this.minFractionPartSize != 0) {
                stringBuffer.append('.');
                for (n = 0; n < this.minFractionPartSize; ++n) {
                    stringBuffer.append('0');
                }
            }
        }
    }
}

