/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.handler.input;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.aae.InProcessCache;
import org.apache.uima.aae.SerializerCache;
import org.apache.uima.aae.UimaSerializer;
import org.apache.uima.aae.controller.AggregateAnalysisEngineController;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.aae.controller.BaseAnalysisEngineController;
import org.apache.uima.aae.controller.Endpoint;
import org.apache.uima.aae.controller.LocalCache;
import org.apache.uima.aae.delegate.Delegate;
import org.apache.uima.aae.error.AsynchAEException;
import org.apache.uima.aae.error.ErrorContext;
import org.apache.uima.aae.error.ExpiredMessageException;
import org.apache.uima.aae.error.ServiceShutdownException;
import org.apache.uima.aae.error.UimaAsDelegateException;
import org.apache.uima.aae.error.UimaEEServiceException;
import org.apache.uima.aae.handler.HandlerBase;
import org.apache.uima.aae.jmx.ServicePerformance;
import org.apache.uima.aae.message.MessageContext;
import org.apache.uima.aae.monitor.statistics.AnalysisEnginePerformanceMetrics;
import org.apache.uima.aae.monitor.statistics.LongNumericStatistic;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.BinaryCasSerDes6;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.util.Level;

public class ProcessResponseHandler
extends HandlerBase {
    private static final Class CLASS_NAME = ProcessResponseHandler.class;

    public ProcessResponseHandler(String aName) {
        super(aName);
    }

    private Endpoint lookupEndpoint(String anEndpointName, String aCasReferenceId) {
        return this.getController().getInProcessCache().getEndpoint(anEndpointName, aCasReferenceId);
    }

    private void cancelTimer(MessageContext aMessageContext, String aCasReferenceId, boolean removeEndpoint) throws AsynchAEException {
        if (aMessageContext != null && aMessageContext.getEndpoint() != null) {
            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "cancelTimer", "uimaee_messages", "UIMAEE_cancel_timer__FINE", new Object[]{aMessageContext.getEndpoint().getEndpoint(), aCasReferenceId});
            }
            if (aCasReferenceId == null && aMessageContext.propertyExists("Command") && aMessageContext.getMessageIntProperty("Command") == 2002) {
                aCasReferenceId = ":CpC";
            }
            if (aMessageContext != null && aMessageContext.getEndpoint() != null) {
                Endpoint endpoint = this.lookupEndpoint(aMessageContext.getEndpoint().getEndpoint(), aCasReferenceId);
                if (endpoint != null) {
                    endpoint.cancelTimer();
                    if (removeEndpoint) {
                        this.getController().getInProcessCache().removeEndpoint(aMessageContext.getEndpoint().getEndpoint(), aCasReferenceId);
                    }
                } else if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "cancelTimer", "uimaee_messages", "UIMAEE_endpoint_not_found__INFO", new Object[]{aMessageContext.getEndpoint().getEndpoint(), aCasReferenceId});
                }
            }
        }
    }

    private void cancelTimerAndProcess(MessageContext aMessageContext, String aCasReferenceId, CAS aCAS) throws AsynchAEException {
        this.computeStats(aMessageContext, aCasReferenceId);
        super.invokeProcess(aCAS, aCasReferenceId, null, aMessageContext, null);
    }

    private boolean isMessageExpected(String aCasReferenceId, Endpoint anEndpointWithTimer) {
        return this.getController().getInProcessCache().entryExists(aCasReferenceId) && anEndpointWithTimer.isWaitingForResponse();
    }

    private void handleUnexpectedMessage(String aCasReferenceId, Endpoint anEndpoint) {
        ErrorContext errorContext = new ErrorContext();
        errorContext.add("CasReference", aCasReferenceId);
        errorContext.add("Command", 2000);
        errorContext.add("Endpoint", anEndpoint);
        AnalysisEngineController controller = this.getController();
        controller.getErrorHandlerChain().handle(new ExpiredMessageException(), errorContext, controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessResponseFromRemote(MessageContext aMessageContext, String aDelegateKey) {
        CAS cas = null;
        String casReferenceId = null;
        Endpoint endpointWithTimer = null;
        try {
            SerialFormat serialFormat;
            long t1;
            int totalNumberOfParallelDelegatesProcessingCas;
            LocalCache.CasStateEntry casStateEntry;
            InProcessCache.CacheEntry cacheEntry;
            String xmi;
            block50: {
                String adjustedUniqueName;
                ServicePerformance delegateServicePerformance;
                int payload = aMessageContext.getMessageIntProperty("Payload");
                casReferenceId = aMessageContext.getMessageStringProperty("CasReference");
                endpointWithTimer = this.lookupEndpoint(aMessageContext.getEndpoint().getEndpoint(), casReferenceId);
                if (endpointWithTimer == null) {
                    if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleProcessResponseFromRemote", "uimaee_messages", "UIMAEE_invalid_endpoint__WARNING", new Object[]{aMessageContext.getEndpoint().getEndpoint(), casReferenceId});
                    }
                    return;
                }
                String delegateKey = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(aMessageContext.getEndpoint().getEndpoint());
                Delegate delegate = ((AggregateAnalysisEngineController)this.getController()).lookupDelegate(delegateKey);
                boolean casRemovedFromOutstandingList = delegate.removeCasFromOutstandingList(casReferenceId);
                if (!casRemovedFromOutstandingList) {
                    return;
                }
                if (aDelegateKey != null && (delegateServicePerformance = ((AggregateAnalysisEngineController)this.getController()).getServicePerformance(aDelegateKey)) != null) {
                    delegateServicePerformance.incrementNumberOfCASesProcessed();
                }
                xmi = aMessageContext.getStringMessage();
                cacheEntry = this.getController().getInProcessCache().getCacheEntryForCAS(casReferenceId);
                if (aMessageContext.propertyExists("CASPerComponentMetrics")) {
                    try {
                        InProcessCache.CacheEntry ancestor = this.getController().getInProcessCache().getTopAncestorCasEntry(cacheEntry);
                        if (ancestor != null) {
                            List<AnalysisEnginePerformanceMetrics> metrics = UimaSerializer.deserializePerformanceMetrics(aMessageContext.getMessageStringProperty("CASPerComponentMetrics"));
                            ArrayList<AnalysisEnginePerformanceMetrics> adjustedMetrics = new ArrayList<AnalysisEnginePerformanceMetrics>();
                            for (AnalysisEnginePerformanceMetrics delegateMetric : metrics) {
                                adjustedUniqueName = ((AggregateAnalysisEngineController)this.getController()).getJmxContext();
                                if (adjustedUniqueName.startsWith("p0=")) {
                                    adjustedUniqueName = adjustedUniqueName.substring(3);
                                }
                                if (!(adjustedUniqueName = adjustedUniqueName.replaceAll(" Components", "")).startsWith("/")) {
                                    adjustedUniqueName = "/" + adjustedUniqueName;
                                }
                                adjustedUniqueName = adjustedUniqueName + delegateMetric.getUniqueName();
                                boolean found = false;
                                AnalysisEnginePerformanceMetrics metric = null;
                                for (AnalysisEnginePerformanceMetrics met : ancestor.getDelegateMetrics()) {
                                    if (!met.getUniqueName().equals(adjustedUniqueName)) continue;
                                    long at = delegateMetric.getAnalysisTime();
                                    long count = delegateMetric.getNumProcessed();
                                    metric = new AnalysisEnginePerformanceMetrics(delegateMetric.getName(), adjustedUniqueName, at, count);
                                    found = true;
                                    ancestor.getDelegateMetrics().remove(met);
                                    break;
                                }
                                if (!found) {
                                    metric = new AnalysisEnginePerformanceMetrics(delegateMetric.getName(), adjustedUniqueName, delegateMetric.getAnalysisTime(), delegateMetric.getNumProcessed());
                                }
                                adjustedMetrics.add(metric);
                            }
                            ancestor.addDelegateMetrics(delegateKey, adjustedMetrics, true);
                        }
                    }
                    catch (Exception ancestor) {
                        // empty catch block
                    }
                }
                if ((casStateEntry = ((AggregateAnalysisEngineController)this.getController()).getLocalCache().lookupEntry(casReferenceId)) == null) {
                    return;
                }
                casStateEntry.setReplyReceived();
                casStateEntry.setLastDelegate(delegate);
                cas = cacheEntry.getCas();
                totalNumberOfParallelDelegatesProcessingCas = casStateEntry.getNumberOfParallelDelegates();
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessResponseFromRemote", "uimaee_messages", "UIMAEE_number_parallel_delegates_FINE", new Object[]{totalNumberOfParallelDelegatesProcessingCas, Thread.currentThread().getId(), Thread.currentThread().getName()});
                }
                if (totalNumberOfParallelDelegatesProcessingCas > 1) {
                    casStateEntry.blockIfParallelDispatchNotComplete();
                }
                if (cas == null) {
                    throw new AsynchAEException(Thread.currentThread().getName() + "-Cache Does not contain a CAS. Cas Reference Id::" + casReferenceId);
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessResponseFromRemote", "uimaee_messages", "UIMAEE_rcvd_reply_FINEST", new Object[]{aMessageContext.getEndpoint().getEndpoint(), casReferenceId, xmi});
                }
                t1 = this.getController().getCpuTime();
                if (!aMessageContext.getMessageBooleanProperty("SentDeltaCas")) {
                    cacheEntry.setAcceptsDeltaCas(false);
                }
                serialFormat = endpointWithTimer.getSerialFormat();
                if (totalNumberOfParallelDelegatesProcessingCas <= 1) break block50;
                adjustedUniqueName = cas;
                synchronized (adjustedUniqueName) {
                    block52: {
                        int highWaterMark;
                        block51: {
                            if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessResponseFromRemote", "uimaee_messages", "UIMAEE_delegate_responded_count_FINEST", new Object[]{casStateEntry.howManyDelegatesResponded(), casReferenceId});
                            }
                            if (!aMessageContext.getMessageBooleanProperty("SentDeltaCas")) break block51;
                            switch (serialFormat) {
                                case XMI: {
                                    highWaterMark = cacheEntry.getHighWaterMark();
                                    this.deserialize(xmi, cas, casReferenceId, highWaterMark, AllowPreexistingFS.disallow);
                                    break block52;
                                }
                                case COMPRESSED_FILTERED: {
                                    this.deserialize(aMessageContext.getByteMessage(), cas, cacheEntry, endpointWithTimer.getTypeSystemImpl(), AllowPreexistingFS.disallow);
                                    break block52;
                                }
                                default: {
                                    throw new UIMARuntimeException((Throwable)new Exception("Internal error"));
                                }
                            }
                        }
                        if (casStateEntry.howManyDelegatesResponded() == 0) {
                            this.deserialize(xmi, cas, casReferenceId);
                        } else {
                            highWaterMark = cacheEntry.getHighWaterMark();
                            this.deserialize(xmi, cas, casReferenceId, highWaterMark, AllowPreexistingFS.ignore);
                        }
                    }
                    casStateEntry.incrementHowManyDelegatesResponded();
                }
            }
            byte[] binaryData = aMessageContext.getByteMessage();
            ByteArrayInputStream istream = new ByteArrayInputStream(binaryData);
            switch (serialFormat) {
                case BINARY: {
                    ((CASImpl)cas).reinit((InputStream)istream);
                    break;
                }
                case COMPRESSED_FILTERED: {
                    BinaryCasSerDes6 bcs = new BinaryCasSerDes6((AbstractCas)cas, (MarkerImpl)cacheEntry.getMarker(), endpointWithTimer.getTypeSystemImpl(), cacheEntry.getCompress6ReuseInfo());
                    bcs.deserialize((InputStream)istream, AllowPreexistingFS.allow);
                    break;
                }
                case XMI: {
                    if (aMessageContext.getMessageBooleanProperty("SentDeltaCas")) {
                        int highWaterMark = cacheEntry.getHighWaterMark();
                        this.deserialize(xmi, cas, casReferenceId, highWaterMark, AllowPreexistingFS.allow);
                        break;
                    }
                    this.deserialize(xmi, cas, casReferenceId);
                    break;
                }
                default: {
                    throw new UIMARuntimeException((Throwable)new Exception("Internal error"));
                }
            }
            long timeToDeserializeCAS = this.getController().getCpuTime() - t1;
            this.getController().getServicePerformance().incrementCasDeserializationTime(timeToDeserializeCAS);
            ServicePerformance casStats = this.getController().getCasStatistics(casReferenceId);
            casStats.incrementCasDeserializationTime(timeToDeserializeCAS);
            LongNumericStatistic statistic = this.getController().getMonitor().getLongNumericStatistic("", "TotalDeserializeTime");
            if (statistic != null) {
                statistic.increment(timeToDeserializeCAS);
            }
            this.computeStats(aMessageContext, casReferenceId);
            if (totalNumberOfParallelDelegatesProcessingCas == 1 || this.receivedAllResponsesFromParallelDelegates(casStateEntry, totalNumberOfParallelDelegatesProcessingCas)) {
                super.invokeProcess(cas, casReferenceId, null, aMessageContext, null);
            }
        }
        catch (Exception e) {
            if (e instanceof AsynchAEException && e.getMessage() != null && e.getMessage().startsWith("Cas Not Found")) {
                String key = "N/A";
                if (endpointWithTimer != null) {
                    key = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(endpointWithTimer.getEndpoint());
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "handleProcessResponseFromRemote", "uimaee_messages", "UIMAEE_stale_reply__INFO", new Object[]{this.getController().getComponentName(), key, casReferenceId});
                }
                return;
            }
            ErrorContext errorContext = new ErrorContext();
            errorContext.add("Command", 2000);
            errorContext.add("CasReference", casReferenceId);
            errorContext.add("Endpoint", aMessageContext.getEndpoint());
            this.getController().getErrorHandlerChain().handle(e, errorContext, this.getController());
        }
        finally {
            this.incrementDelegateProcessCount(aMessageContext);
        }
    }

    private synchronized boolean receivedAllResponsesFromParallelDelegates(LocalCache.CasStateEntry aCasStateEntry, int totalNumberOfParallelDelegatesProcessingCas) {
        if (aCasStateEntry.howManyDelegatesResponded() == totalNumberOfParallelDelegatesProcessingCas) {
            aCasStateEntry.resetDelegateResponded();
            return true;
        }
        return false;
    }

    private void deserialize(String xmi, CAS cas, String casReferenceId, int highWaterMark, AllowPreexistingFS allow) throws Exception {
        XmiSerializationSharedData deserSharedData = this.getController().getInProcessCache().getCacheEntryForCAS(casReferenceId).getDeserSharedData();
        UimaSerializer uimaSerializer = SerializerCache.lookupSerializerByThreadId();
        uimaSerializer.deserializeCasFromXmi(xmi, cas, deserSharedData, true, highWaterMark, allow);
    }

    private void deserialize(byte[] bytes, CAS cas, InProcessCache.CacheEntry cacheEntry, TypeSystemImpl remoteTs, AllowPreexistingFS allow) throws Exception {
        ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
        BinaryCasSerDes6.ReuseInfo reuseInfo = cacheEntry.getCompress6ReuseInfo();
        Serialization.deserializeCAS((CAS)cas, (InputStream)istream, (TypeSystem)remoteTs, (BinaryCasSerDes6.ReuseInfo)reuseInfo, (AllowPreexistingFS)allow);
    }

    private void deserialize(String xmi, CAS cas, String casReferenceId) throws Exception {
        InProcessCache.CacheEntry entry = this.getController().getInProcessCache().getCacheEntryForCAS(casReferenceId);
        XmiSerializationSharedData deserSharedData = entry.getDeserSharedData();
        if (deserSharedData == null) {
            deserSharedData = new XmiSerializationSharedData();
            entry.setXmiSerializationData(deserSharedData);
        }
        UimaSerializer uimaSerializer = SerializerCache.lookupSerializerByThreadId();
        uimaSerializer.deserializeCasFromXmi(xmi, cas, deserSharedData, true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessResponseWithCASReference(MessageContext aMessageContext) {
        block17: {
            String casReferenceId = null;
            InProcessCache.CacheEntry cacheEntry = null;
            try {
                casReferenceId = aMessageContext.getMessageStringProperty("CasReference");
                cacheEntry = this.getController().getInProcessCache().getCacheEntryForCAS(casReferenceId);
                LocalCache.CasStateEntry casStateEntry = ((AggregateAnalysisEngineController)this.getController()).getLocalCache().lookupEntry(casReferenceId);
                CAS cas = cacheEntry.getCas();
                String delegateKey = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(aMessageContext.getEndpoint().getEndpoint());
                Delegate delegate = ((AggregateAnalysisEngineController)this.getController()).lookupDelegate(delegateKey);
                if (casStateEntry != null) {
                    casStateEntry.setReplyReceived();
                    casStateEntry.setLastDelegate(delegate);
                }
                delegate.removeCasFromOutstandingList(casReferenceId);
                if (cas != null) {
                    this.cancelTimerAndProcess(aMessageContext, casReferenceId, cas);
                    break block17;
                }
                if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "handleProcessResponseWithCASReference", "uimaee_messages", "UIMAEE_cas_not_in_cache__INFO", new Object[]{this.getController().getName(), casReferenceId, aMessageContext.getEndpoint().getEndpoint()});
                }
                throw new AsynchAEException("CAS with Reference Id:" + casReferenceId + " Not Found in CasManager's CAS Cache");
            }
            catch (Exception e) {
                ErrorContext errorContext = new ErrorContext();
                errorContext.add("Command", 2000);
                errorContext.add("CasReference", casReferenceId);
                errorContext.add("Endpoint", aMessageContext.getEndpoint());
                this.getController().getErrorHandlerChain().handle(e, errorContext, this.getController());
            }
            finally {
                block18: {
                    this.incrementDelegateProcessCount(aMessageContext);
                    if (this.getController() instanceof AggregateAnalysisEngineController) {
                        try {
                            Endpoint endpoint;
                            String endpointName = aMessageContext.getEndpoint().getEndpoint();
                            String delegateKey = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(endpointName);
                            if (delegateKey != null && (endpoint = ((AggregateAnalysisEngineController)this.getController()).lookUpEndpoint(delegateKey, false)) != null && endpoint.isCasMultiplier() && cacheEntry.isAborted() && !this.getController().getInProcessCache().isEmpty()) {
                                this.getController().getInProcessCache().registerCallbackWhenCacheEmpty(this.getController().getEventListener());
                            }
                        }
                        catch (Exception e) {
                            if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.WARNING)) break block18;
                            if (this.getController() != null) {
                                UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "handleProcessResponseWithCASReference", "uimaee_messages", "UIMAEE_service_exception_WARNING", (Object)this.getController().getComponentName());
                            }
                            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleProcessResponseWithCASReference", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void incrementDelegateProcessCount(MessageContext aMessageContext) {
        block3: {
            Endpoint endpoint = aMessageContext.getEndpoint();
            if (endpoint != null && this.getController() instanceof AggregateAnalysisEngineController) {
                try {
                    String delegateKey = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(endpoint.getEndpoint());
                    LongNumericStatistic stat = this.getController().getMonitor().getLongNumericStatistic(delegateKey, "ProcessCount");
                    stat.increment();
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.INFO)) break block3;
                    UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "incrementDelegateProcessCount", "uimaee_messages", "UIMAEE_delegate_key_for_endpoint_not_found__INFO", new Object[]{this.getController().getComponentName(), endpoint.getEndpoint()});
                }
            }
        }
    }

    private boolean isException(Object object) {
        return object instanceof Exception || object instanceof Throwable;
    }

    private boolean isShutdownException(Object object) {
        return object instanceof Exception && object instanceof UimaEEServiceException && ((UimaEEServiceException)object).getCause() != null && ((UimaEEServiceException)object).getCause() instanceof ServiceShutdownException;
    }

    private boolean ignoreException(Object object) {
        return object == null || !this.isException(object) || this.isShutdownException(object);
    }

    private synchronized void handleProcessResponseWithException(MessageContext aMessageContext, String delegateKey) {
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINE)) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINE, CLASS_NAME.getName(), "handleProcessResponseWithException", "uimaee_messages", "UIMAEE_handling_exception_from_delegate_FINE", new Object[]{this.getController().getName(), aMessageContext.getEndpoint().getEndpoint()});
        }
        boolean isCpCError = false;
        String casReferenceId = null;
        try {
            Object object;
            if (aMessageContext.getMessageIntProperty("MessageType") == 3001 && aMessageContext.getMessageIntProperty("Command") == 2000) {
                this.incrementDelegateProcessCount(aMessageContext);
            }
            if ((object = aMessageContext.getObjectMessage()) == null && aMessageContext.getStringMessage() != null) {
                object = new UimaEEServiceException(aMessageContext.getStringMessage());
            }
            if (this.ignoreException(object)) {
                return;
            }
            if (this.getController() instanceof AggregateAnalysisEngineController && aMessageContext.propertyExists("Command") && aMessageContext.getMessageIntProperty("Command") == 2002) {
                isCpCError = true;
                ((AggregateAnalysisEngineController)this.getController()).processCollectionCompleteReplyFromDelegate(delegateKey, false);
            } else {
                casReferenceId = aMessageContext.getMessageStringProperty("CasReference");
            }
            if (object != null && (object instanceof Exception || object instanceof Throwable)) {
                String casid_msg = casReferenceId == null ? "" : " on CAS:" + casReferenceId;
                String controllerName = "/" + this.getController().getComponentName();
                if (!this.getController().isTopLevelComponent()) {
                    controllerName = controllerName + ((BaseAnalysisEngineController)this.getController().getParentController()).getUimaContextAdmin().getQualifiedContextName();
                }
                UimaAsDelegateException remoteException = new UimaAsDelegateException("----> Controller:" + controllerName + " Received Exception " + casid_msg + " From Delegate:" + delegateKey, (Exception)object);
                ErrorContext errorContext = new ErrorContext();
                errorContext.add("Command", aMessageContext.getMessageIntProperty("Command"));
                errorContext.add("MessageType", aMessageContext.getMessageIntProperty("MessageType"));
                if (!isCpCError) {
                    errorContext.add("CasReference", casReferenceId);
                }
                errorContext.add("Endpoint", aMessageContext.getEndpoint());
                this.getController().getErrorHandlerChain().handle(remoteException, errorContext, this.getController());
            }
        }
        catch (Exception e) {
            ErrorContext errorContext = new ErrorContext();
            errorContext.add("Command", 2000);
            errorContext.add("CasReference", casReferenceId);
            errorContext.add("Endpoint", aMessageContext.getEndpoint());
            this.getController().getErrorHandlerChain().handle(e, errorContext, this.getController());
        }
    }

    private void handleCollectionProcessCompleteReply(MessageContext aMessageContext, String delegateKey) {
        try {
            if (this.getController() instanceof AggregateAnalysisEngineController) {
                ((AggregateAnalysisEngineController)this.getController()).processCollectionCompleteReplyFromDelegate(delegateKey, true);
            }
        }
        catch (Exception e) {
            ErrorContext errorContext = new ErrorContext();
            errorContext.add("Command", 2002);
            errorContext.add("Endpoint", aMessageContext.getEndpoint());
            this.getController().getErrorHandlerChain().handle(e, errorContext, this.getController());
        }
    }

    private void resetErrorCounts(String aDelegate) {
        this.getController().getMonitor().resetCountingStatistic(aDelegate, "ProcessErrorCount");
        this.getController().getMonitor().resetCountingStatistic(aDelegate, "ProcessErrorRetryCount");
    }

    private void handlePingReply(MessageContext aMessageContext) {
    }

    private void handleServiceInfoReply(MessageContext messageContext) {
        String casReferenceId = null;
        try {
            casReferenceId = messageContext.getMessageStringProperty("CasReference");
            if (casReferenceId == null) {
                return;
            }
            Endpoint freeCasEndpoint = messageContext.getEndpoint();
            LocalCache.CasStateEntry casStateEntry = ((AggregateAnalysisEngineController)this.getController()).getLocalCache().lookupEntry(casReferenceId);
            if (casStateEntry != null) {
                casStateEntry.setFreeCasNotificationEndpoint(freeCasEndpoint);
                String serviceHostIp = messageContext.getMessageStringProperty("ServerIP");
                if (serviceHostIp != null) {
                    casStateEntry.setHostIpProcessingCAS(serviceHostIp);
                }
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.WARNING, this.getClass().getName(), "handleServiceInfoReply", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            return;
        }
    }

    @Override
    public void handle(Object anObjectToHandle) throws AsynchAEException {
        super.validate(anObjectToHandle);
        MessageContext messageContext = (MessageContext)anObjectToHandle;
        if (this.isHandlerForMessage(messageContext, 3001, 2000) || this.isHandlerForMessage(messageContext, 3001, 2004) || this.isHandlerForMessage(messageContext, 3001, 2008) || this.isHandlerForMessage(messageContext, 3001, 2002)) {
            int payload = messageContext.getMessageIntProperty("Payload");
            int command = messageContext.getMessageIntProperty("Command");
            String delegate = messageContext.getEndpoint().getEndpoint();
            String key = null;
            String fromServer = null;
            if (this.getController() instanceof AggregateAnalysisEngineController) {
                if (messageContext.getEndpoint().isRemote() && ((MessageContext)anObjectToHandle).propertyExists("EndpointServer")) {
                    fromServer = ((MessageContext)anObjectToHandle).getMessageStringProperty("EndpointServer");
                }
                key = ((AggregateAnalysisEngineController)this.getController()).lookUpDelegateKey(delegate, fromServer);
            }
            if (1001 == payload) {
                this.handleProcessResponseWithCASReference(messageContext);
                if (key != null) {
                    this.resetErrorCounts(key);
                }
            } else if (1000 == payload || 1006 == payload) {
                this.handleProcessResponseFromRemote(messageContext, key);
                if (key != null) {
                    this.resetErrorCounts(key);
                }
            } else if (1003 == payload) {
                if (key == null) {
                    key = messageContext.getEndpoint().getEndpoint();
                }
                this.handleProcessResponseWithException(messageContext, key);
            } else if (1005 == payload && 2002 == command) {
                if (key == null) {
                    key = messageContext.getEndpoint().getEndpoint();
                }
                this.handleCollectionProcessCompleteReply(messageContext, key);
            } else if (1005 == payload && 2004 == command) {
                this.handleACK(messageContext, key);
            } else if (1005 == payload && 2007 == command) {
                this.handlePingReply(messageContext);
            } else if (1005 == payload && 2008 == command) {
                this.handleServiceInfoReply(messageContext);
            } else {
                throw new AsynchAEException("Invalid Payload. Expected XMI or CasReferenceId Instead Got::" + payload);
            }
            return;
        }
        super.delegate(messageContext);
    }

    private void handleACK(MessageContext aMessageContext, String key) throws AsynchAEException {
    }
}

