/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.InputChannel;
import org.apache.uima.aae.controller.AnalysisEngineController;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;

public class WarmUpDataProvider {
    InputChannel inputChannel;
    AnalysisEngineController controller;
    private String inputFileName;
    private FileInputStream fis;
    private ZipInputStream zis;
    private ZipEntry nextEntry;
    private int docSeq;
    private boolean readingXmiFormat;
    private TypeSystem inputTS;
    private static final Class<?> CLASS_NAME = WarmUpDataProvider.class;

    public static void main(String[] args) {
        try {
            WarmUpDataProvider wdp = new WarmUpDataProvider(args[0]);
            System.out.println("Got it initialized");
            while (wdp.hasNext()) {
                System.out.println("Got next CAS");
            }
            System.out.println("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WarmUpDataProvider(String inputFileName) throws IOException {
        this.inputFileName = inputFileName;
        Import_impl theImport = new Import_impl();
        theImport.setSuffix(".zip");
        if (!inputFileName.endsWith(".zip")) {
            theImport.setName(inputFileName);
            this.inputFileName = this.resolveToAbsolutePath((Import)theImport);
            this.inputFileName = this.inputFileName.substring(this.inputFileName.indexOf(58) + 1);
        }
        this.fis = new FileInputStream(new File(this.inputFileName));
        this.zis = new ZipInputStream(new BufferedInputStream(this.fis, 102400));
        this.docSeq = 0;
    }

    private String resolveToAbsolutePath(Import theImport) {
        ResourceManager resourceManager = UIMAFramework.newDefaultResourceManager();
        try {
            return theImport.findAbsoluteUrl(resourceManager).toExternalForm();
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger(CLASS_NAME).isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, WarmUpDataProvider.class.getName(), "resolveToAbsolutePath", "uimaee_messages", "UIMAEE_exception__WARNING", (Throwable)e);
            }
            return "ERROR converting import by name to absolute path";
        }
    }

    public boolean hasNext() throws AnalysisEngineProcessException {
        try {
            this.nextEntry = this.zis.getNextEntry();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        return this.nextEntry != null;
    }

    public CAS next(CAS cas) throws Exception {
        if (0 == this.docSeq) {
            if (this.nextEntry.getName().equals("typesystem.xml")) {
                this.getTypesystem();
                this.readingXmiFormat = false;
            } else {
                this.readingXmiFormat = true;
            }
        } else if (this.nextEntry.getName().equals("typesystem.xml")) {
            throw new AnalysisEngineProcessException((Throwable)new RuntimeException("typesystem.xml entry found in the middle of input zipfile " + this.inputFileName));
        }
        byte[] buff = new byte[10000];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int bytesread;
            while (-1 != (bytesread = this.zis.read(buff))) {
                baos.write(buff, 0, bytesread);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
            if (this.readingXmiFormat) {
                XmiCasDeserializer.deserialize((InputStream)bis, (CAS)cas, (boolean)true);
            } else {
                Serialization.deserializeCAS((CAS)cas, (InputStream)bis, (TypeSystem)this.inputTS, null);
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        ++this.docSeq;
        return cas;
    }

    private void getTypesystem() throws AnalysisEngineProcessException {
        byte[] buff = new byte[10000];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int bytesread;
            while (-1 != (bytesread = this.zis.read(buff))) {
                baos.write(buff, 0, bytesread);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
            XMLParser xmlParser = UIMAFramework.getXMLParser();
            TypeSystemDescription tsDesc = xmlParser.parseTypeSystemDescription(new XMLInputSource((InputStream)bis, null));
            this.inputTS = CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, null).getTypeSystem();
            this.nextEntry = this.zis.getNextEntry();
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

