/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.Iterator;
import java.util.Map;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class EditSofaBindingsDialog
extends AbstractDialog {
    public String[] selectedSofaNames;
    private Map availAndBoundSofas;
    private String aggrSofaName;
    private Table table;

    public EditSofaBindingsDialog(AbstractSection aSection, String aAggrSofaName, Map aAvailAndBoundSofas) {
        super(aSection, "Assign Components and their sofas to an Aggregate Sofa Name", "Change the selection as needed to reflect bindings.");
        this.availAndBoundSofas = aAvailAndBoundSofas;
        this.aggrSofaName = aAggrSofaName;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label info = new Label(composite, 0);
        info.setText("Select all the delegate sofas from the list below which should be associated with the aggregate sofa name \"" + this.aggrSofaName + "\".\nHold down the Shift or Control keys to select multiple items.");
        this.table = this.newTable(composite, 2562);
        int i = 0;
        Iterator it = this.availAndBoundSofas.entrySet().iterator();
        while (it.hasNext()) {
            TableItem item = new TableItem(this.table, 0);
            Map.Entry entry = it.next();
            item.setText((String)entry.getKey());
            if (null != entry.getValue()) {
                this.table.select(i);
            }
            ++i;
        }
        this.table.pack();
        return composite;
    }

    @Override
    public void copyValuesFromGUI() {
        this.selectedSofaNames = new String[this.table.getSelectionCount()];
        int j = 0;
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            if (!this.table.isSelected(i)) continue;
            this.selectedSofaNames[j++] = this.table.getItem(i).getText();
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void enableOK() {
        this.okButton.setEnabled(true);
    }
}

