/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.check;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.check.AnnotationCheckContentProvider;
import org.apache.uima.ruta.check.AnnotationCheckLabelProvider;
import org.apache.uima.ruta.check.AnnotationCheckRootNode;
import org.apache.uima.ruta.check.AnnotationCheckTreeNode;
import org.apache.uima.ruta.check.AnnotationCheckTreeNodeComparator;
import org.apache.uima.ruta.check.AnnotationCheckView;
import org.apache.uima.ruta.check.ChangeFeatureValidator;
import org.apache.uima.ruta.check.CheckAnnotation;
import org.apache.uima.ruta.check.CheckAnnotationDocumentListener;
import org.apache.uima.ruta.check.CheckAnnotationUtils;
import org.apache.uima.ruta.check.CheckDocument;
import org.apache.uima.ruta.check.CheckElement;
import org.apache.uima.ruta.check.FeatureCheckTreeNode;
import org.apache.uima.ruta.check.FeatureCheckTreeNodeComparator;
import org.apache.uima.ruta.check.IAnnotationCheckTreeNode;
import org.apache.uima.ruta.check.SelectTypesDialogCheck;
import org.apache.uima.ruta.check.XMLUtils;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.xml.sax.SAXException;

public class AnnotationCheckComposite
extends Composite
implements ISelectionChangedListener,
ISelectionListener {
    private CheckAnnotationDocumentListener annotationListener;
    private AnnotationCheckTreeNodeComparator comparator = new AnnotationCheckTreeNodeComparator();
    private AnnotationCheckLabelProvider lableProvider;
    private TreeViewer treeView;
    private Text documentSource;
    private ViewPart viewPart;
    private Text pathToTypeSystem;
    private HashMap<String, Image> images;
    private Text documentSink;
    private Map<String, Set<String>> typesToCheck;
    private Set<String> typesToTransferUnchecked;
    private CheckDocument currentDocument = null;
    private String annotationMode;
    private AnnotationEditor casEditor;
    private List<CheckDocument> oldDocs;
    private TypeSystemDescription tsd;

    public AnnotationCheckComposite(Composite parent, int style, ViewPart viewPart) {
        super(parent, style);
        this.viewPart = viewPart;
        this.typesToCheck = new HashMap<String, Set<String>>();
        this.typesToTransferUnchecked = new HashSet<String>();
        this.initGui();
        this.annotationListener = new CheckAnnotationDocumentListener(this);
    }

    private void initGui() {
        this.setLayout((Layout)new FormLayout());
        this.setSize(400, 800);
        this.initDocumentSourceTextField();
        this.initDocumentSinkTextField();
        this.initTypeSystemPathTextField();
        this.initTreeViewer();
        this.viewPart.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.treeView);
    }

    private void initTreeViewer() {
        FormData fdata3 = new FormData();
        fdata3.left = new FormAttachment(0, 1000, 3);
        fdata3.top = new FormAttachment(0, 1000, 81);
        fdata3.right = new FormAttachment(1000, 1000, -3);
        fdata3.bottom = new FormAttachment(1000, 1000, -3);
        Composite comp = new Composite((Composite)this, 0x1000000);
        comp.setLayoutData((Object)fdata3);
        comp.setLayout((Layout)new FillLayout());
        this.treeView = new TreeViewer(comp, 770);
        AnnotationCheckContentProvider provider = new AnnotationCheckContentProvider();
        this.treeView.setContentProvider((IContentProvider)provider);
        this.treeView.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                char c = e.character;
                if (c == '4' || c == '5') {
                    if (c == '4') {
                        AnnotationCheckComposite.this.accept();
                    } else if (c == '5') {
                        AnnotationCheckComposite.this.reject(true);
                    }
                }
            }
        });
        this.treeView.setComparator((ViewerComparator)new FeatureCheckTreeNodeComparator());
        this.treeView.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Object source = e.getSource();
                if (source instanceof Tree && e.button == 3) {
                    Tree tree = (Tree)source;
                    Composite composite = tree.getParent().getParent();
                    TreeSelection teeSelection = (TreeSelection)AnnotationCheckComposite.this.treeView.getSelection();
                    Object node = teeSelection.getFirstElement();
                    Display display = Display.getDefault();
                    Shell shell = new Shell(display, 67696);
                    if (node instanceof AnnotationCheckTreeNode && !(node instanceof FeatureCheckTreeNode)) {
                        AnnotationCheckComposite.this.changeType(shell, composite, node);
                    }
                    if (node instanceof AnnotationCheckTreeNode && node instanceof FeatureCheckTreeNode) {
                        AnnotationCheckComposite.this.changeFeature(shell, node);
                    }
                }
            }
        });
        this.lableProvider = new AnnotationCheckLabelProvider(this);
        this.treeView.setLabelProvider((IBaseLabelProvider)this.lableProvider);
    }

    private void initTypeSystemPathTextField() {
        this.pathToTypeSystem = new Text((Composite)this, 2052);
        FormData fdata2 = new FormData();
        fdata2.width = 200;
        fdata2.left = new FormAttachment(0, 1000, 5);
        fdata2.top = new FormAttachment(0, 1000, 55);
        fdata2.right = new FormAttachment(1000, 1000, -5);
        this.pathToTypeSystem.setLayoutData((Object)fdata2);
        this.pathToTypeSystem.setToolTipText("Type System...");
        this.pathToTypeSystem.setMessage("Type System...");
        DropTarget dt1 = new DropTarget((Control)this.pathToTypeSystem, 18);
        dt1.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt1.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length > 0) {
                    String fileString = fileList[0];
                    AnnotationCheckComposite.this.pathToTypeSystem.setText(fileString);
                }
            }
        });
    }

    private void initDocumentSinkTextField() {
        this.documentSink = new Text((Composite)this, 2052);
        FormData fdatag = new FormData();
        fdatag.width = 200;
        fdatag.left = new FormAttachment(0, 1000, 5);
        fdatag.top = new FormAttachment(0, 1000, 30);
        fdatag.right = new FormAttachment(1000, 1000, -5);
        this.documentSink.setLayoutData((Object)fdatag);
        this.documentSink.setToolTipText("Document gold output folder...");
        this.documentSink.setMessage("Document gold output folder...");
        DropTarget dtg = new DropTarget((Control)this.documentSink, 18);
        dtg.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dtg.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length > 0) {
                    String fileString = fileList[0];
                    AnnotationCheckComposite.this.documentSink.setText(fileString);
                }
            }
        });
    }

    private void initDocumentSourceTextField() {
        this.documentSource = new Text((Composite)this, 2052);
        FormData fdata1 = new FormData();
        fdata1.width = 200;
        fdata1.left = new FormAttachment(0, 1000, 5);
        fdata1.top = new FormAttachment(0, 1000, 5);
        fdata1.right = new FormAttachment(1000, 1000, -5);
        this.documentSource.setLayoutData((Object)fdata1);
        this.documentSource.setToolTipText("Document source folder...");
        this.documentSource.setMessage("Document source folder...");
        DropTarget dt = new DropTarget((Control)this.documentSource, 18);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length > 0) {
                    String fileString = fileList[0];
                    AnnotationCheckComposite.this.documentSource.setText(fileString);
                }
            }
        });
    }

    private void changeType(Shell shell, Composite composite, Object node) {
        AnnotationCheckComposite annotCheckCompo = null;
        if (!(composite instanceof AnnotationCheckComposite)) {
            return;
        }
        annotCheckCompo = (AnnotationCheckComposite)composite;
        shell.setText("Change annotation type");
        TypeSystemDescription tsd = annotCheckCompo.getTypeSystemDescription();
        SelectTypesDialogCheck dialog = new SelectTypesDialogCheck(shell, tsd, null, false, 4, false);
        String newTypeName = null;
        if (dialog.open() == 0) {
            newTypeName = dialog.getChoosenType();
        }
        if (newTypeName != null) {
            AnnotationCheckTreeNode annotCheckTreeNode = (AnnotationCheckTreeNode)node;
            CheckAnnotation checkAnnot = (CheckAnnotation)annotCheckTreeNode.getElement();
            checkAnnot.setTypeName(newTypeName);
            String[] split = newTypeName.split("\\.");
            String shortTypeName = split[split.length - 1];
            checkAnnot.setShortType(shortTypeName);
            this.treeView.refresh();
            return;
        }
    }

    private void changeFeature(Shell shell, Object node) {
        FeatureCheckTreeNode featTreeNode = (FeatureCheckTreeNode)node;
        shell.setText("Change value of feature");
        Type range = featTreeNode.getFeature().getRange();
        ChangeFeatureValidator validator = new ChangeFeatureValidator(range);
        InputDialog dialog = new InputDialog(this.getShell(), "Define new feature value", "New feature value:", "", (IInputValidator)validator);
        if (dialog.open() == 0) {
            featTreeNode.setValue(dialog.getValue());
            this.treeView.refresh();
            return;
        }
    }

    public void dispose() {
        super.dispose();
        this.viewPart.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        Collection<Image> values = this.images.values();
        for (Image image : values) {
            image.dispose();
        }
    }

    public Image getImage(String name) {
        if (this.images == null) {
            this.initImages();
        }
        return this.images.get(name);
    }

    private void initImages() {
        this.images = new HashMap();
        ImageDescriptor desc = RutaAddonsPlugin.getImageDescriptor("/icons/accept.png");
        Image image = desc.createImage();
        String name = "accept";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/delete.png");
        image = desc.createImage();
        name = "delete";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/help.png");
        image = desc.createImage();
        name = "help";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/bullet_blue.png");
        image = desc.createImage();
        name = "feature";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/folder_page.png");
        image = desc.createImage();
        name = "folder";
        this.images.put(name, image);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof AnnotationCheckView && selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)selection;
            if (ts.getFirstElement() instanceof FeatureCheckTreeNode) {
                return;
            }
            if (ts.getFirstElement() instanceof AnnotationCheckTreeNode) {
                AnnotationCheckTreeNode firstElement = (AnnotationCheckTreeNode)ts.getFirstElement();
                CheckElement element = firstElement.getElement();
                int begin = 0;
                int end = 0;
                CheckDocument newDoc = null;
                if (element instanceof CheckAnnotation) {
                    begin = ((CheckAnnotation)element).getBegin();
                    end = ((CheckAnnotation)element).getEnd();
                    newDoc = (CheckDocument)firstElement.getParent().getElement();
                } else if (element instanceof CheckDocument) {
                    newDoc = (CheckDocument)element;
                } else {
                    return;
                }
                if (this.casEditor != null && this.casEditor.getDocumentProvider() != null && this.casEditor.getDocument() != null) {
                    IFile file = ((FileEditorInput)this.casEditor.getEditorInput()).getFile();
                    if (!newDoc.source.equals(file.getLocation().toOSString())) {
                        this.casEditor.getDocument().removeChangeListener((ICasDocumentListener)this.annotationListener);
                        this.casEditor = CheckAnnotationUtils.openInCasEditor(new File(newDoc.source), begin, end);
                        this.casEditor.getDocument().addChangeListener((ICasDocumentListener)this.annotationListener);
                    } else {
                        this.casEditor.selectAndReveal(begin, end - begin);
                    }
                } else {
                    this.casEditor = CheckAnnotationUtils.openInCasEditor(new File(newDoc.source), begin, end);
                    this.casEditor.getDocument().addChangeListener((ICasDocumentListener)this.annotationListener);
                }
                this.setAnnotationMode(this.annotationMode);
                Iterator typeIterator = this.casEditor.getDocument().getCAS().getTypeSystem().getTypeIterator();
                while (typeIterator.hasNext()) {
                    Type type = (Type)typeIterator.next();
                    boolean contains = this.typesToCheck.containsKey(type.getName());
                    this.casEditor.setShownAnnotationType(type, contains);
                }
                this.currentDocument = newDoc;
                this.treeView.getControl().setFocus();
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
    }

    public void restoreState(IMemento memento) {
        IMemento uncheckedTypes;
        IMemento selectedTypes;
        IMemento tsName;
        IMemento dir2;
        if (memento == null) {
            return;
        }
        IMemento dir = memento.getChild("documentSource");
        if (dir != null) {
            String id = dir.getID();
            this.documentSource.setText(id);
        }
        if ((dir2 = memento.getChild("documentSink")) != null) {
            String id = dir2.getID();
            this.documentSink.setText(id);
        }
        if ((tsName = memento.getChild("typeSystem")) != null) {
            String id = tsName.getID();
            this.pathToTypeSystem.setText(id);
        }
        if ((selectedTypes = memento.getChild("typesToCheck")) != null) {
            this.typesToCheck = new HashMap<String, Set<String>>();
            for (IMemento mementoTypesToCheck : selectedTypes.getChildren(selectedTypes.getID())) {
                String typeName = mementoTypesToCheck.getID();
                HashSet<String> features = new HashSet<String>();
                for (IMemento mementoFeature : mementoTypesToCheck.getChildren("feature")) {
                    features.add(mementoFeature.getID());
                }
                this.typesToCheck.put(typeName, features);
            }
        }
        if ((uncheckedTypes = memento.getChild("typesToTransferUnchecked")) != null) {
            this.typesToTransferUnchecked = new HashSet<String>();
            for (IMemento mementoUnchecked : uncheckedTypes.getChildren(uncheckedTypes.getID())) {
                String typeName = mementoUnchecked.getID();
                this.typesToTransferUnchecked.add(typeName);
            }
        }
    }

    public void saveState(IMemento memento) {
        memento.createChild("documentSource", this.documentSource.getText());
        memento.createChild("documentSink", this.documentSink.getText());
        memento.createChild("typeSystem", this.pathToTypeSystem.getText());
        IMemento selectedTypesMemento = memento.createChild("typesToCheck", "type");
        for (Map.Entry<String, Set<String>> checkedTypeEntry : this.typesToCheck.entrySet()) {
            IMemento selectedTypeMemento = selectedTypesMemento.createChild("type", checkedTypeEntry.getKey());
            for (String feature : checkedTypeEntry.getValue()) {
                selectedTypeMemento.createChild("feature", feature);
            }
        }
        IMemento uncheckTypesMemento = memento.createChild("typesToTransferUnchecked", "unchecked");
        for (String uncheckedTypeName : this.typesToTransferUnchecked) {
            uncheckTypesMemento.createChild("unchecked", uncheckedTypeName);
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeView;
    }

    public String getDocumentSource() {
        return this.documentSource.getText();
    }

    public String getDocumentSink() {
        return this.documentSink.getText();
    }

    public String getPathToTypeSystem() {
        return this.pathToTypeSystem.getText();
    }

    public Map<String, Set<String>> getCheckedTypes() {
        return this.typesToCheck;
    }

    public void setTypesToCheck(Map<String, Set<String>> typesToCheck) {
        this.typesToCheck = typesToCheck;
    }

    public void reject(boolean doMove) {
        TreeSelection selection = (TreeSelection)this.treeView.getSelection();
        AnnotationCheckTreeNode firstElement = (AnnotationCheckTreeNode)selection.getFirstElement();
        if (firstElement == null) {
            return;
        }
        firstElement.getElement().checked = true;
        firstElement.getElement().keep = false;
        if (doMove) {
            this.moveToNext();
        }
        this.treeView.refresh();
    }

    public void accept() {
        TreeSelection selection = (TreeSelection)this.treeView.getSelection();
        AnnotationCheckTreeNode firstElement = (AnnotationCheckTreeNode)selection.getFirstElement();
        if (firstElement == null) {
            return;
        }
        firstElement.getElement().checked = true;
        firstElement.getElement().keep = true;
        List<AnnotationCheckTreeNode> siblings = Arrays.asList(firstElement.getParent().getChildren());
        int indexOfFirstElement = siblings.indexOf(firstElement);
        CheckAnnotation firstElementAnnotation = (CheckAnnotation)firstElement.getElement();
        this.moveToNext();
        for (int i = indexOfFirstElement + 1; i < siblings.size(); ++i) {
            CheckElement nextSiblingCE = siblings.get(i).getElement();
            if (!(nextSiblingCE instanceof CheckAnnotation)) continue;
            CheckAnnotation nextSibling = (CheckAnnotation)nextSiblingCE;
            if (nextSibling.getBegin() != firstElementAnnotation.getBegin() || nextSibling.getEnd() != firstElementAnnotation.getEnd()) break;
            this.reject(true);
            if (i != siblings.size() - 1) continue;
            IAnnotationCheckTreeNode parent = siblings.get(0).getParent();
            parent.getElement().checked = true;
            parent.getElement().keep = true;
        }
        this.treeView.refresh();
    }

    public void moveToNext() {
        TreeSelection selection = (TreeSelection)this.treeView.getSelection();
        IAnnotationCheckTreeNode parent = null;
        AnnotationCheckTreeNode firstElement = null;
        if (selection.getFirstElement() instanceof FeatureCheckTreeNode) {
            return;
        }
        firstElement = (AnnotationCheckTreeNode)selection.getFirstElement();
        parent = firstElement.getParent();
        AnnotationCheckTreeNode[] children = parent.getChildren();
        List<AnnotationCheckTreeNode> list = Arrays.asList(children);
        int indexOf = list.indexOf(firstElement);
        IAnnotationCheckTreeNode brother = null;
        IAnnotationCheckTreeNode uncle = parent;
        if (list != null && !list.isEmpty()) {
            if (indexOf == -1) {
                brother = list.get(0);
            } else if (firstElement.getElement() instanceof CheckDocument && indexOf < list.size() - 1) {
                uncle = list.get(indexOf + 1);
                if (uncle.getChildren().length > 0) {
                    brother = uncle.getChildren()[0];
                }
            } else if (indexOf < list.size() - 1) {
                brother = list.get(indexOf + 1);
            } else if (firstElement.getElement() instanceof CheckAnnotation) {
                brother = null;
                AnnotationCheckTreeNode[] children2 = parent.getParent().getChildren();
                List<AnnotationCheckTreeNode> list2 = Arrays.asList(children2);
                int indexOf2 = list2.indexOf(parent);
                if (list2 != null && !list2.isEmpty()) {
                    if (indexOf2 == -1) {
                        uncle = list2.get(0);
                    } else if (indexOf2 < list2.size() - 1 && (uncle = (IAnnotationCheckTreeNode)list2.get(indexOf2 + 1)).getChildren().length != 0) {
                        brother = uncle.getChildren()[0];
                    }
                }
            }
        }
        TreePath treePath = null;
        treePath = brother == null ? new TreePath(new Object[]{this.treeView.getInput(), uncle}) : new TreePath(new Object[]{this.treeView.getInput(), uncle, brother});
        TreeSelection newSelection = new TreeSelection(treePath);
        this.treeView.setSelection((ISelection)newSelection, true);
        this.treeView.expandToLevel((Object)((AnnotationCheckTreeNode)newSelection.getFirstElement()).getParent(), -1);
        if (firstElement.getElement() instanceof CheckAnnotation) {
            boolean allChecked = true;
            boolean oneKeep = false;
            for (IAnnotationCheckTreeNode iAnnotationCheckTreeNode : list) {
                CheckElement element = iAnnotationCheckTreeNode.getElement();
                allChecked &= element.checked;
                oneKeep |= element.keep;
            }
            parent.getElement().checked = allChecked;
            parent.getElement().keep = oneKeep;
        }
    }

    public void save() {
        AnnotationCheckTreeNode root = (AnnotationCheckTreeNode)this.treeView.getInput();
        AnnotationCheckTreeNode[] children = root.getChildren();
        ArrayList<CheckDocument> docs = new ArrayList<CheckDocument>(this.oldDocs);
        TypeSystemDescription tsd = this.getTypeSystemDescription();
        CAS casSource = null;
        CAS cas = null;
        try {
            cas = CasCreationUtils.createCas((TypeSystemDescription)tsd, null, (FsIndexDescription[])new FsIndexDescription[0]);
            casSource = CasCreationUtils.createCas((TypeSystemDescription)tsd, null, (FsIndexDescription[])new FsIndexDescription[0]);
        }
        catch (ResourceInitializationException e) {
            RutaAddonsPlugin.error(e);
        }
        for (AnnotationCheckTreeNode each : children) {
            CheckDocument cd = (CheckDocument)each.getElement();
            if (cd.checked && cd.keep) {
                AnnotationCheckTreeNode[] annotationNodes;
                cas.reset();
                File oldFile = new File(cd.source);
                File goldFile = new File(this.documentSink.getText(), oldFile.getName());
                try {
                    if (goldFile.exists()) {
                        XmiCasDeserializer.deserialize((InputStream)new FileInputStream(goldFile), (CAS)cas, (boolean)false);
                    } else {
                        XmiCasDeserializer.deserialize((InputStream)new FileInputStream(oldFile), (CAS)cas, (boolean)true);
                    }
                }
                catch (FileNotFoundException e) {
                    RutaAddonsPlugin.error(e);
                }
                catch (SAXException e) {
                    RutaAddonsPlugin.error(e);
                }
                catch (IOException e) {
                    RutaAddonsPlugin.error(e);
                }
                String documentText = cas.getDocumentText();
                cas.reset();
                cas.setDocumentText(documentText);
                try {
                    XmiCasDeserializer.deserialize((InputStream)new FileInputStream(oldFile), (CAS)casSource, (boolean)true);
                }
                catch (FileNotFoundException e) {
                    RutaAddonsPlugin.error(e);
                }
                catch (SAXException e) {
                    RutaAddonsPlugin.error(e);
                }
                catch (IOException e) {
                    RutaAddonsPlugin.error(e);
                }
                for (String uncheckedTypeName : this.typesToTransferUnchecked) {
                    Type type = cas.getTypeSystem().getType(uncheckedTypeName);
                    if (type == null) continue;
                    for (AnnotationFS annot : casSource.getAnnotationIndex(type)) {
                        cas.addFsToIndexes((FeatureStructure)cas.createAnnotation(type, annot.getBegin(), annot.getEnd()));
                    }
                }
                for (AnnotationCheckTreeNode eachAN : annotationNodes = each.getChildren()) {
                    TypeSystem ts;
                    Type type;
                    CheckAnnotation ca = (CheckAnnotation)eachAN.getElement();
                    if (!ca.checked || !ca.keep || (type = (ts = this.casEditor.getDocument().getCAS().getTypeSystem()).getType(ca.getTypeName())) == null) continue;
                    AnnotationFS annotFS = ca.toAnnotationFS(cas, type);
                    if (eachAN.hasChildren()) {
                        FeatureCheckTreeNode[] featureNodes;
                        for (FeatureCheckTreeNode featureNode : featureNodes = (FeatureCheckTreeNode[])eachAN.getChildren()) {
                            Feature feature = featureNode.getFeature();
                            try {
                                annotFS.setFeatureValueFromString(feature, featureNode.getValue());
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    cas.addFsToIndexes((FeatureStructure)annotFS);
                }
                try {
                    CheckAnnotationUtils.writeXmi(cas, goldFile);
                }
                catch (Exception e) {
                    RutaAddonsPlugin.error(e);
                }
                cd.checkedTypes.addAll(this.typesToCheck.keySet());
                if (!docs.contains(cd)) {
                    docs.add(cd);
                }
            }
            File dataFile = new File(this.documentSink.getText(), "data.xml");
            try {
                XMLUtils.write(docs, dataFile);
            }
            catch (IOException e) {
                RutaAddonsPlugin.error(e);
            }
        }
    }

    public void setAnnotationMode(String typeString) {
        this.annotationMode = typeString;
        if (this.casEditor != null && this.casEditor.getDocument() != null && typeString != null) {
            Type type = this.casEditor.getDocument().getCAS().getTypeSystem().getType(typeString);
            this.casEditor.setAnnotationMode(type);
        }
    }

    public void addAnnotations(Collection<AnnotationFS> annotations) {
        AnnotationCheckTreeNode[] children;
        AnnotationCheckRootNode root = (AnnotationCheckRootNode)this.treeView.getInput();
        for (AnnotationCheckTreeNode docNode : children = root.getChildren()) {
            if (!docNode.getElement().equals(this.currentDocument)) continue;
            ArrayList<AnnotationCheckTreeNode> annotationList = new ArrayList<AnnotationCheckTreeNode>(Arrays.asList(docNode.getChildren()));
            for (AnnotationFS eachAnnotation : annotations) {
                CheckAnnotation ac = new CheckAnnotation(eachAnnotation);
                ac.checked = true;
                ac.keep = true;
                AnnotationCheckTreeNode anode = new AnnotationCheckTreeNode(docNode, ac);
                annotationList.add(anode);
            }
            Collections.sort(annotationList, this.comparator);
            docNode.setChildren(annotationList);
            this.treeView.refresh((Object)docNode);
            break;
        }
    }

    public void removeAnnotations(Collection<AnnotationFS> annotations) {
        AnnotationCheckTreeNode[] children;
        AnnotationCheckRootNode root = (AnnotationCheckRootNode)this.treeView.getInput();
        for (AnnotationCheckTreeNode docNode : children = root.getChildren()) {
            AnnotationCheckTreeNode[] achildren;
            if (!docNode.getElement().equals(this.currentDocument)) continue;
            for (AnnotationCheckTreeNode anode : achildren = docNode.getChildren()) {
                CheckAnnotation checkAnnotation = (CheckAnnotation)anode.getElement();
                for (AnnotationFS eachAnnotation : annotations) {
                    if (eachAnnotation.getBegin() != checkAnnotation.getBegin() || eachAnnotation.getEnd() != checkAnnotation.getBegin() || !eachAnnotation.getType().getName().equals(checkAnnotation.getTypeName())) continue;
                    checkAnnotation.checked = true;
                    checkAnnotation.keep = false;
                }
            }
            this.treeView.refresh((Object)docNode);
            break;
        }
    }

    public void updateAnnotations(Collection<AnnotationFS> annotations) {
    }

    public void setOldDocs(List<CheckDocument> docs) {
        this.oldDocs = docs;
    }

    public TypeSystemDescription getTypeSystemDescription() {
        this.refreshTypeSystem();
        return this.tsd;
    }

    public void refreshTypeSystem() {
        try {
            String typeSystem = this.getPathToTypeSystem();
            TypeSystemDescription tsd = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(new File(typeSystem)));
            tsd.resolveImports();
            this.tsd = tsd;
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Set<String>> getUncheckedTypes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String entry : this.typesToTransferUnchecked) {
            map.put(entry, null);
        }
        return map;
    }

    public void setUncheckedTypes(Set<String> typesToTransferUnchecked) {
        this.typesToTransferUnchecked = typesToTransferUnchecked;
    }
}

