/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditDistanceResultMap
extends HashMap<String, Set<String>> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean put(String query, String file) {
        if (!this.containsKey(query)) {
            this.put(query, new HashSet());
        }
        return ((Set)this.get(query)).add(file);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Set<String>> m) {
        for (String string : m.keySet()) {
            for (String file : m.get(string)) {
                this.put(string, file);
            }
        }
    }

    public boolean containsKey(Object query, String ignoreToken) {
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            String s;
            String temp = s = (String)i$.next();
            for (char c : ignoreToken.toCharArray()) {
                temp = temp.replaceAll("\\" + String.valueOf(c), "");
            }
            if (!temp.equals(query)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object key, boolean ignoreCase) {
        if (ignoreCase) {
            for (String s : this.keySet()) {
                if (!s.toLowerCase().equals(key)) continue;
                return true;
            }
            return false;
        }
        return super.containsKey(key);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        LinkedList keys = new LinkedList();
        keys.addAll(this.keySet());
        Collections.sort(keys);
        for (String s : keys) {
            result.append(s + ", [" + this.get(s) + "] | ");
        }
        return result.toString();
    }
}

