/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class FeatureCondition
extends AbstractRutaCondition {
    private final StringExpression featureStringExpression;
    private StringExpression stringExpr;
    private NumberExpression numberExpr;
    private BooleanExpression booleanExpr;
    private TypeExpression typeExpr;

    protected FeatureCondition(StringExpression feature) {
        this.featureStringExpression = feature;
    }

    public FeatureCondition(StringExpression feature, StringExpression stringExpr) {
        this(feature);
        this.stringExpr = stringExpr;
    }

    public FeatureCondition(StringExpression feature, NumberExpression numberExpr) {
        this(feature);
        this.numberExpr = numberExpr;
    }

    public FeatureCondition(StringExpression feature, BooleanExpression booleanExpr) {
        this(feature);
        this.booleanExpr = booleanExpr;
    }

    public FeatureCondition(StringExpression feature, TypeExpression typeExpr, String variable, RuleElement re) {
        this(feature);
        this.typeExpr = typeExpr;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        String stringValue = this.featureStringExpression.getStringValue(element.getParent());
        Feature featureByBaseName = annotation.getType().getFeatureByBaseName(stringValue);
        if (this.stringExpr != null) {
            String value = annotation.getStringValue(featureByBaseName);
            String string = this.stringExpr.getStringValue(element.getParent());
            boolean result = string != null && string.equals(value);
            return new EvaluatedCondition(this, result);
        }
        if (this.numberExpr != null) {
            String range = featureByBaseName.getRange().getName();
            boolean result = false;
            if (range.equals("uima.cas.Integer")) {
                int v;
                int value = annotation.getIntValue(featureByBaseName);
                result = value == (v = this.numberExpr.getIntegerValue(element.getParent()));
            } else if (range.equals("uima.cas.Double")) {
                double v;
                double value = annotation.getDoubleValue(featureByBaseName);
                result = value == (v = this.numberExpr.getDoubleValue(element.getParent()));
            } else if (range.equals("uima.cas.Float")) {
                float v;
                float value = annotation.getFloatValue(featureByBaseName);
                result = value == (v = this.numberExpr.getFloatValue(element.getParent()));
            } else if (range.equals("uima.cas.Byte")) {
                byte v;
                byte value = annotation.getByteValue(featureByBaseName);
                result = value == (v = (byte)this.numberExpr.getIntegerValue(element.getParent()));
            } else if (range.equals("uima.cas.Short")) {
                short v;
                short value = annotation.getShortValue(featureByBaseName);
                result = value == (v = (short)this.numberExpr.getIntegerValue(element.getParent()));
            } else if (range.equals("uima.cas.Long")) {
                long v;
                long value = annotation.getLongValue(featureByBaseName);
                result = value == (v = (long)this.numberExpr.getIntegerValue(element.getParent()));
            }
            return new EvaluatedCondition(this, result);
        }
        if (this.booleanExpr != null) {
            boolean v;
            boolean value = annotation.getBooleanValue(featureByBaseName);
            boolean result = value == (v = this.booleanExpr.getBooleanValue(element.getParent()));
            return new EvaluatedCondition(this, result);
        }
        if (this.typeExpr != null) {
            // empty if block
        }
        return new EvaluatedCondition(this, false);
    }

    public StringExpression getFeatureStringExpression() {
        return this.featureStringExpression;
    }

    public StringExpression getStringExpr() {
        return this.stringExpr;
    }

    public NumberExpression getNumberExpr() {
        return this.numberExpr;
    }

    public BooleanExpression getBooleanExpr() {
        return this.booleanExpr;
    }

    public TypeExpression getTypeExpr() {
        return this.typeExpr;
    }
}

