/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.Type;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.ruta.RutaModule;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.list.BooleanListExpression;
import org.apache.uima.ruta.expression.list.NumberListExpression;
import org.apache.uima.ruta.expression.list.StringListExpression;
import org.apache.uima.ruta.expression.list.TypeListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureAction
extends AbstractRutaAction {
    private final String namespace;
    private final Map<StringExpression, RutaExpression> parameterMap;

    public ConfigureAction(String ns, Map<StringExpression, RutaExpression> map) {
        this.namespace = ns;
        this.parameterMap = map;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        RutaModule thisScript = element.getParent().getScript();
        AnalysisEngine targetEngine = thisScript.getEngine(this.namespace);
        ConfigurationParameterDeclarations configurationParameterDeclarations = targetEngine.getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
        Set<Map.Entry<StringExpression, RutaExpression>> entrySet = this.parameterMap.entrySet();
        for (Map.Entry<StringExpression, RutaExpression> entry : entrySet) {
            NumberExpression ne;
            ArrayList<Number> numbers;
            NumberListExpression nle;
            List list;
            StringExpression key = entry.getKey();
            String stringValue = key.getStringValue(element.getParent());
            ConfigurationParameter configurationParameter = configurationParameterDeclarations.getConfigurationParameter(null, stringValue);
            if (configurationParameter == null) continue;
            RutaExpression value = entry.getValue();
            String type = configurationParameter.getType();
            if (type.equals("String")) {
                if (configurationParameter.isMultiValued()) {
                    if (value instanceof StringListExpression) {
                        StringListExpression sle = (StringListExpression)value;
                        list = sle.getList(element.getParent());
                        targetEngine.setConfigParameterValue(stringValue, (Object)list.toArray());
                        continue;
                    }
                    if (!(value instanceof TypeListExpression)) continue;
                    TypeListExpression tle = (TypeListExpression)value;
                    list = tle.getList(element.getParent());
                    ArrayList<String> stringList = new ArrayList<String>();
                    for (Type each : list) {
                        stringList.add(each.getName());
                    }
                    targetEngine.setConfigParameterValue(stringValue, (Object)stringList.toArray());
                    continue;
                }
                if (value instanceof StringExpression) {
                    StringExpression se = (StringExpression)value;
                    String string = se.getStringValue(element.getParent());
                    targetEngine.setConfigParameterValue(stringValue, (Object)string);
                    continue;
                }
                if (!(value instanceof TypeExpression)) continue;
                TypeExpression te = (TypeExpression)value;
                Type t = te.getType(element.getParent());
                targetEngine.setConfigParameterValue(stringValue, (Object)t.getName());
                continue;
            }
            if (type.equals("Float")) {
                if (value instanceof NumberListExpression) {
                    nle = (NumberListExpression)value;
                    list = nle.getList(element.getParent());
                    numbers = new ArrayList<Number>();
                    for (Number number : list) {
                        numbers.add(Float.valueOf(number.floatValue()));
                    }
                    targetEngine.setConfigParameterValue(stringValue, (Object)numbers.toArray());
                    continue;
                }
                if (!(value instanceof NumberExpression)) continue;
                ne = (NumberExpression)value;
                Double d = ne.getDoubleValue(element.getParent());
                targetEngine.setConfigParameterValue(stringValue, (Object)Float.valueOf(d.floatValue()));
                continue;
            }
            if (type.equals("Integer")) {
                if (value instanceof NumberListExpression) {
                    nle = (NumberListExpression)value;
                    list = nle.getList(element.getParent());
                    numbers = new ArrayList();
                    for (Number number : list) {
                        numbers.add(number.intValue());
                    }
                    targetEngine.setConfigParameterValue(stringValue, (Object)numbers.toArray());
                    continue;
                }
                if (!(value instanceof NumberExpression)) continue;
                ne = (NumberExpression)value;
                Integer i = ne.getIntegerValue(element.getParent());
                targetEngine.setConfigParameterValue(stringValue, (Object)i);
                continue;
            }
            if (!type.equals("Boolean")) continue;
            if (value instanceof BooleanListExpression) {
                BooleanListExpression ble = (BooleanListExpression)value;
                list = ble.getList(element.getParent());
                targetEngine.setConfigParameterValue(stringValue, (Object)list.toArray());
                continue;
            }
            if (!(value instanceof BooleanExpression)) continue;
            BooleanExpression be = (BooleanExpression)value;
            Boolean b = be.getBooleanValue(element.getParent());
            targetEngine.setConfigParameterValue(stringValue, (Object)b);
        }
        try {
            targetEngine.reconfigure();
        }
        catch (ResourceConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<StringExpression, RutaExpression> getParameterMap() {
        return this.parameterMap;
    }
}

