/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.annotation;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.caseditor.editor.annotation.BoxDrawingStrategy;
import org.apache.uima.caseditor.editor.annotation.EclipseAnnotationPeer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class TagDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    private static final int TAG_FONT_SIZE = 11;
    private static final int MAX_LEFT_TAG_OVERLAP = 1;
    private static final int MAX_RIGHT_TAG_OVERLAP = 1;
    private static final int TAG_OVERLAP = 2;
    private AnnotationPainter.IDrawingStrategy annotationDrawingStyle = new BoxDrawingStrategy();
    private final String featureName;

    TagDrawingStrategy(String featureName) {
        if (featureName == null) {
            throw new IllegalArgumentException("featureName must not be null!");
        }
        this.featureName = featureName;
    }

    public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        String featureValue;
        AnnotationFS annotationFS;
        Feature feature;
        this.annotationDrawingStyle.draw(annotation, gc, textWidget, offset, length, color);
        if (annotation instanceof EclipseAnnotationPeer && (feature = (annotationFS = ((EclipseAnnotationPeer)annotation).getAnnotationFS()).getType().getFeatureByBaseName(this.featureName)) != null && feature.getRange().isPrimitive() && (featureValue = annotationFS.getFeatureValueAsString(feature)) != null && annotationFS.getBegin() == offset) {
            int lineLength;
            int lineIndex = textWidget.getLineAtOffset(offset);
            int firstCharInLineOffset = textWidget.getOffsetAtLine(lineIndex);
            int maxBeginOverhang = firstCharInLineOffset == offset ? 0 : 1;
            int lineCount = textWidget.getLineCount();
            if (lineCount > lineIndex + 1) {
                int offsetNextLine = textWidget.getOffsetAtLine(lineIndex + 1);
                lineLength = offsetNextLine - firstCharInLineOffset - 1;
            } else {
                lineLength = textWidget.getCharCount() - offset;
            }
            int maxEndOverhang = firstCharInLineOffset + lineLength == offset + length ? 0 : 1;
            Rectangle bounds = textWidget.getTextBounds(offset, offset + length);
            if (gc != null) {
                int lastCharIndex = length == 0 ? offset : offset + length - 1;
                Point annotationStringExtent = gc.stringExtent(textWidget.getText(offset, lastCharIndex));
                Font currentFont = gc.getFont();
                Font tagFont = new Font(currentFont.getDevice(), currentFont.getFontData()[0].getName(), 11, currentFont.getFontData()[0].getStyle());
                gc.setFont(tagFont);
                gc.setForeground(color);
                int maxAllowedLength = length + maxBeginOverhang + maxEndOverhang;
                if (featureValue.length() > maxAllowedLength) {
                    if (length > 0) {
                        char scissorChar = '\u2704';
                        featureValue = featureValue.substring(0, maxAllowedLength - 1) + scissorChar;
                    } else {
                        featureValue = "";
                    }
                }
                Point tagStringExtent = gc.stringExtent(featureValue);
                int centerOfAnnotation = annotationStringExtent.x / 2;
                int centerOfTag = tagStringExtent.x / 2;
                int newX = bounds.x + centerOfAnnotation - centerOfTag;
                if (maxBeginOverhang == 0) {
                    newX = bounds.x;
                } else if (maxEndOverhang == 0) {
                    newX = bounds.x + (annotationStringExtent.x - tagStringExtent.x);
                }
                gc.drawString(featureValue, newX, bounds.y + bounds.height - 1, true);
                gc.setFont(currentFont);
                tagFont.dispose();
            } else {
                textWidget.redraw(bounds.x - 22, bounds.y + bounds.height - 1, 11 * (length + 2), bounds.height, true);
            }
        }
    }
}

