/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import org.apache.commons.lang.StringUtils;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.screens.TemplateScreen;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.RunData;

public class BaseJspScreen
extends TemplateScreen {
    private String prefix = this.getPrefix() + "/";
    @TurbineService
    private JspService jspService;
    @TurbineService
    private TemplateService templateService;

    @Override
    public String buildTemplate(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = this.templateService.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((String)templateName)) {
            this.log.error((Object)("Screen " + screenTemplate + " not found!"));
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        this.jspService.handleRequest(pipelineData, this.prefix + templateName, this.getLayout(pipelineData) == null);
        return null;
    }

    @Override
    protected void doBuildTemplate(PipelineData pipelineData) throws Exception {
    }
}

