/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FakeDefaultLiteral;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.RecordPattern;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    public BranchLabel targetLabel;
    public Expression[] constantExpressions;
    public boolean isSwitchRule = false;
    public SwitchStatement swich;
    public int labelExpressionOrdinal;

    public CaseStatement(Expression[] constantExpressions, int sourceStart, int sourceEnd) {
        this.constantExpressions = constantExpressions;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public Expression[] peeledLabelExpressions() {
        Expression[] constants = Expression.NO_EXPRESSIONS;
        Expression[] expressionArray = this.constantExpressions;
        int n = this.constantExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (e instanceof Pattern) {
                Pattern p = (Pattern)e;
                constants = (Expression[])Stream.concat(Arrays.stream(constants), Arrays.stream(p.getAlternatives())).toArray(Expression[]::new);
            } else {
                constants = (Expression[])Stream.concat(Arrays.stream(constants), Stream.of(e)).toArray(Expression[]::new);
            }
            ++n2;
        }
        return constants;
    }

    private boolean essentiallyQualifiedEnumerator(Expression e, TypeBinding selectorType) {
        if (e instanceof NameReference) {
            NameReference reference = (NameReference)e;
            if (reference.binding instanceof FieldBinding) {
                FieldBinding field = (FieldBinding)reference.binding;
                if ((field.modifiers & 0x4000) != 0 && !TypeBinding.equalsEquals(e.resolvedType, selectorType)) {
                    return true;
                }
            }
        }
        return false;
    }

    private void checkDuplicateDefault(BlockScope scope, ASTNode node) {
        if (this.swich.defaultCase != null) {
            scope.problemReporter().duplicateDefaultCase(node);
        } else if (this.swich.unconditionalPatternCase != null) {
            scope.problemReporter().illegalTotalPatternWithDefault(this);
        }
        this.swich.defaultCase = this;
    }

    private Constant resolveConstantLabel(BlockScope scope, TypeBinding caseType, TypeBinding selectorType, Expression expression) {
        boolean boxing;
        if (this.swich.expression.resolvedType != null && this.swich.expression.resolvedType.id == 6) {
            return Constant.NotAConstant;
        }
        if (expression instanceof NullLiteral) {
            if (!caseType.isCompatibleWith(selectorType, scope)) {
                scope.problemReporter().caseConstantIncompatible(TypeBinding.NULL, selectorType, expression);
            }
            return IntConstant.fromValue(-1);
        }
        if (expression instanceof StringLiteral) {
            if (selectorType.id == 11) {
                return expression.constant;
            }
            scope.problemReporter().caseConstantIncompatible(expression.resolvedType, selectorType, expression);
            return Constant.NotAConstant;
        }
        CompilerOptions options = scope.compilerOptions();
        if (caseType.isEnum() && caseType.isCompatibleWith(selectorType)) {
            if ((expression.bits & 0x1FE00000) >> 21 != 0) {
                scope.problemReporter().enumConstantsCannotBeSurroundedByParenthesis(expression);
            }
            if (expression instanceof NameReference) {
                NameReference reference = (NameReference)expression;
                if (reference.binding instanceof FieldBinding) {
                    FieldBinding field = (FieldBinding)reference.binding;
                    if ((field.modifiers & 0x4000) == 0) {
                        scope.problemReporter().enumSwitchCannotTargetField(reference, field);
                    } else if (reference instanceof QualifiedNameReference && options.complianceLevel < 0x410000L) {
                        scope.problemReporter().cannotUseQualifiedEnumConstantInCaseLabel(reference, field);
                    }
                    if (!TypeBinding.equalsEquals(caseType, selectorType)) {
                        this.swich.switchBits |= 8;
                        return StringConstant.fromValue(CharOperation.toString(reference.getName()));
                    }
                    return IntConstant.fromValue(field.original().id + 1);
                }
            }
            scope.problemReporter().caseExpressionMustBeConstant(expression);
            return Constant.NotAConstant;
        }
        if (this.swich.isNonTraditional && selectorType.isBaseType() && !expression.isConstantValueOfTypeAssignableToType(caseType, selectorType)) {
            scope.problemReporter().caseConstantIncompatible(caseType, selectorType, expression);
            return Constant.NotAConstant;
        }
        if (expression.isConstantValueOfTypeAssignableToType(caseType, selectorType) || caseType.isCompatibleWith(selectorType)) {
            if (expression.constant == Constant.NotAConstant) {
                scope.problemReporter().caseExpressionMustBeConstant(expression);
            }
            return expression.constant;
        }
        boolean bl = boxing = !JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(options) || this.swich.integralType(selectorType);
        if (boxing && this.isBoxingCompatible(caseType, selectorType, expression, scope)) {
            if (expression.constant == Constant.NotAConstant) {
                scope.problemReporter().caseExpressionMustBeConstant(expression);
            }
            return expression.constant;
        }
        scope.problemReporter().caseConstantIncompatible(expression.resolvedType, selectorType, expression);
        return Constant.NotAConstant;
    }

    private Constant resolvePatternLabel(BlockScope scope, TypeBinding caseType, TypeBinding selectorType, Pattern pattern, boolean isUnguarded) {
        Constant constant = IntConstant.fromValue(this.swich.labelExpressionIndex);
        if (pattern instanceof RecordPattern) {
            this.swich.containsRecordPatterns = true;
        }
        if (isUnguarded) {
            this.swich.caseLabelElementTypes.add(caseType);
            this.swich.caseLabelElements.add(pattern);
        }
        if (!caseType.isReifiable()) {
            if (!pattern.isApplicable(selectorType, scope, pattern)) {
                return Constant.NotAConstant;
            }
        } else if (caseType.isValidBinding()) {
            if (Pattern.findPrimitiveConversionRoute(caseType, selectorType, scope) == Pattern.PrimitiveConversionRoute.NO_CONVERSION_ROUTE) {
                if (caseType.isPrimitiveType() && !JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(scope.compilerOptions())) {
                    scope.problemReporter().unexpectedTypeinSwitchPattern(caseType, pattern);
                    return Constant.NotAConstant;
                }
                if (!pattern.checkCastTypesCompatibility(scope, caseType, selectorType, null, false)) {
                    scope.problemReporter().typeMismatchError(selectorType, caseType, pattern, null);
                    return Constant.NotAConstant;
                }
            } else {
                this.swich.isPrimitiveSwitch = true;
            }
        }
        if (pattern.coversType(selectorType, scope)) {
            this.swich.switchBits |= 4;
            pattern.isTotalTypeNode = true;
            if (pattern.isUnconditional(selectorType, scope)) {
                this.swich.unconditionalPatternCase = this;
            }
        }
        return constant;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void resolve(BlockScope scope) {
        if (this.swich == null) {
            return;
        }
        selectorType = (this.swich.switchBits & 2) != 0 ? null : this.swich.expression.resolvedType;
        this.labelExpressionOrdinal = this.swich.labelExpressionIndex;
        this.swich.cases[this.swich.caseCount++] = this;
        this.swich.switchBits = this.swich.switchBits | (this.isSwitchRule != false ? 1 : 16);
        if ((this.swich.switchBits & 17) == 17) {
            scope.problemReporter().arrowColonMixup(this);
        }
        scope.enclosingCase = this;
        if (this.constantExpressions == Expression.NO_EXPRESSIONS) {
            this.checkDuplicateDefault(scope, this);
            return;
        }
        this.swich.switchBits |= 64;
        count = 0;
        nullCaseCount = 0;
        var8_5 = this.constantExpressions;
        var7_6 = this.constantExpressions.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            block18: {
                block19: {
                    block17: {
                        e = var8_5[var6_7];
                        ++count;
                        if (!(e instanceof FakeDefaultLiteral)) break block17;
                        this.swich.isNonTraditional = true;
                        this.swich.containsPatterns = true;
                        this.checkDuplicateDefault(scope, this.constantExpressions.length > 1 ? e : this);
                        if (count != 2 || nullCaseCount < 1) {
                            scope.problemReporter().patternSwitchCaseDefaultOnlyAsSecond(e);
                        }
                        break block18;
                    }
                    if (e instanceof NullLiteral) {
                        this.swich.isNonTraditional = true;
                        this.swich.containsNull = true;
                        if (this.swich.nullCase == null) {
                            this.swich.nullCase = this;
                        }
                        ++nullCaseCount;
                    }
                    if (selectorType != null && selectorType.isEnum() && e instanceof SingleNameReference) {
                        ((SingleNameReference)e).setActualReceiverType((ReferenceBinding)selectorType);
                    }
                    e.setExpressionContext(ExpressionContext.TESTING_CONTEXT);
                    if (e instanceof Pattern) {
                        p = (Pattern)e;
                        this.swich.isNonTraditional = true;
                        this.swich.containsPatterns = true;
                        p.setOuterExpressionType(selectorType);
                    } else if (count > 1 && nullCaseCount == 1) {
                        scope.problemReporter().patternSwitchNullOnlyOrFirstWithDefault(e);
                    }
                    caseType = e.resolveType(scope);
                    if (caseType == null || selectorType == null || !caseType.isValidBinding()) break block18;
                    if (!(e instanceof Pattern)) break block19;
                    var14_14 = ((Pattern)e).getAlternatives();
                    var13_13 = var14_14.length;
                    var12_12 = 0;
                    while (var12_12 < var13_13) {
                        p = var14_14[var12_12];
                        constant = this.resolvePatternLabel(scope, p.resolvedType, selectorType, p, ((Pattern)e).isUnguarded());
                        if (constant != Constant.NotAConstant) {
                            this.swich.gatherLabelExpression(new LabelExpression(constant, p, p.resolvedType, this.swich.labelExpressionIndex, false));
                        }
                        ++var12_12;
                    }
                    break block18;
                }
                if (caseType.id == 12) ** GOTO lbl-1000
                expectedCaseType = selectorType.isBoxedPrimitiveType() != false && JavaFeature.PRIMITIVES_IN_PATTERNS.isSupported(scope.compilerOptions()) != false ? selectorType.unboxedType() : selectorType;
                switch (expectedCaseType.id) {
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: {
                        if (caseType.id != expectedCaseType.id) {
                            scope.problemReporter().caseExpressionWrongType(e, selectorType, expectedCaseType);
                            break;
                        }
                        selectorType = expectedCaseType;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if ((constant = this.resolveConstantLabel(scope, caseType, selectorType, e)) == Constant.NotAConstant) break;
                        index = e instanceof NullLiteral != false ? -1 : this.swich.labelExpressionIndex;
                        isQualifiedEnum = this.essentiallyQualifiedEnumerator(e, selectorType);
                        this.swich.gatherLabelExpression(new LabelExpression(constant, e, caseType, index, isQualifiedEnum));
                    }
                }
            }
            ++var6_7;
        }
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        int n;
        int n2;
        Object[] objectArray;
        if (!JavaFeature.UNNAMMED_PATTERNS_AND_VARS.isSupported(currentScope.compilerOptions())) {
            objectArray = this.bindingsWhenTrue();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object local = objectArray[n];
                ((LocalVariableBinding)local).useFlag = 1;
                ++n;
            }
        }
        objectArray = this.constantExpressions;
        n2 = this.constantExpressions.length;
        n = 0;
        while (n < n2) {
            Object e = objectArray[n];
            if (e instanceof NullLiteral && flowContext.associatedNode instanceof SwitchStatement) {
                SwitchStatement swichStatement = (SwitchStatement)flowContext.associatedNode;
                Expression switchValue = swichStatement.expression;
                if (switchValue != null && switchValue.nullStatus(flowInfo, flowContext) == 4) {
                    currentScope.problemReporter().unnecessaryNullCaseInSwitchOverNonNull(this);
                }
            }
            flowInfo = ((Expression)e).analyseCode(currentScope, flowContext, flowInfo);
            ++n;
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.targetLabel.place();
        if (this.containsPatternVariable(true)) {
            BranchLabel patternMatchLabel = new BranchLabel(codeStream);
            BranchLabel matchFailLabel = new BranchLabel(codeStream);
            Pattern pattern = (Pattern)this.constantExpressions[0];
            codeStream.load(this.swich.selector);
            pattern.generateCode(currentScope, codeStream, patternMatchLabel, matchFailLabel);
            codeStream.goto_(patternMatchLabel);
            if (matchFailLabel.forwardReferenceCount() > 0) {
                matchFailLabel.place();
                LocalVariableBinding[] bindingsWhenTrue = pattern.bindingsWhenTrue();
                Stream.of(bindingsWhenTrue).forEach(v -> v.recordInitializationEndPC(codeStream.position));
                codeStream.load(this.swich.selector);
                int caseIndex = this.labelExpressionOrdinal + pattern.getAlternatives().length;
                codeStream.loadInt(this.swich.nullProcessed ? caseIndex - 1 : caseIndex);
                codeStream.goto_(this.swich.switchPatternRestartTarget);
                Stream.of(bindingsWhenTrue).forEach(v -> v.recordInitializationStartPC(codeStream.position));
            }
            patternMatchLabel.place();
        } else if (this.swich.nullCase == this) {
            this.swich.nullProcessed = true;
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        LocalVariableBinding[] variables = NO_VARIABLES;
        Expression[] expressionArray = this.constantExpressions;
        int n = this.constantExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            variables = LocalVariableBinding.merge(variables, e.bindingsWhenTrue());
            ++n2;
        }
        return variables;
    }

    @Override
    public StringBuilder printStatement(int tab, StringBuilder output) {
        CaseStatement.printIndent(tab, output);
        if (this.constantExpressions == Expression.NO_EXPRESSIONS) {
            output.append("default");
        } else {
            output.append("case ");
            int i = 0;
            int length = this.constantExpressions.length;
            while (i < length) {
                this.constantExpressions[i].printExpression(0, output);
                if (i < length - 1) {
                    output.append(',');
                }
                ++i;
            }
        }
        return output.append(this.isSwitchRule ? " ->" : " :");
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            Expression[] expressionArray = this.constantExpressions;
            int n = this.constantExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                e.traverse(visitor, blockScope);
                ++n2;
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public Boolean getBooleanConstantValue() {
        if (this.constantExpressions != null) {
            Expression[] expressionArray = this.constantExpressions;
            int n = this.constantExpressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                if (expression.constant instanceof BooleanConstant) {
                    BooleanConstant bc = (BooleanConstant)expression.constant;
                    return bc.booleanValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public static class LabelExpression {
        public Constant constant;
        public Expression expression;
        public TypeBinding type;
        public int index;
        private int intValue;
        private final boolean isPattern;
        private final boolean isQualifiedEnum;
        public int enumDescIdx;
        public int classDescIdx;
        public int primitivesBootstrapIdx;

        LabelExpression(Constant c, Expression e, TypeBinding t, int index, boolean isQualifiedEnum) {
            this.constant = c;
            this.expression = e;
            this.type = t;
            this.index = index;
            this.intValue = c.typeID() == 11 ? c.stringValue().hashCode() : c.intValue();
            this.isPattern = e instanceof Pattern;
            this.isQualifiedEnum = isQualifiedEnum;
        }

        public int intValue() {
            return this.intValue;
        }

        public boolean isPattern() {
            return this.isPattern;
        }

        public boolean isQualifiedEnum() {
            return this.isQualifiedEnum;
        }

        public String toString() {
            return "case " + String.valueOf(this.expression) + " [CONSTANT=" + String.valueOf(this.constant) + "]";
        }
    }
}

