/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.TokenTag;

public class ParserChunkerSequenceValidator
implements SequenceValidator<TokenTag> {
    private final Map<String, String> continueStartMap;

    public ParserChunkerSequenceValidator(String[] outcomes) {
        this.continueStartMap = new HashMap<String, String>(outcomes.length);
        for (String outcome : outcomes) {
            if (!outcome.startsWith("C-")) continue;
            this.continueStartMap.put(outcome, "S-" + outcome.substring("C-".length()));
        }
    }

    public boolean validSequence(int i, String[] inputSequence, String[] tagList, String outcome) {
        if (this.continueStartMap.containsKey(outcome)) {
            int lti = tagList.length - 1;
            if (lti == -1) {
                return false;
            }
            String lastTag = tagList[lti];
            if (lastTag.equals(outcome)) {
                return true;
            }
            if (lastTag.equals(this.continueStartMap.get(outcome))) {
                return true;
            }
            if (lastTag.equals("O")) {
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean validSequence(int i, TokenTag[] inputTuples, String[] outcomesSequence, String outcome) {
        String[] inputSequence = TokenTag.extractTokens(inputTuples);
        return this.validSequence(i, inputSequence, outcomesSequence, outcome);
    }
}

