/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.handlers;

import java.awt.datatransfer.DataFlavor;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.handlers.HandlerUtil;
import org.bouncycastle.util.Strings;

public class multipart_signed
implements DataContentHandler {
    private static final ActivationDataFlavor ADF = new ActivationDataFlavor(MimeMultipart.class, "multipart/signed", "Multipart Signed");
    private static final DataFlavor[] DFS = new DataFlavor[]{ADF};

    @Override
    public Object getContent(DataSource dataSource) throws IOException {
        try {
            return new MimeMultipart(dataSource);
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        return HandlerUtil.getTransferData(this, ADF, dataFlavor, dataSource);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DFS;
    }

    @Override
    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (object instanceof MimeMultipart) {
            try {
                this.outputBodyPart(outputStream, object);
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.getMessage());
            }
        } else {
            HandlerUtil.writeFromBarrInputStreamSMIMESTreamProcessor(object, outputStream);
        }
    }

    private void outputBodyPart(OutputStream outputStream, Object object) throws MessagingException, IOException {
        Object object2;
        if (object instanceof Multipart) {
            Multipart multipart = (Multipart)object;
            ContentType contentType = new ContentType(multipart.getContentType());
            String string = "--" + contentType.getParameter("boundary");
            LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
            for (int i = 0; i < multipart.getCount(); ++i) {
                lineOutputStream.writeln(string);
                this.outputBodyPart(outputStream, multipart.getBodyPart(i));
                lineOutputStream.writeln();
            }
            lineOutputStream.writeln(string + "--");
            return;
        }
        MimeBodyPart mimeBodyPart = (MimeBodyPart)object;
        if (SMIMEUtil.isMultipartContent((Part)mimeBodyPart) && (object2 = mimeBodyPart.getContent()) instanceof Multipart) {
            Multipart multipart = (Multipart)object2;
            ContentType contentType = new ContentType(multipart.getContentType());
            String string = "--" + contentType.getParameter("boundary");
            LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
            Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                lineOutputStream.writeln((String)enumeration.nextElement());
            }
            lineOutputStream.writeln();
            multipart_signed.outputPreamble(lineOutputStream, mimeBodyPart, string);
            this.outputBodyPart(outputStream, multipart);
            return;
        }
        mimeBodyPart.writeTo(outputStream);
    }

    static void outputPreamble(LineOutputStream lineOutputStream, MimeBodyPart mimeBodyPart, String string) throws MessagingException, IOException {
        String string2;
        InputStream inputStream;
        try {
            inputStream = mimeBodyPart.getRawInputStream();
        }
        catch (MessagingException messagingException) {
            return;
        }
        while ((string2 = multipart_signed.readLine(inputStream)) != null && !string2.equals(string)) {
            lineOutputStream.writeln(string2);
        }
        inputStream.close();
        if (string2 == null) {
            throw new MessagingException("no boundary found");
        }
    }

    private static String readLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStream.read()) >= 0 && n != 10) {
            if (n == 13) continue;
            stringBuffer.append((char)n);
        }
        if (n < 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void writeln(String string) throws MessagingException {
            try {
                byte[] byArray = Strings.toUTF8ByteArray(string);
                this.out.write(byArray);
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }
}

