/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.internal.event.InvalidationEventHubImpl;
import org.apache.tapestry5.internal.services.ClassNameHolder;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.ioc.services.UpdateListener;
import org.apache.tapestry5.ioc.services.UpdateListenerHub;
import org.slf4j.Logger;

public class ResourceChangeTrackerImpl
extends InvalidationEventHubImpl
implements ResourceChangeTracker,
UpdateListener {
    private final URLChangeTracker<ResourceInfo> tracker;
    private final ThreadLocal<String> currentClassName;
    private final Logger logger;
    private final boolean multipleClassLoaders;
    private final long fixedLastModifiedTime = Math.round((double)System.currentTimeMillis() / 1000.0) * 1000L;

    public ResourceChangeTrackerImpl(ClasspathURLConverter classpathURLConverter, @Symbol(value="tapestry.production-mode") boolean productionMode, @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassLoaders, Logger logger) {
        super(productionMode, logger);
        this.logger = logger;
        this.multipleClassLoaders = multipleClassLoaders;
        this.tracker = productionMode ? null : new URLChangeTracker(classpathURLConverter, true, false);
        this.currentClassName = productionMode ? null : new ThreadLocal();
    }

    @PostInjection
    public void registerWithUpdateListenerHub(UpdateListenerHub hub) {
        hub.addUpdateListener((UpdateListener)this);
    }

    @Override
    public long trackResource(Resource resource) {
        if (this.tracker == null) {
            return this.fixedLastModifiedTime;
        }
        return this.tracker.add(resource.toURL(), (Object)new ResourceInfo(resource.toString(), this.currentClassName.get()));
    }

    @Override
    public void addDependency(Resource dependency) {
        this.trackResource(dependency);
    }

    @Override
    public void forceInvalidationEvent() {
        this.fireInvalidationEvent();
        if (this.tracker != null) {
            this.tracker.clear();
        }
    }

    public void checkForUpdates() {
        if (this.tracker != null) {
            Set changedResources = this.tracker.getChangedResourcesInfo();
            if (!changedResources.isEmpty()) {
                this.logger.info("Changed resources: {}", (Object)changedResources.stream().map(ResourceInfo::getResource).collect(Collectors.joining(", ")));
            }
            boolean applicationLevelChange = false;
            for (ResourceInfo info : changedResources) {
                if (info.getClassName() != null && this.multipleClassLoaders) continue;
                this.forceInvalidationEvent();
                applicationLevelChange = true;
                break;
            }
            if (!changedResources.isEmpty() && !applicationLevelChange) {
                ArrayList<String> resources = new ArrayList<String>(4);
                resources.addAll(changedResources.stream().filter(Objects::nonNull).map(ResourceInfo::getResource).filter(Objects::nonNull).collect(Collectors.toList()));
                resources.addAll(changedResources.stream().filter(Objects::nonNull).map(ClassNameHolder::getClassName).filter(Objects::nonNull).collect(Collectors.toList()));
                this.fireInvalidationEvent(resources);
            }
        }
    }

    @Override
    public void setCurrentClassName(String className) {
        if (this.currentClassName != null) {
            this.currentClassName.set(className);
        }
    }

    @Override
    public void clearCurrentClassName() {
        if (this.currentClassName != null) {
            this.currentClassName.set(null);
        }
    }

    private static class ResourceInfo
    implements ClassNameHolder {
        private String resource;
        private String className;

        public ResourceInfo(String resource, String className) {
            this.className = className;
            this.resource = resource;
        }

        public int hashCode() {
            return Objects.hash(this.className, this.resource);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceInfo other = (ResourceInfo)obj;
            return Objects.equals(this.className, other.className) && Objects.equals(this.resource, other.resource);
        }

        public String toString() {
            return "ResourceInfo [path=" + this.resource + ", className=" + this.className + "]";
        }

        public String getResource() {
            return this.resource;
        }

        @Override
        public String getClassName() {
            return this.className;
        }
    }
}

