/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.http.modules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.OrderedConfiguration;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.services.CoercionTuple;
import org.apache.tapestry5.commons.util.VersionUtils;
import org.apache.tapestry5.http.OptimizedSessionPersistedObject;
import org.apache.tapestry5.http.internal.AsyncRequestService;
import org.apache.tapestry5.http.internal.TypeCoercerHttpRequestBodyConverter;
import org.apache.tapestry5.http.internal.gzip.GZipFilter;
import org.apache.tapestry5.http.internal.services.ApplicationGlobalsImpl;
import org.apache.tapestry5.http.internal.services.AsyncRequestServiceImpl;
import org.apache.tapestry5.http.internal.services.BaseURLSourceImpl;
import org.apache.tapestry5.http.internal.services.ContextImpl;
import org.apache.tapestry5.http.internal.services.CorsHandlerHelperImpl;
import org.apache.tapestry5.http.internal.services.DefaultCorsHandler;
import org.apache.tapestry5.http.internal.services.DefaultSessionPersistedObjectAnalyzer;
import org.apache.tapestry5.http.internal.services.OptimizedSessionPersistedObjectAnalyzer;
import org.apache.tapestry5.http.internal.services.RequestGlobalsImpl;
import org.apache.tapestry5.http.internal.services.RequestImpl;
import org.apache.tapestry5.http.internal.services.ResponseCompressionAnalyzerImpl;
import org.apache.tapestry5.http.internal.services.ResponseImpl;
import org.apache.tapestry5.http.internal.services.RestSupportImpl;
import org.apache.tapestry5.http.internal.services.TapestrySessionFactory;
import org.apache.tapestry5.http.internal.services.TapestrySessionFactoryImpl;
import org.apache.tapestry5.http.services.ApplicationGlobals;
import org.apache.tapestry5.http.services.ApplicationInitializer;
import org.apache.tapestry5.http.services.ApplicationInitializerFilter;
import org.apache.tapestry5.http.services.BaseURLSource;
import org.apache.tapestry5.http.services.Context;
import org.apache.tapestry5.http.services.CorsHandler;
import org.apache.tapestry5.http.services.CorsHandlerHelper;
import org.apache.tapestry5.http.services.CorsHttpServletRequestFilter;
import org.apache.tapestry5.http.services.Dispatcher;
import org.apache.tapestry5.http.services.HttpRequestBodyConverter;
import org.apache.tapestry5.http.services.HttpServletRequestFilter;
import org.apache.tapestry5.http.services.HttpServletRequestHandler;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.RequestFilter;
import org.apache.tapestry5.http.services.RequestGlobals;
import org.apache.tapestry5.http.services.RequestHandler;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.http.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.http.services.RestSupport;
import org.apache.tapestry5.http.services.ServletApplicationInitializer;
import org.apache.tapestry5.http.services.ServletApplicationInitializerFilter;
import org.apache.tapestry5.http.services.SessionPersistedObjectAnalyzer;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Autobuild;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.ChainBuilder;
import org.apache.tapestry5.ioc.services.PipelineBuilder;
import org.apache.tapestry5.ioc.services.PropertyShadowBuilder;
import org.apache.tapestry5.ioc.services.StrategyBuilder;
import org.slf4j.Logger;

public final class TapestryHttpModule {
    private final PropertyShadowBuilder shadowBuilder;
    private final RequestGlobals requestGlobals;
    private final PipelineBuilder pipelineBuilder;
    private final ApplicationGlobals applicationGlobals;

    public TapestryHttpModule(PropertyShadowBuilder shadowBuilder, RequestGlobals requestGlobals, PipelineBuilder pipelineBuilder, ApplicationGlobals applicationGlobals) {
        this.shadowBuilder = shadowBuilder;
        this.requestGlobals = requestGlobals;
        this.pipelineBuilder = pipelineBuilder;
        this.applicationGlobals = applicationGlobals;
    }

    public static void bind(ServiceBinder binder) {
        binder.bind(RequestGlobals.class, RequestGlobalsImpl.class);
        binder.bind(ApplicationGlobals.class, ApplicationGlobalsImpl.class);
        binder.bind(TapestrySessionFactory.class, TapestrySessionFactoryImpl.class);
        binder.bind(BaseURLSource.class, BaseURLSourceImpl.class);
        binder.bind(ResponseCompressionAnalyzer.class, ResponseCompressionAnalyzerImpl.class);
        binder.bind(RestSupport.class, RestSupportImpl.class);
        binder.bind(AsyncRequestService.class, AsyncRequestServiceImpl.class);
        binder.bind(CorsHandlerHelper.class, CorsHandlerHelperImpl.class);
        binder.bind(CorsHttpServletRequestFilter.class);
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, Object> configuration) {
        configuration.add((Object)"tapestry.session-locking-enabled", (Object)true);
        configuration.add((Object)"tapestry.clustered-sessions", (Object)true);
        configuration.add((Object)"tapestry.charset", (Object)"UTF-8");
        configuration.add((Object)"tapestry.application-version", (Object)"0.0.1");
        configuration.add((Object)"tapestry.gzip-compression-enabled", (Object)true);
        configuration.add((Object)"tapestry.min-gzip-size", (Object)100);
        configuration.add((Object)"tapestry.version", (Object)VersionUtils.readVersionNumber((String)"META-INF/gradle/org.apache.tapestry/tapestry-http/project.properties"));
        configuration.add((Object)"tapestry.cors-enabled", (Object)"false");
        configuration.add((Object)"tapestry.cors-allowed-origins", (Object)"");
        configuration.add((Object)"tapestry.cors-allow-credentials", (Object)"false");
        configuration.add((Object)"tapestry.cors-allow-methods", (Object)"GET,HEAD,PUT,PATCH,POST,DELETE");
        configuration.add((Object)"tapestry.cors-allowed-headers", (Object)"");
        configuration.add((Object)"tapestry.cors-expose-headers", (Object)"");
        configuration.add((Object)"tapestry.hostname", (Object)"");
        configuration.add((Object)"tapestry.hostport", (Object)0);
        configuration.add((Object)"tapestry.hostport-secure", (Object)0);
    }

    public Request buildRequest(PropertyShadowBuilder shadowBuilder) {
        return (Request)shadowBuilder.build((Object)this.requestGlobals, "request", Request.class);
    }

    public HttpServletRequest buildHttpServletRequest() {
        return (HttpServletRequest)this.shadowBuilder.build((Object)this.requestGlobals, "HTTPServletRequest", HttpServletRequest.class);
    }

    public HttpServletResponse buildHttpServletResponse() {
        return (HttpServletResponse)this.shadowBuilder.build((Object)this.requestGlobals, "HTTPServletResponse", HttpServletResponse.class);
    }

    public Response buildResponse() {
        return (Response)this.shadowBuilder.build((Object)this.requestGlobals, "response", Response.class);
    }

    @Marker(value={Primary.class})
    public Dispatcher buildMasterDispatcher(List<Dispatcher> configuration, ChainBuilder chainBuilder) {
        return (Dispatcher)chainBuilder.build(Dispatcher.class, configuration);
    }

    @Marker(value={Primary.class})
    public SessionPersistedObjectAnalyzer buildSessionPersistedObjectAnalyzer(Map<Class, SessionPersistedObjectAnalyzer> configuration, StrategyBuilder strategyBuilder) {
        return (SessionPersistedObjectAnalyzer)strategyBuilder.build(SessionPersistedObjectAnalyzer.class, configuration);
    }

    public static void contributeSessionPersistedObjectAnalyzer(MappedConfiguration<Class, SessionPersistedObjectAnalyzer> configuration) {
        configuration.add(Object.class, (Object)new DefaultSessionPersistedObjectAnalyzer());
        SessionPersistedObjectAnalyzer<Object> immutable = new SessionPersistedObjectAnalyzer<Object>(){

            @Override
            public boolean checkAndResetDirtyState(Object sessionPersistedObject) {
                return false;
            }
        };
        configuration.add(String.class, (Object)immutable);
        configuration.add(Number.class, (Object)immutable);
        configuration.add(Boolean.class, (Object)immutable);
        configuration.add(OptimizedSessionPersistedObject.class, (Object)new OptimizedSessionPersistedObjectAnalyzer());
    }

    @Marker(value={Primary.class})
    public ApplicationInitializer buildApplicationInitializer(Logger logger, List<ApplicationInitializerFilter> configuration) {
        ApplicationInitializerTerminator terminator = new ApplicationInitializerTerminator();
        return (ApplicationInitializer)this.pipelineBuilder.build(logger, ApplicationInitializer.class, ApplicationInitializerFilter.class, configuration, (Object)terminator);
    }

    public HttpServletRequestHandler buildHttpServletRequestHandler(Logger logger, List<HttpServletRequestFilter> configuration, @Primary RequestHandler handler, @Symbol(value="tapestry.charset") String applicationCharset, TapestrySessionFactory sessionFactory) {
        HttpServletRequestHandlerTerminator terminator = new HttpServletRequestHandlerTerminator(handler, applicationCharset, sessionFactory);
        return (HttpServletRequestHandler)this.pipelineBuilder.build(logger, HttpServletRequestHandler.class, HttpServletRequestFilter.class, configuration, (Object)terminator);
    }

    @Marker(value={Primary.class})
    public RequestHandler buildRequestHandler(Logger logger, List<RequestFilter> configuration, @Primary Dispatcher masterDispatcher) {
        RequestHandlerTerminator terminator = new RequestHandlerTerminator(masterDispatcher);
        return (RequestHandler)this.pipelineBuilder.build(logger, RequestHandler.class, RequestFilter.class, configuration, (Object)terminator);
    }

    public ServletApplicationInitializer buildServletApplicationInitializer(Logger logger, List<ServletApplicationInitializerFilter> configuration, @Primary ApplicationInitializer initializer) {
        ServletApplicationInitializerTerminator terminator = new ServletApplicationInitializerTerminator(initializer);
        return (ServletApplicationInitializer)this.pipelineBuilder.build(logger, ServletApplicationInitializer.class, ServletApplicationInitializerFilter.class, configuration, (Object)terminator);
    }

    public void contributeHttpServletRequestHandler(OrderedConfiguration<HttpServletRequestFilter> configuration, @Symbol(value="tapestry.gzip-compression-enabled") boolean gzipCompressionEnabled, @Symbol(value="tapestry.cors-enabled") boolean corsEnabled, CorsHttpServletRequestFilter corsHttpServletRequestFilter, @Autobuild GZipFilter gzipFilter) {
        HttpServletRequestFilter storeIntoGlobals = new HttpServletRequestFilter(){

            @Override
            public boolean service(HttpServletRequest request, HttpServletResponse response, HttpServletRequestHandler handler) throws IOException {
                TapestryHttpModule.this.requestGlobals.storeServletRequestResponse(request, response);
                return handler.service(request, response);
            }
        };
        if (corsEnabled) {
            configuration.add("CORS", (Object)corsHttpServletRequestFilter, new String[]{"after:StoreIntoGlobals", "before:GZIP"});
        }
        configuration.add("StoreIntoGlobals", (Object)storeIntoGlobals, new String[]{"before:*"});
        configuration.add("GZIP", (Object)(gzipCompressionEnabled ? gzipFilter : null), new String[0]);
    }

    public static HttpRequestBodyConverter buildHttpRequestBodyConverter(List<HttpRequestBodyConverter> converters, ChainBuilder chainBuilder) {
        return (HttpRequestBodyConverter)chainBuilder.build(HttpRequestBodyConverter.class, converters);
    }

    public static void contributeHttpRequestBodyConverter(OrderedConfiguration<HttpRequestBodyConverter> configuration) {
        configuration.addInstance("TypeCoercer", TypeCoercerHttpRequestBodyConverter.class, new String[]{"after:*"});
    }

    public static void contributeTypeCoercer(MappedConfiguration<CoercionTuple.Key, CoercionTuple> configuration) {
        CoercionTuple.add(configuration, HttpServletRequest.class, String.class, TapestryHttpModule::toString);
        CoercionTuple.add(configuration, HttpServletRequest.class, byte[].class, TapestryHttpModule::toByteArray);
        CoercionTuple.add(configuration, HttpServletRequest.class, InputStream.class, TapestryHttpModule::toInputStream);
        CoercionTuple.add(configuration, HttpServletRequest.class, Reader.class, TapestryHttpModule::toBufferedReader);
        CoercionTuple.add(configuration, HttpServletRequest.class, BufferedReader.class, TapestryHttpModule::toBufferedReader);
    }

    public static void contributeCorsHttpServletRequestFilter(OrderedConfiguration<CorsHandler> configuration) {
        configuration.addInstance("Default", DefaultCorsHandler.class, new String[]{"after:*"});
    }

    private static final InputStream toInputStream(HttpServletRequest request) {
        try {
            return request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final BufferedReader toBufferedReader(HttpServletRequest request) {
        try {
            return request.getReader();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final String toString(HttpServletRequest request) {
        String string;
        block8: {
            BufferedReader reader = request.getReader();
            try {
                String string2 = IOUtils.toString((Reader)reader);
                String string3 = string = string2.isEmpty() ? null : string2;
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TapestryException("Exception converting body from HttpServletRequest (getReader()) to String", (Throwable)e);
                }
            }
            ((Reader)reader).close();
        }
        return string;
    }

    private static final byte[] toByteArray(HttpServletRequest request) {
        byte[] byArray;
        block8: {
            ServletInputStream inputStream = request.getInputStream();
            try {
                byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                byte[] byArray2 = byArray = byteArray.length == 0 ? null : byteArray;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TapestryException("Exception converting from HttpServletRequest (getInputStream()) to String", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private class ServletApplicationInitializerTerminator
    implements ServletApplicationInitializer {
        private final ApplicationInitializer initializer;

        public ServletApplicationInitializerTerminator(ApplicationInitializer initializer) {
            this.initializer = initializer;
        }

        @Override
        public void initializeApplication(ServletContext servletContext) {
            TapestryHttpModule.this.applicationGlobals.storeServletContext(servletContext);
            ContextImpl context = new ContextImpl(servletContext);
            TapestryHttpModule.this.applicationGlobals.storeContext(context);
            this.initializer.initializeApplication(context);
        }
    }

    private class RequestHandlerTerminator
    implements RequestHandler {
        private final Dispatcher masterDispatcher;

        public RequestHandlerTerminator(Dispatcher masterDispatcher) {
            this.masterDispatcher = masterDispatcher;
        }

        @Override
        public boolean service(Request request, Response response) throws IOException {
            TapestryHttpModule.this.requestGlobals.storeRequestResponse(request, response);
            return this.masterDispatcher.dispatch(request, response);
        }
    }

    private class HttpServletRequestHandlerTerminator
    implements HttpServletRequestHandler {
        private final RequestHandler handler;
        private final String applicationCharset;
        private final TapestrySessionFactory sessionFactory;

        public HttpServletRequestHandlerTerminator(RequestHandler handler, String applicationCharset, TapestrySessionFactory sessionFactory) {
            this.handler = handler;
            this.applicationCharset = applicationCharset;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public boolean service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
            TapestryHttpModule.this.requestGlobals.storeServletRequestResponse(servletRequest, servletResponse);
            servletRequest.setAttribute("servletAPI.protocol", (Object)servletRequest.getProtocol());
            servletRequest.setAttribute("servletAPI.characterEncoding", (Object)servletRequest.getCharacterEncoding());
            servletRequest.setAttribute("servletAPI.contentLength", (Object)servletRequest.getContentLength());
            servletRequest.setAttribute("servletAPI.authType", (Object)servletRequest.getAuthType());
            servletRequest.setAttribute("servletAPI.contentType", (Object)servletRequest.getContentType());
            servletRequest.setAttribute("servletAPI.scheme", (Object)servletRequest.getScheme());
            RequestImpl request = new RequestImpl(servletRequest, this.applicationCharset, this.sessionFactory);
            ResponseImpl response = new ResponseImpl(servletRequest, servletResponse);
            TapestryHttpModule.this.requestGlobals.storeRequestResponse(request, response);
            return this.handler.service(request, response);
        }
    }

    private class ApplicationInitializerTerminator
    implements ApplicationInitializer {
        private ApplicationInitializerTerminator() {
        }

        @Override
        public void initializeApplication(Context context) {
            TapestryHttpModule.this.applicationGlobals.storeContext(context);
        }
    }
}

