/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.func;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.func.AbstractFlow;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Reducer;
import org.apache.tapestry5.func.Worker;

class ArrayFlow<T>
extends AbstractFlow<T> {
    private final T[] values;
    private final int start;
    private final int count;
    private Flow<T> rest;

    ArrayFlow(Flow<T> flow) {
        this(ArrayFlow.toMutableList(flow));
    }

    ArrayFlow(Collection<T> values) {
        this(values.toArray());
    }

    ArrayFlow(T[] values) {
        this(values, 0, values.length);
    }

    ArrayFlow(T[] values, int start, int count) {
        this.values = values;
        this.start = start;
        this.count = count;
    }

    @Override
    public Flow<T> each(Worker<? super T> worker) {
        for (int i = 0; i < this.count; ++i) {
            worker.work(this.values[this.start + i]);
        }
        return this;
    }

    @Override
    public <A> A reduce(Reducer<A, T> reducer, A initial) {
        assert (reducer != null);
        A accumulator = initial;
        for (int i = 0; i < this.count; ++i) {
            T value = this.values[this.start + i];
            accumulator = reducer.reduce(accumulator, value);
        }
        return accumulator;
    }

    @Override
    public List<T> toList() {
        return Arrays.asList(this.values).subList(this.start, this.start + this.count);
    }

    @Override
    public Flow<T> reverse() {
        if (this.values.length < 2) {
            return this;
        }
        ArrayList<T> newValues = new ArrayList<T>();
        newValues.addAll(Arrays.asList(this.values));
        Collections.reverse(newValues);
        return new ArrayFlow(newValues);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    protected List<T> toMutableList() {
        ArrayList<T> result = new ArrayList<T>(this.count);
        for (int i = 0; i < this.count; ++i) {
            result.add(this.values[this.start + i]);
        }
        return result;
    }

    @Override
    public Flow<T> sort() {
        if (this.values.length < 2) {
            return this;
        }
        List<T> newValues = this.toMutableList();
        Collections.sort(newValues);
        return new ArrayFlow<T>(newValues);
    }

    @Override
    public Flow<T> sort(Comparator<T> comparator) {
        assert (comparator != null);
        if (this.values.length < 2) {
            return this;
        }
        List<T> newValues = this.toMutableList();
        Collections.sort(newValues, comparator);
        return new ArrayFlow<T>(newValues);
    }

    @Override
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    @Override
    public T first() {
        return this.values[this.start];
    }

    @Override
    public synchronized Flow<T> rest() {
        if (this.rest == null) {
            this.rest = this.buildRest();
        }
        return this.rest;
    }

    private Flow<T> buildRest() {
        if (this.count < 2) {
            return F.emptyFlow();
        }
        return new ArrayFlow<T>(this.values, this.start + 1, this.count - 1);
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public Flow<T> take(int length) {
        if (length < 1) {
            return F.emptyFlow();
        }
        return new ArrayFlow<T>(this.values, this.start, Math.min(this.count, length));
    }

    @Override
    public Flow<T> drop(int length) {
        assert (length >= 0);
        if (length == 0) {
            return this;
        }
        if (length >= this.count) {
            return F.emptyFlow();
        }
        return new ArrayFlow<T>(this.values, this.start + length, this.count - length);
    }
}

