/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.tapestry5.ioc.Resource;

public abstract class VirtualResource
implements Resource {
    protected static final Charset UTF8 = Charset.forName("UTF-8");

    private <T> T unsupported(String name) {
        throw new UnsupportedOperationException(String.format("Method %s() is not supported for a VirtualResource.", name));
    }

    public boolean exists() {
        return true;
    }

    public URL toURL() {
        return (URL)this.unsupported("toURL");
    }

    public Resource forLocale(Locale locale) {
        return (Resource)this.unsupported("forLocale");
    }

    public Resource forFile(String relativePath) {
        return this;
    }

    public Resource withExtension(String extension) {
        return (Resource)this.unsupported("withExtension");
    }

    public String getFolder() {
        return (String)this.unsupported("getFolder");
    }

    public String getFile() {
        return (String)this.unsupported("getFile");
    }

    public String getPath() {
        return (String)this.unsupported("getPath");
    }

    protected InputStream toInputStream(String content) throws IOException {
        return this.toInputStream(content.getBytes(UTF8));
    }

    protected InputStream toInputStream(byte[] content) throws IOException {
        return new ByteArrayInputStream(content);
    }

    public boolean isVirtual() {
        return true;
    }
}

