/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.util.List;
import java.util.Set;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class Errors {
    @Parameter(value="message:core-default-error-banner")
    private String banner;
    @Parameter
    private boolean globalOnly;
    @Parameter(name="class", defaultPrefix="literal", value="symbol:tapestry.errors-default-class-parameter-value")
    private String className;
    @Environmental(value=false)
    private ValidationTracker tracker;
    @Inject
    @Symbol(value="tapestry.errors-base-css-class")
    private String baseCssClass;
    @Inject
    @Symbol(value="tapestry.errors-close-button-css-class")
    private String closeButtonCssClass;
    @Inject
    private JavaScriptSupport javaScriptSupport;

    boolean beginRender(MarkupWriter writer) {
        List<String> errors;
        if (this.tracker == null) {
            throw new RuntimeException("The Errors component must be enclosed by a Form component.");
        }
        if (!this.tracker.getHasErrors()) {
            return false;
        }
        List<String> list = errors = this.globalOnly ? this.tracker.getUnassociatedErrors() : this.tracker.getErrors();
        if (errors.isEmpty()) {
            return false;
        }
        this.setUpJavaScript();
        Set previousErrors = CollectionFactory.newSet();
        writer.element("div", "class", this.baseCssClass + " " + this.className, "role", "alert");
        writer.element("button", "type", "button", "class", this.closeButtonCssClass, "data-dismiss", "alert");
        writer.writeRaw("&times;");
        writer.end();
        writer.element("h4", new Object[0]);
        writer.writeRaw(this.banner);
        writer.end();
        writer.element("ul", new Object[0]);
        for (String message : errors) {
            if (previousErrors.contains(message)) continue;
            writer.element("li", new Object[0]);
            writer.write(message);
            writer.end();
            previousErrors.add(message);
        }
        writer.end();
        writer.end();
        return false;
    }

    protected void setUpJavaScript() {
        this.javaScriptSupport.require("bootstrap/alert");
    }
}

