/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import org.apache.spark.TaskState$;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.scheduler.AccumulableInfo;
import scala.Enumeration;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\u001a4\u0001qB\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0011\n\u0001BC\u0002\u0013\u0005!\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003L\u0011!y\u0005A!b\u0001\n\u0003Q\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011E\u0003!Q1A\u0005\u0002)C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t'\u0002\u0011)\u0019!C\u0001\t\"AA\u000b\u0001B\u0001B\u0003%Q\t\u0003\u0005V\u0001\t\u0015\r\u0011\"\u0001W\u0011!\u0011\u0007A!A!\u0002\u00139\u0006\u0002C2\u0001\u0005\u000b\u0007I\u0011\u0001,\t\u0011\u0011\u0004!\u0011!Q\u0001\n]C\u0001\"\u001a\u0001\u0003\u0006\u0004%\tA\u001a\u0005\t_\u0002\u0011\t\u0011)A\u0005O\"A\u0001\u000f\u0001BC\u0002\u0013\u0005\u0011\u000f\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003s\u0011\u00151\b\u0001\"\u0001x\u0011\u00191\b\u0001\"\u0001\u0002\u0006!A\u0011q\u0003\u0001A\u0002\u0013\u0005A\tC\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0001\u0002\u001c!9\u0011q\u0005\u0001!B\u0013)\u0005bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\t\u0003\u000b\u0002\u0001\u0015)\u0003\u0002.!A\u0011q\t\u0001\u0005\u0002U\nI\u0005\u0003\u0005\u0002P\u0001\u0001\r\u0011\"\u0001E\u0011%\t\t\u0006\u0001a\u0001\n\u0003\t\u0019\u0006C\u0004\u0002X\u0001\u0001\u000b\u0015B#\t\u0011\u0005e\u0003\u00011A\u0005\u0002ED\u0011\"a\u0017\u0001\u0001\u0004%\t!!\u0018\t\u000f\u0005\u0005\u0004\u0001)Q\u0005e\"A\u00111\r\u0001A\u0002\u0013\u0005\u0011\u000fC\u0005\u0002f\u0001\u0001\r\u0011\"\u0001\u0002h!9\u00111\u000e\u0001!B\u0013\u0011\b\u0002CA7\u0001\u0001\u0007I\u0011A9\t\u0013\u0005=\u0004\u00011A\u0005\u0002\u0005E\u0004bBA;\u0001\u0001\u0006KA\u001d\u0005\t\u0003o\u0002A\u0011A\u001b\u0002z!A\u0011q\u0010\u0001\u0005\u0002U\n\t\t\u0003\u0005\u0002$\u0002!\t!NAS\u0011\u0019\t9\u000b\u0001C\u0001c\"1\u0011\u0011\u0016\u0001\u0005\u0002EDa!a+\u0001\t\u0003\t\bBBAW\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u00020\u0002!\tA\u0016\u0005\u0007\u0003c\u0003A\u0011\u0001,\t\r\u0005M\u0006\u0001\"\u0001E\u0011!\t)\f\u0001C\u0001k\u0005]&\u0001\u0003+bg.LeNZ8\u000b\u0005Q*\u0014!C:dQ\u0016$W\u000f\\3s\u0015\t1t'A\u0003ta\u0006\u00148N\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<7\u0001A\n\u0003\u0001u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0017A\u0002;bg.LE-F\u0001F!\tqd)\u0003\u0002H\u007f\t!Aj\u001c8h\u0003\u001d!\u0018m]6JI\u0002\nQ!\u001b8eKb,\u0012a\u0013\t\u0003}1K!!T \u0003\u0007%sG/\u0001\u0004j]\u0012,\u0007\u0010I\u0001\u000eCR$X-\u001c9u\u001dVl'-\u001a:\u0002\u001d\u0005$H/Z7qi:+XNY3sA\u0005Y\u0001/\u0019:uSRLwN\\%e\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0003)a\u0017-\u001e8dQRKW.Z\u0001\fY\u0006,hn\u00195US6,\u0007%\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012,\u0012a\u0016\t\u00031~s!!W/\u0011\u0005i{T\"A.\u000b\u0005q[\u0014A\u0002\u001fs_>$h(\u0003\u0002_\u007f\u00051\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tqv(A\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012\u0004\u0013\u0001\u00025pgR\fQ\u0001[8ti\u0002\nA\u0002^1tW2{7-\u00197jif,\u0012a\u001a\t\u0003Q2t!!\u001b6\u000e\u0003MJ!a[\u001a\u0002\u0019Q\u000b7o\u001b'pG\u0006d\u0017\u000e^=\n\u00055t'\u0001\u0004+bg.dunY1mSRL(BA64\u00035!\u0018m]6M_\u000e\fG.\u001b;zA\u0005Y1\u000f]3dk2\fG/\u001b<f+\u0005\u0011\bC\u0001 t\u0013\t!xHA\u0004C_>dW-\u00198\u0002\u0019M\u0004XmY;mCRLg/\u001a\u0011\u0002\rqJg.\u001b;?)1A\u0018P_>}{z|\u0018\u0011AA\u0002!\tI\u0007\u0001C\u0003D'\u0001\u0007Q\tC\u0003J'\u0001\u00071\nC\u0003P'\u0001\u00071\nC\u0003R'\u0001\u00071\nC\u0003T'\u0001\u0007Q\tC\u0003V'\u0001\u0007q\u000bC\u0003d'\u0001\u0007q\u000bC\u0003f'\u0001\u0007q\rC\u0003q'\u0001\u0007!\u000fF\ty\u0003\u000f\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+AQa\u0011\u000bA\u0002\u0015CQ!\u0013\u000bA\u0002-CQa\u0014\u000bA\u0002-CQa\u0015\u000bA\u0002\u0015CQ!\u0016\u000bA\u0002]CQa\u0019\u000bA\u0002]CQ!\u001a\u000bA\u0002\u001dDQ\u0001\u001d\u000bA\u0002I\f\u0011cZ3ui&twMU3tk2$H+[7f\u0003U9W\r\u001e;j]\u001e\u0014Vm];miRKW.Z0%KF$B!!\b\u0002$A\u0019a(a\b\n\u0007\u0005\u0005rH\u0001\u0003V]&$\b\u0002CA\u0013-\u0005\u0005\t\u0019A#\u0002\u0007a$\u0013'\u0001\nhKR$\u0018N\\4SKN,H\u000e\u001e+j[\u0016\u0004\u0013\u0001D1dGVlW\u000f\\1cY\u0016\u001cXCAA\u0017!\u0019\ty#!\u000f\u0002@9!\u0011\u0011GA\u001b\u001d\rQ\u00161G\u0005\u0002\u0001&\u0019\u0011qG \u0002\u000fA\f7m[1hK&!\u00111HA\u001f\u0005\r\u0019V-\u001d\u0006\u0004\u0003oy\u0004cA5\u0002B%\u0019\u00111I\u001a\u0003\u001f\u0005\u001b7-^7vY\u0006\u0014G.Z%oM>\fQbX1dGVlW\u000f\\1cY\u0016\u001c\u0018aD:fi\u0006\u001b7-^7vY\u0006\u0014G.Z:\u0015\t\u0005u\u00111\n\u0005\b\u0003\u001bR\u0002\u0019AA\u0017\u0003=qWm^!dGVlW\u000f\\1cY\u0016\u001c\u0018A\u00034j]&\u001c\b\u000eV5nK\u0006qa-\u001b8jg\"$\u0016.\\3`I\u0015\fH\u0003BA\u000f\u0003+B\u0001\"!\n\u001d\u0003\u0003\u0005\r!R\u0001\fM&t\u0017n\u001d5US6,\u0007%\u0001\u0004gC&dW\rZ\u0001\u000bM\u0006LG.\u001a3`I\u0015\fH\u0003BA\u000f\u0003?B\u0001\"!\n \u0003\u0003\u0005\rA]\u0001\bM\u0006LG.\u001a3!\u0003\u0019Y\u0017\u000e\u001c7fI\u0006Q1.\u001b7mK\u0012|F%Z9\u0015\t\u0005u\u0011\u0011\u000e\u0005\t\u0003K\u0011\u0013\u0011!a\u0001e\u000691.\u001b7mK\u0012\u0004\u0013!\u00037bk:\u001c\u0007.\u001b8h\u00035a\u0017-\u001e8dQ&twm\u0018\u0013fcR!\u0011QDA:\u0011!\t)#JA\u0001\u0002\u0004\u0011\u0018A\u00037bk:\u001c\u0007.\u001b8hA\u0005\tR.\u0019:l\u000f\u0016$H/\u001b8h%\u0016\u001cX\u000f\u001c;\u0015\t\u0005u\u00111\u0010\u0005\u0007\u0003{:\u0003\u0019A#\u0002\tQLW.Z\u0001\r[\u0006\u00148NR5oSNDW\r\u001a\u000b\u0007\u0003;\t\u0019)!)\t\u000f\u0005\u0015\u0005\u00061\u0001\u0002\b\u0006)1\u000f^1uKB!\u0011\u0011RAN\u001d\u0011\tY)a&\u000f\t\u00055\u0015Q\u0013\b\u0005\u0003\u001f\u000b\u0019JD\u0002[\u0003#K\u0011AO\u0005\u0003qeJ!AN\u001c\n\u0007\u0005eU'A\u0005UCN\\7\u000b^1uK&!\u0011QTAP\u0005%!\u0016m]6Ti\u0006$XMC\u0002\u0002\u001aVBa!! )\u0001\u0004)\u0015a\u00047bk:\u001c\u0007nU;dG\u0016,G-\u001a3\u0015\u0005\u0005u\u0011!D4fiRLgn\u001a*fgVdG/\u0001\u0005gS:L7\u000f[3e\u0003)\u0019XoY2fgN4W\u000f\\\u0001\beVtg.\u001b8h\u0003\u0019\u0019H/\u0019;vg\u0006\u0011\u0011\u000eZ\u0001\tIV\u0014\u0018\r^5p]\u0006YA/[7f%Vtg.\u001b8h)\r)\u0015\u0011\u0018\u0005\u0007\u0003w\u000b\u0004\u0019A#\u0002\u0017\r,(O]3oiRKW.\u001a\u0015\u0004\u0001\u0005}\u0006\u0003BAa\u0003\u000fl!!a1\u000b\u0007\u0005\u0015W'\u0001\u0006b]:|G/\u0019;j_:LA!!3\u0002D\naA)\u001a<fY>\u0004XM]!qS\u0002")
public class TaskInfo {
    private final long taskId;
    private final int index;
    private final int attemptNumber;
    private final int partitionId;
    private final long launchTime;
    private final String executorId;
    private final String host;
    private final Enumeration.Value taskLocality;
    private final boolean speculative;
    private long gettingResultTime;
    private Seq<AccumulableInfo> _accumulables;
    private long finishTime;
    private boolean failed;
    private boolean killed;
    private boolean launching;

    public long taskId() {
        return this.taskId;
    }

    public int index() {
        return this.index;
    }

    public int attemptNumber() {
        return this.attemptNumber;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public long launchTime() {
        return this.launchTime;
    }

    public String executorId() {
        return this.executorId;
    }

    public String host() {
        return this.host;
    }

    public Enumeration.Value taskLocality() {
        return this.taskLocality;
    }

    public boolean speculative() {
        return this.speculative;
    }

    public long gettingResultTime() {
        return this.gettingResultTime;
    }

    public void gettingResultTime_$eq(long x$1) {
        this.gettingResultTime = x$1;
    }

    public Seq<AccumulableInfo> accumulables() {
        return this._accumulables;
    }

    public void setAccumulables(Seq<AccumulableInfo> newAccumulables) {
        this._accumulables = newAccumulables;
    }

    public long finishTime() {
        return this.finishTime;
    }

    public void finishTime_$eq(long x$1) {
        this.finishTime = x$1;
    }

    public boolean failed() {
        return this.failed;
    }

    public void failed_$eq(boolean x$1) {
        this.failed = x$1;
    }

    public boolean killed() {
        return this.killed;
    }

    public void killed_$eq(boolean x$1) {
        this.killed = x$1;
    }

    public boolean launching() {
        return this.launching;
    }

    public void launching_$eq(boolean x$1) {
        this.launching = x$1;
    }

    public void markGettingResult(long time) {
        this.gettingResultTime_$eq(time);
    }

    public void markFinished(Enumeration.Value state, long time) {
        Predef$.MODULE$.assert(time > 0L);
        this.finishTime_$eq(time);
        Enumeration.Value value = state;
        Enumeration.Value value2 = TaskState$.MODULE$.FAILED();
        this.failed_$eq(!(value != null ? !value.equals(value2) : value2 != null));
        Enumeration.Value value3 = state;
        Enumeration.Value value4 = TaskState$.MODULE$.KILLED();
        this.killed_$eq(!(value3 != null ? !value3.equals(value4) : value4 != null));
    }

    public void launchSucceeded() {
        this.launching_$eq(false);
    }

    public boolean gettingResult() {
        return this.gettingResultTime() != 0L;
    }

    public boolean finished() {
        return this.finishTime() != 0L;
    }

    public boolean successful() {
        return this.finished() && !this.failed() && !this.killed();
    }

    public boolean running() {
        return !this.finished();
    }

    public String status() {
        if (this.running()) {
            if (this.gettingResult()) {
                return "GET RESULT";
            }
            return "RUNNING";
        }
        if (this.failed()) {
            return "FAILED";
        }
        if (this.killed()) {
            return "KILLED";
        }
        if (this.successful()) {
            return "SUCCESS";
        }
        return "UNKNOWN";
    }

    public String id() {
        return new StringBuilder(1).append(this.index()).append(".").append(this.attemptNumber()).toString();
    }

    public long duration() {
        if (!this.finished()) {
            throw SparkCoreErrors$.MODULE$.durationCalledOnUnfinishedTaskError();
        }
        return this.finishTime() - this.launchTime();
    }

    public long timeRunning(long currentTime) {
        return currentTime - this.launchTime();
    }

    public TaskInfo(long taskId, int index, int attemptNumber, int partitionId, long launchTime, String executorId, String host, Enumeration.Value taskLocality, boolean speculative) {
        this.taskId = taskId;
        this.index = index;
        this.attemptNumber = attemptNumber;
        this.partitionId = partitionId;
        this.launchTime = launchTime;
        this.executorId = executorId;
        this.host = host;
        this.taskLocality = taskLocality;
        this.speculative = speculative;
        this.gettingResultTime = 0L;
        this._accumulables = Nil$.MODULE$;
        this.finishTime = 0L;
        this.failed = false;
        this.killed = false;
        this.launching = true;
    }

    public TaskInfo(long taskId, int index, int attemptNumber, long launchTime, String executorId, String host, Enumeration.Value taskLocality, boolean speculative) {
        this(taskId, index, attemptNumber, -1, launchTime, executorId, host, taskLocality, speculative);
    }
}

