/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen.codegen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.sysds.common.Types;

public class CodeGenTrieNode {
    private final Map<String, CodeGenTrieNode> children = new HashMap<String, CodeGenTrieNode>();
    private boolean endOfCondition;
    private String colIndex;
    private Types.ValueType valueType;
    private String key;
    private final NodeType type;
    private int rowIndexBeginPos;
    private int colIndexBeginPos;

    public CodeGenTrieNode(NodeType type) {
        this.endOfCondition = false;
        this.type = type;
    }

    public CodeGenTrieNode(String colIndex, String key, NodeType type) {
        this.colIndex = colIndex;
        this.key = key;
        this.type = type;
    }

    public CodeGenTrieNode(boolean endOfCondition, String colIndex, Types.ValueType valueType, String key, HashSet<String> naStrings, NodeType type) {
        this.endOfCondition = endOfCondition;
        this.colIndex = colIndex;
        this.valueType = valueType;
        this.key = key;
        this.type = type;
    }

    public String geValueCode(String destination, String currPos) {
        if (this.type == NodeType.INDEX) {
            return this.getIndexCode(currPos);
        }
        return this.getColValueCode(destination, currPos);
    }

    private String getIndexCode(String currPos) {
        StringBuilder src = new StringBuilder();
        String ewvs = this.colIndex.equals("0") ? "endWithValueStringRow" : "endWithValueStringCol";
        src.append("endPos = TemplateUtil.getEndPos(str, strLen, " + currPos + "," + ewvs + "); \n");
        String subStr = "str.substring(" + currPos + ",endPos)";
        src.append("try{ \n");
        if (this.colIndex.equals("0")) {
            if (this.rowIndexBeginPos > 0) {
                src.append("row = ").append("Integer.parseInt(" + subStr + ") - " + this.rowIndexBeginPos + "; \n");
            } else {
                src.append("row = ").append("Integer.parseInt(" + subStr + "); \n");
            }
        } else if (this.colIndexBeginPos > 0) {
            src.append("col = ").append("Integer.parseInt(" + subStr + ") - " + this.colIndexBeginPos + "; \n");
        } else {
            src.append("col = ").append("Integer.parseInt(" + subStr + "); \n");
        }
        src.append("} catch(Exception e){} \n");
        return src.toString();
    }

    private String getColValueCode(String destination, String currPos) {
        StringBuilder src = new StringBuilder();
        if (this.colIndex.equals("col")) {
            src.append("endPos = TemplateUtil.getEndPos(str, strLen, " + currPos + ", endWithValueStringVal); \n");
        } else {
            src.append("endPos = TemplateUtil.getEndPos(str, strLen, " + currPos + ", endWithValueString[" + this.colIndex + "]); \n");
        }
        src.append("String cellStr" + this.colIndex + " = str.substring(" + currPos + ",endPos); \n");
        if (this.valueType.isNumeric()) {
            src.append("if ( cellStr" + this.colIndex + ".length() > 0 ){\n");
            src.append(this.getParsCode("cellStr" + this.colIndex));
            src.append("if(cellValue" + this.colIndex + " != 0) { \n");
            src.append(destination).append("(row, " + this.colIndex + ", cellValue" + this.colIndex + "); \n");
            src.append("lnnz++;\n");
            src.append("}\n");
            src.append("}\n");
        } else if (this.valueType == Types.ValueType.BOOLEAN) {
            src.append(this.getParsCode("cellStr" + this.colIndex));
            src.append(destination).append("(row, " + this.colIndex + ", cellValue" + this.colIndex + "); \n");
        } else if (this.valueType == Types.ValueType.STRING) {
            src.append(destination).append("(row, " + this.colIndex + ", cellStr" + this.colIndex + "); \n");
        }
        return src.toString();
    }

    private String getParsCode(String subStr) {
        String cellValue = "cellValue" + this.colIndex;
        switch (this.valueType) {
            case STRING: {
                return "String " + cellValue + " = " + subStr + "; \n";
            }
            case BOOLEAN: {
                return "Boolean " + cellValue + "; \n try{ " + cellValue + "= Boolean.parseBoolean(" + subStr + ");} catch(Exception e){" + cellValue + "=false;} \n";
            }
            case INT32: {
                return "Integer " + cellValue + "; \n try{ " + cellValue + "= Integer.parseInt(" + subStr + ");} catch(Exception e){" + cellValue + " = 0;} \n";
            }
            case INT64: {
                return "Long " + cellValue + "; \n try{" + cellValue + "= Long.parseLong(" + subStr + "); } catch(Exception e){" + cellValue + " = 0l;} \n";
            }
            case FP64: {
                return "Double " + cellValue + "; \n try{ " + cellValue + "= Double.parseDouble(" + subStr + "); } catch(Exception e){" + cellValue + " = 0d;}\n";
            }
            case FP32: {
                return "Float " + cellValue + "; \n try{ " + cellValue + "= Float.parseFloat(" + subStr + ");} catch(Exception e){" + cellValue + " = 0f;} \n";
            }
        }
        throw new RuntimeException("Unsupported value type: " + this.valueType);
    }

    public Map<String, CodeGenTrieNode> getChildren() {
        return this.children;
    }

    public boolean isEndOfCondition() {
        return this.endOfCondition;
    }

    public void setEndOfCondition(boolean endOfCondition) {
        this.endOfCondition = endOfCondition;
    }

    public String getColIndex() {
        return this.colIndex;
    }

    public void setColIndex(String colIndex) {
        this.colIndex = colIndex;
    }

    public Types.ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(Types.ValueType valueType) {
        this.valueType = valueType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public NodeType getType() {
        return this.type;
    }

    public int getRowIndexBeginPos() {
        return this.rowIndexBeginPos;
    }

    public void setRowIndexBeginPos(int rowIndexBeginPos) {
        this.rowIndexBeginPos = rowIndexBeginPos;
    }

    public int getColIndexBeginPos() {
        return this.colIndexBeginPos;
    }

    public void setColIndexBeginPos(int colIndexBeginPos) {
        this.colIndexBeginPos = colIndexBeginPos;
    }

    public static enum NodeType {
        VALUE,
        ROW,
        COL,
        INDEX;


        public String toString() {
            return this.name().toUpperCase();
        }
    }
}

