/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.log4j.Level;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.ParForStatementBlock;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.VariableSet;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.ForProgramBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.DataPartitioner;
import org.apache.sysds.runtime.controlprogram.parfor.DataPartitionerLocal;
import org.apache.sysds.runtime.controlprogram.parfor.DataPartitionerRemoteSpark;
import org.apache.sysds.runtime.controlprogram.parfor.LocalParWorker;
import org.apache.sysds.runtime.controlprogram.parfor.LocalTaskQueue;
import org.apache.sysds.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysds.runtime.controlprogram.parfor.RemoteDPParForSpark;
import org.apache.sysds.runtime.controlprogram.parfor.RemoteParForJobReturn;
import org.apache.sysds.runtime.controlprogram.parfor.RemoteParForSpark;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeFrameLocalMemory;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeLocalAutomatic;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeLocalFile;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeLocalMemory;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMergeRemoteSpark;
import org.apache.sysds.runtime.controlprogram.parfor.Task;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitioner;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerFactoring;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerFactoringCmax;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerFactoringCmin;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerFixedsize;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerNaive;
import org.apache.sysds.runtime.controlprogram.parfor.TaskPartitionerStatic;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptTreeConverter;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptimizationWrapper;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptimizerRuleBased;
import org.apache.sysds.runtime.controlprogram.parfor.opt.ProgramRecompiler;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Stat;
import org.apache.sysds.runtime.controlprogram.parfor.stat.StatisticMonitor;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.StringObject;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.util.CollectionUtils;
import org.apache.sysds.runtime.util.ProgramConverter;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.stats.ParForStatistics;

public class ParForProgramBlock
extends ForProgramBlock {
    public static final boolean OPTIMIZE = true;
    public static final boolean USE_PB_CACHE = false;
    public static final boolean USE_RANGE_TASKS_IF_USEFUL = true;
    public static final boolean USE_STREAMING_TASK_CREATION = true;
    public static final boolean ALLOW_NESTED_PARALLELISM = true;
    public static final boolean CONVERT_NESTED_REMOTE_PARFOR = true;
    public static final boolean USE_PARALLEL_RESULT_MERGE = false;
    public static final boolean USE_PARALLEL_RESULT_MERGE_REMOTE = true;
    public static final boolean CREATE_UNSCOPED_RESULTVARS = true;
    public static boolean ALLOW_REUSE_PARTITION_VARS = true;
    public static final int WRITE_REPLICATION_FACTOR = 1;
    public static int MAX_RETRYS_ON_ERROR = 1;
    public static final boolean FORCE_CP_ON_REMOTE_SPARK = true;
    public static final boolean LIVEVAR_AWARE_EXPORT = true;
    public static final boolean RESET_RECOMPILATION_FLAGs = true;
    public static boolean ALLOW_BROADCAST_INPUTS = true;
    public static final boolean COPY_EVAL_FUNCTIONS = true;
    public static final String PARFOR_FNAME_PREFIX = "/parfor/";
    public static final String PARFOR_MR_TASKS_TMP_FNAME = "/parfor/%ID%_MR_taskfile";
    public static final String PARFOR_MR_RESULT_TMP_FNAME = "/parfor/%ID%_MR_results";
    public static final String PARFOR_MR_RESULTMERGE_FNAME = "/parfor/%ID%_resultmerge%VAR%";
    public static final String PARFOR_DATAPARTITIONS_FNAME = "/parfor/%ID%_datapartitions%VAR%";
    public static final String PARFOR_COUNTER_GROUP_NAME = "SystemDS ParFOR Counters";
    private static final IDSequence _pfIDSeq = new IDSequence();
    private static final IDSequence _pwIDSeq = new IDSequence();
    protected final HashMap<String, String> _params;
    protected final boolean _monitor;
    protected final Level _optLogLevel;
    protected int _numThreads = -1;
    protected boolean _fixedDOP = false;
    protected long _taskSize = -1L;
    protected PTaskPartitioner _taskPartitioner;
    protected PDataPartitioner _dataPartitioner;
    protected PResultMerge _resultMerge;
    protected PExecMode _execMode;
    protected POptMode _optMode;
    protected long _numIterations = -1L;
    protected LocalVariableMap _variablesDPOriginal;
    protected LocalVariableMap _variablesDPReuse;
    protected String _colocatedDPMatrix = null;
    protected boolean _tSparseCol = false;
    protected int _replicationDP = 1;
    protected int _replicationExport = -1;
    protected boolean _jvmReuse = true;
    protected double _oldMemoryBudget = -1.0;
    protected double _recompileMemoryBudget = -1.0;
    protected boolean _enableCPCaching = true;
    protected boolean _enableRuntimePiggybacking = false;
    protected Collection<String> _variablesRP = null;
    protected Collection<String> _variablesECache = null;
    protected final ArrayList<ParForStatementBlock.ResultVar> _resultVars;
    protected final IDSequence _resultVarsIDSeq;
    protected final IDSequence _dpVarsIDSeq;
    protected final boolean _hasFunctions;
    protected long _ID = -1L;
    protected int _IDPrefix = -1;
    protected boolean _monitorReport = false;
    protected HashMap<Long, ArrayList<ProgramBlock>> _pbcache = null;
    protected long[] _pwIDs = null;

    public ParForProgramBlock(Program prog, String iterPredVar, HashMap<String, String> params, ArrayList<ParForStatementBlock.ResultVar> resultVars) {
        this(-1, prog, iterPredVar, params, resultVars);
    }

    public ParForProgramBlock(int ID, Program prog, String iterPredVar, HashMap<String, String> params, ArrayList<ParForStatementBlock.ResultVar> resultVars) {
        super(prog, iterPredVar);
        this.setParForProgramBlockIDs(ID);
        this._resultVars = resultVars;
        this._resultVarsIDSeq = new IDSequence();
        this._dpVarsIDSeq = new IDSequence();
        this._params = params;
        try {
            this._numThreads = Integer.parseInt(this.getParForParam("par"));
            this._taskPartitioner = PTaskPartitioner.valueOf(this.getParForParam("taskpartitioner"));
            this._taskSize = Integer.parseInt(this.getParForParam("tasksize"));
            this._dataPartitioner = PDataPartitioner.valueOf(this.getParForParam("datapartitioner"));
            this._resultMerge = PResultMerge.valueOf(this.getParForParam("resultmerge"));
            this._execMode = PExecMode.valueOf(this.getParForParam("mode"));
            this._optMode = POptMode.valueOf(this.getParForParam("opt"));
            this._optLogLevel = Level.toLevel((String)this.getParForParam("log"));
            this._monitor = Integer.parseInt(this.getParForParam("profile")) == 1;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error parsing specified ParFOR parameters.", ex);
        }
        this._variablesDPOriginal = new LocalVariableMap();
        this._variablesDPReuse = new LocalVariableMap();
        if (this._execMode == PExecMode.LOCAL) {
            this.setLocalParWorkerIDs();
        }
        this._monitorReport = this._monitor;
        this._hasFunctions = ProgramRecompiler.containsAtLeastOneFunction(this);
        LOG.trace((Object)("PARFOR: ParForProgramBlock created with mode = " + this._execMode + ", optmode = " + this._optMode + ", numThreads = " + this._numThreads));
    }

    public static void resetWorkerIDs() {
        _pwIDSeq.reset();
    }

    public long getID() {
        return this._ID;
    }

    public PExecMode getExecMode() {
        return this._execMode;
    }

    public HashMap<String, String> getParForParams() {
        return this._params;
    }

    public String getParForParam(String key) {
        String tmp = this.getParForParams().get(key);
        return tmp == null ? null : UtilFunctions.unquote(tmp).toUpperCase();
    }

    public ArrayList<ParForStatementBlock.ResultVar> getResultVariables() {
        return this._resultVars;
    }

    public void disableOptimization() {
        this._optMode = POptMode.NONE;
    }

    public POptMode getOptimizationMode() {
        return this._optMode;
    }

    public void setOptimizationMode(POptMode mode) {
        this._optMode = mode;
    }

    public int getDegreeOfParallelism() {
        return this._numThreads;
    }

    public void setDegreeOfParallelism(int k) {
        this._numThreads = k;
        this._params.put("par", String.valueOf(this._numThreads));
        this.setLocalParWorkerIDs();
    }

    public boolean isDegreeOfParallelismFixed() {
        return this._fixedDOP;
    }

    public void setDegreeOfParallelismFixed(boolean flag) {
        this._fixedDOP = flag;
    }

    public void setCPCaching(boolean flag) {
        this._enableCPCaching = flag;
    }

    public void setRuntimePiggybacking(boolean flag) {
        this._enableRuntimePiggybacking = flag;
    }

    public void setExecMode(PExecMode mode) {
        this._execMode = mode;
        this._params.put("mode", String.valueOf((Object)this._execMode));
    }

    public void setTaskPartitioner(PTaskPartitioner partitioner) {
        this._taskPartitioner = partitioner;
        this._params.put("taskpartitioner", String.valueOf((Object)this._taskPartitioner));
    }

    public void setTaskSize(long tasksize) {
        this._taskSize = tasksize;
        this._params.put("tasksize", String.valueOf(this._taskSize));
    }

    public void setDataPartitioner(PDataPartitioner partitioner) {
        this._dataPartitioner = partitioner;
        this._params.put("datapartitioner", String.valueOf((Object)this._dataPartitioner));
    }

    public void enableColocatedPartitionedMatrix(String varname) {
        this._colocatedDPMatrix = varname;
    }

    public void setTransposeSparseColumnVector(boolean flag) {
        this._tSparseCol = flag;
    }

    public void setPartitionReplicationFactor(int rep) {
        this._replicationDP = rep;
    }

    public void setExportReplicationFactor(int rep) {
        this._replicationExport = rep;
    }

    public void disableJVMReuse() {
        this._jvmReuse = false;
    }

    public void disableMonitorReport() {
        this._monitorReport = false;
    }

    public void setResultMerge(PResultMerge merge) {
        this._resultMerge = merge;
        this._params.put("resultmerge", String.valueOf((Object)this._resultMerge));
    }

    public void setRecompileMemoryBudget(double localMem) {
        this._recompileMemoryBudget = localMem;
    }

    public void setSparkRepartitionVariables(Collection<String> vars) {
        this._variablesRP = vars;
    }

    public Collection<String> getSparkRepartitionVariables() {
        return this._variablesRP;
    }

    public void setSparkEagerCacheVariables(Collection<String> vars) {
        this._variablesECache = vars;
    }

    public long getNumIterations() {
        return this._numIterations;
    }

    public boolean hasFunctions() {
        return this._hasFunctions;
    }

    @Override
    public void execute(ExecutionContext ec) {
        ScalarObject incr0;
        ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
        ScalarObject from0 = this.executePredicateInstructions(1, this._fromInstructions, ec, false);
        ScalarObject to0 = this.executePredicateInstructions(2, this._toInstructions, ec, false);
        ScalarObject scalarObject = this._incrementInstructions == null || this._incrementInstructions.isEmpty() ? new IntObject(from0.getLongValue() <= to0.getLongValue() ? 1L : -1L) : (incr0 = this.executePredicateInstructions(3, this._incrementInstructions, ec, false));
        if (incr0.getLongValue() == 0L) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Expression for increment of variable '" + this._iterPredVar + "' must evaluate to a non-zero value.");
        }
        this._numIterations = UtilFunctions.getSeqLength(from0.getDoubleValue(), to0.getDoubleValue(), incr0.getDoubleValue(), false);
        if (this._numIterations <= 0L) {
            return;
        }
        IntObject from = new IntObject(from0.getLongValue());
        IntObject to = new IntObject(to0.getLongValue());
        IntObject incr = new IntObject(incr0.getLongValue());
        if (this._optMode != POptMode.NONE) {
            OptimizationWrapper.setLogLevel(this._optLogLevel);
            OptimizationWrapper.optimize(this._optMode, sb, this, ec, this._monitor);
        }
        Timing time = this._monitor ? new Timing(true) : null;
        this.handleDataPartitioning(ec);
        this.handleSparkRepartitioning(ec);
        this.handleSparkEagerCaching(ec);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_DATA_T, time.stop());
        }
        IntObject iterVar = new IntObject(from.getLongValue());
        LOG.trace((Object)("EXECUTE PARFOR ID = " + this._ID + " with mode = " + this._execMode + ", numThreads = " + this._numThreads + ", taskpartitioner = " + this._taskPartitioner));
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMTHREADS, this._numThreads);
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_TASKSIZE, this._taskSize);
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_TASKPARTITIONER, this._taskPartitioner.ordinal());
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_DATAPARTITIONER, this._dataPartitioner.ordinal());
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_EXECMODE, this._execMode.ordinal());
        }
        ArrayList<String> varList = ec.getVarList();
        boolean[] varState = ec.pinVariables(varList);
        try {
            switch (this._execMode) {
                case LOCAL: {
                    this.executeLocalParFor(ec, from, to, incr);
                    break;
                }
                case REMOTE_SPARK: {
                    this.executeRemoteSparkParFor(ec, from, to, incr);
                    break;
                }
                case REMOTE_SPARK_DP: {
                    this.executeRemoteSparkParForDP(ec, from, to, incr);
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Undefined execution mode: '" + this._execMode + "'.");
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("PARFOR: Failed to execute loop in parallel.", ex);
        }
        ec.unpinVariables(varList, varState);
        this.cleanupSharedVariables(ec, varState);
        iterVar = new IntObject(to.getLongValue());
        ec.setVariable(this._iterPredVar, iterVar);
        for (String var : this._variablesDPOriginal.keySet()) {
            if (!this._variablesDPReuse.keySet().contains(var)) {
                VariableCPInstruction.processRmvarInstruction(ec, var);
            }
            MatrixObject mo = (MatrixObject)this._variablesDPOriginal.get(var);
            ec.setVariable(var, mo);
        }
        this.executeExitInstructions("parfor", ec);
        if (this._monitorReport) {
            LOG.info((Object)("\n" + StatisticMonitor.createReport()));
        }
        for (String dpvar : this._variablesDPOriginal.keySet()) {
            ProgramRecompiler.rFindAndRecompileIndexingHOP(sb, this, dpvar, ec, false);
        }
        if (this._execMode == PExecMode.REMOTE_SPARK_DP) {
            ProgramRecompiler.rFindAndRecompileIndexingHOP(sb, this, this._colocatedDPMatrix, ec, false);
        }
        this.resetOptimizerFlags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLocalParFor(ExecutionContext ec, IntObject from, IntObject to, IntObject incr) throws InterruptedException {
        LOG.trace((Object)("Local Par For (multi-threaded) with degree of parallelism : " + this._numThreads));
        Timing time = new Timing(true);
        int numExecutedTasks = 0;
        int numExecutedIterations = 0;
        this.setMemoryBudget();
        try {
            LocalTaskQueue<Task> queue = new LocalTaskQueue<Task>();
            Thread[] threads = new Thread[this._numThreads];
            LocalParWorker[] workers = new LocalParWorker[this._numThreads];
            IntStream.range(0, this._numThreads).parallel().forEach(i -> {
                workers[i] = this.createParallelWorker(this._pwIDs[i], queue, ec, i);
                threads[i] = new Thread(workers[i]);
                threads[i].setPriority(10);
            });
            for (Thread thread : threads) {
                thread.start();
            }
            long tinit = (long)time.stop();
            if (DMLScript.STATISTICS) {
                ParForStatistics.incrementInitTime(tinit);
            }
            if (this._monitor) {
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_PARWRK_T, tinit);
            }
            TaskPartitioner partitioner = this.createTaskPartitioner(from, to, incr);
            long numIterations = partitioner.getNumIterations();
            long numCreatedTasks = -1L;
            numCreatedTasks = partitioner.createTasks(queue);
            if (this._monitor) {
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_TASKS_T, time.stop());
            }
            for (Thread thread : threads) {
                thread.join();
            }
            if (this._monitor) {
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_EXEC_T, time.stop());
            }
            LocalVariableMap[] localVariables = new LocalVariableMap[this._numThreads];
            for (int i2 = 0; i2 < this._numThreads; ++i2) {
                localVariables[i2] = workers[i2].getVariables();
                localVariables[i2].removeAllNotIn(this._resultVars.stream().map(v -> v._name).collect(Collectors.toSet()));
                numExecutedTasks = (int)((long)numExecutedTasks + workers[i2].getExecutedTasks());
                numExecutedIterations = (int)((long)numExecutedIterations + workers[i2].getExecutedIterations());
            }
            Lineage[] lineages = (Lineage[])Arrays.stream(workers).filter(w -> w.getExecutedTasks() >= 1L).map(w -> w.getExecutionContext().getLineage()).toArray(Lineage[]::new);
            this.mergeLineage(ec, lineages);
            this.consolidateAndCheckResults(ec, numIterations, numCreatedTasks, numExecutedIterations, numExecutedTasks, localVariables);
            for (int i3 = 0; i3 < this._numThreads; ++i3) {
                Collection<String> fnNames = workers[i3].getFunctionNames();
                if (fnNames != null) {
                    fnNames.stream().map(fn -> DMLProgram.splitFunctionKey(fn)).forEach(p -> this._prog.removeFunctionProgramBlock(p[0], p[1]));
                }
                workers[i3].getExecutionContext().getTmpParforFunctions().stream().map(fn -> DMLProgram.splitFunctionKey(fn)).forEach(p -> {
                    this._prog.getDMLProg().removeFunctionStatementBlock(p[0], p[1]);
                    this._prog.removeFunctionProgramBlock(p[0], p[1]);
                });
            }
            if (DMLScript.USE_ACCELERATOR) {
                ec.getGPUContext(0).initializeThread();
            }
        }
        finally {
            this.resetMemoryBudget();
            if (this._monitor) {
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_RESULTS_T, time.stop());
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMTASKS, numExecutedTasks);
                StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMITERS, numExecutedIterations);
            }
        }
    }

    private void executeRemoteSparkParFor(ExecutionContext ec, IntObject from, IntObject to, IntObject incr) {
        Timing time = this._monitor ? new Timing(true) : null;
        boolean flagForced = false;
        if (this._optMode == POptMode.NONE || this._optMode == POptMode.CONSTRAINED && this._execMode == PExecMode.REMOTE_SPARK) {
            flagForced = this.checkSparkAndRecompileToCP(0L);
        }
        ParForBody body = new ParForBody(this._childBlocks, this._resultVars, ec);
        HashMap<String, byte[]> clsMap = new HashMap<String, byte[]>();
        String program = ProgramConverter.serializeParForBody(body, clsMap);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_PARWRK_T, time.stop());
        }
        TaskPartitioner partitioner = this.createTaskPartitioner(from, to, incr);
        long numIterations = partitioner.getNumIterations();
        List<Task> tasks = partitioner.createTasks();
        long numCreatedTasks = tasks.size();
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_TASKS_T, time.stop());
        }
        Set<String> brVars = ParForProgramBlock.getBroadcastVariables(ec, this._resultVars);
        this.exportMatricesToHDFS(ec, brVars);
        boolean topLevelPF = OptimizerUtils.isTopLevelParFor();
        RemoteParForJobReturn ret = RemoteParForSpark.runJob(this._ID, program, clsMap, tasks, ec, brVars, this._resultVars, this._enableCPCaching, this._numThreads, topLevelPF);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_EXEC_T, time.stop());
        }
        int numExecutedTasks = ret.getNumExecutedTasks();
        int numExecutedIterations = ret.getNumExecutedIterations();
        this.mergeLineage(ec, ret.getLineages());
        this.consolidateAndCheckResults(ec, numIterations, numCreatedTasks, numExecutedIterations, numExecutedTasks, ret.getVariables());
        if (flagForced) {
            this.releaseForcedRecompile(0L);
        }
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_RESULTS_T, time.stop());
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMTASKS, numExecutedTasks);
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMITERS, numExecutedIterations);
        }
    }

    private void executeRemoteSparkParForDP(ExecutionContext ec, IntObject from, IntObject to, IntObject incr) {
        long numIterations;
        Timing time = this._monitor ? new Timing(true) : null;
        boolean flagForced = this.checkSparkAndRecompileToCP(0L);
        ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
        MatrixObject inputMatrix = ec.getMatrixObject(this._colocatedDPMatrix);
        PartitionFormat inputDPF = sb.determineDataPartitionFormat(this._colocatedDPMatrix);
        inputMatrix.setPartitioned(inputDPF._dpf, inputDPF._N);
        ParForBody body = new ParForBody(this._childBlocks, this._resultVars, ec);
        HashMap<String, byte[]> clsMap = new HashMap<String, byte[]>();
        String program = ProgramConverter.serializeParForBody(body, clsMap);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_PARWRK_T, time.stop());
        }
        TaskPartitioner partitioner = this.createTaskPartitioner(from, to, incr);
        String resultFile = this.constructResultFileName();
        long numCreatedTasks = numIterations = partitioner.getNumIterations();
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_INIT_TASKS_T, time.stop());
        }
        this.exportMatricesToHDFS(ec, CollectionUtils.asSet(this._colocatedDPMatrix));
        RemoteParForJobReturn ret = RemoteDPParForSpark.runJob(this._ID, this._iterPredVar, this._colocatedDPMatrix, program, clsMap, resultFile, inputMatrix, ec, inputDPF, Types.FileFormat.BINARY, this._tSparseCol, this._enableCPCaching, this._numThreads);
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_EXEC_T, time.stop());
        }
        int numExecutedTasks = ret.getNumExecutedTasks();
        int numExecutedIterations = ret.getNumExecutedIterations();
        this.consolidateAndCheckResults(ec, numIterations, numCreatedTasks, numExecutedIterations, numExecutedTasks, ret.getVariables());
        if (flagForced) {
            this.releaseForcedRecompile(0L);
        }
        inputMatrix.unsetPartitioned();
        if (this._monitor) {
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_WAIT_RESULTS_T, time.stop());
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMTASKS, numExecutedTasks);
            StatisticMonitor.putPFStat(this._ID, Stat.PARFOR_NUMITERS, numExecutedIterations);
        }
    }

    private void handleDataPartitioning(ExecutionContext ec) {
        PDataPartitioner dataPartitioner = this._dataPartitioner;
        if (dataPartitioner != PDataPartitioner.NONE) {
            ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
            if (sb == null) {
                throw new DMLRuntimeException("ParFor statement block required for reasoning about data partitioning.");
            }
            for (String var : sb.getReadOnlyParentMatrixVars()) {
                Data dat = ec.getVariable(var);
                if (!(dat instanceof MatrixObject)) continue;
                MatrixObject moVar = (MatrixObject)dat;
                PartitionFormat dpf = sb.determineDataPartitionFormat(var);
                LOG.trace((Object)("PARFOR ID = " + this._ID + ", Partitioning read-only input variable " + var + " (format=" + dpf + ", mode=" + this._dataPartitioner + ")"));
                if (dpf == PartitionFormat.NONE) continue;
                if (dataPartitioner != PDataPartitioner.REMOTE_SPARK && dpf.isBlockwise()) {
                    LOG.warn((Object)("PARFOR ID = " + this._ID + ", Switching data partitioner from " + dataPartitioner + " to " + PDataPartitioner.REMOTE_SPARK.name() + " for blockwise-n partitioning."));
                    dataPartitioner = PDataPartitioner.REMOTE_SPARK;
                }
                Timing ltime = new Timing(true);
                Data dpdatNew = this._variablesDPReuse.get(var);
                if (dpdatNew == null) {
                    DataPartitioner dp = this.createDataPartitioner(dpf, dataPartitioner, ec);
                    if (!OptimizerRuleBased.allowsBinaryCellPartitions(moVar, dpf) || OptimizerUtils.isSparkExecutionMode()) {
                        dp.disableBinaryCell();
                    }
                    MatrixObject moVarNew = dp.createPartitionedMatrixObject(moVar, this.constructDataPartitionsFileName());
                    dpdatNew = moVarNew;
                    if (moVar == moVarNew) continue;
                }
                ec.setVariable(var, dpdatNew);
                ProgramRecompiler.rFindAndRecompileIndexingHOP(sb, this, var, ec, true);
                this._variablesDPOriginal.put(var, moVar);
                if (ALLOW_REUSE_PARTITION_VARS && ProgramRecompiler.isApplicableForReuseVariable(sb.getDMLProg(), (StatementBlock)sb, var)) {
                    this._variablesDPReuse.put(var, dpdatNew);
                }
                LOG.trace((Object)("Partitioning and recompilation done in " + ltime.stop() + "ms"));
            }
        }
    }

    private void handleSparkRepartitioning(ExecutionContext ec) {
        if (OptimizerUtils.isSparkExecutionMode() && this._variablesRP != null && !this._variablesRP.isEmpty()) {
            SparkExecutionContext sec = (SparkExecutionContext)ec;
            for (String var : this._variablesRP) {
                sec.repartitionAndCacheMatrixObject(var);
            }
        }
    }

    private void handleSparkEagerCaching(ExecutionContext ec) {
        if (OptimizerUtils.isSparkExecutionMode() && this._variablesECache != null && !this._variablesECache.isEmpty()) {
            SparkExecutionContext sec = (SparkExecutionContext)ec;
            for (String var : this._variablesECache) {
                sec.cacheMatrixObject(var);
            }
        }
    }

    private static void cleanWorkerResultVariables(ExecutionContext ec, CacheableData<?> out, CacheableData<?>[] in, boolean parallel) {
        Stream results = Arrays.stream(in).filter(m -> m != null && m != out);
        (parallel ? (Stream)results.parallel() : results).forEach(ec::cleanupCacheableData);
    }

    private static void createEmptyUnscopedVariables(LocalVariableMap out, StatementBlock sb) {
        VariableSet updated = sb.variablesUpdated();
        VariableSet livein = sb.liveIn();
        for (String var : updated.getVariableNames()) {
            if (livein.containsVariable(var)) continue;
            DataIdentifier dat = updated.getVariable(var);
            Types.DataType datatype = dat.getDataType();
            Types.ValueType valuetype = dat.getValueType();
            Data dataObj = null;
            block0 : switch (datatype) {
                case SCALAR: {
                    switch (valuetype) {
                        case BOOLEAN: {
                            dataObj = new BooleanObject(false);
                            break block0;
                        }
                        case INT64: {
                            dataObj = new IntObject(-1L);
                            break block0;
                        }
                        case FP64: {
                            dataObj = new DoubleObject(-1.0);
                            break block0;
                        }
                        case STRING: {
                            dataObj = new StringObject("-1");
                            break block0;
                        }
                    }
                    throw new DMLRuntimeException("Value type not supported: " + valuetype);
                }
                case MATRIX: 
                case FRAME: {
                    break;
                }
                case LIST: {
                    dataObj = new ListObject(Collections.emptyList());
                    break;
                }
                case UNKNOWN: {
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Data type not supported: " + datatype);
                }
            }
            if (dataObj == null) continue;
            out.put(var, dataObj);
        }
    }

    private static Set<String> getBroadcastVariables(ExecutionContext ec, List<ParForStatementBlock.ResultVar> resultVars) {
        if (!ALLOW_BROADCAST_INPUTS) {
            return new HashSet<String>();
        }
        LocalVariableMap inputs = ec.getVariables();
        Set retVars = resultVars.stream().map(v -> v._name).collect(Collectors.toSet());
        Set<String> brVars = inputs.keySet().stream().filter(v -> !retVars.contains(v)).filter(v -> ec.getVariable((String)v).getDataType().isMatrixOrFrame()).filter(v -> (double)OptimizerUtils.estimateSize(ec.getDataCharacteristics((String)v)) < 2.14E9).collect(Collectors.toSet());
        return brVars;
    }

    private void exportMatricesToHDFS(ExecutionContext ec, Set<String> excludeNames) {
        ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
        if (sb != null) {
            VariableSet varsRead = sb.variablesRead();
            for (String key : ec.getVariables().keySet()) {
                if (!varsRead.containsVariable(key) || excludeNames.contains(key)) continue;
                this.exportDataToHDFS(ec.getVariable(key), key);
            }
        } else {
            for (String key : ec.getVariables().keySet()) {
                if (excludeNames.contains(key)) continue;
                this.exportDataToHDFS(ec.getVariable(key), key);
            }
        }
    }

    private void exportDataToHDFS(Data data, String key) {
        if (data.getDataType().isMatrixOrFrame()) {
            ((CacheableData)data).exportData(this._replicationExport);
        }
        if (data.getDataType().isList()) {
            for (Data ldata : ((ListObject)data).getData()) {
                this.exportDataToHDFS(ldata, key);
            }
        }
    }

    private void cleanupSharedVariables(ExecutionContext ec, boolean[] varState) {
    }

    private LocalParWorker createParallelWorker(long pwID, LocalTaskQueue<Task> queue, ExecutionContext ec, int index) {
        LocalParWorker pw = null;
        try {
            ArrayList<ProgramBlock> cpChildBlocks = null;
            HashSet<String> fnNames = new HashSet<String>();
            cpChildBlocks = ProgramConverter.rcreateDeepCopyProgramBlocks(this._childBlocks, pwID, this._IDPrefix, new HashSet<String>(), fnNames, false, false);
            ExecutionContext cpEc = ProgramConverter.createDeepCopyExecutionContext(ec);
            cpEc.setTID(pwID);
            if (DMLScript.USE_ACCELERATOR) {
                cpEc.setGPUContexts(Arrays.asList(ec.getGPUContext(index)));
            }
            this.prepareUpdateInPlaceVariables(cpEc, pwID);
            CompilerConfig cconf = ConfigurationManager.getCompilerConfig();
            ParForBody body = new ParForBody(cpChildBlocks, this._resultVars, cpEc);
            pw = new LocalParWorker(pwID, queue, body, cconf, MAX_RETRYS_ON_ERROR, this._monitor);
            pw.setFunctionNames(fnNames);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return pw;
    }

    private TaskPartitioner createTaskPartitioner(IntObject from, IntObject to, IntObject incr) {
        TaskPartitioner tp;
        switch (this._taskPartitioner) {
            case FIXED: {
                tp = new TaskPartitionerFixedsize(this._taskSize, this._iterPredVar, from, to, incr);
                break;
            }
            case NAIVE: {
                tp = new TaskPartitionerNaive(this._taskSize, this._iterPredVar, from, to, incr);
                break;
            }
            case STATIC: {
                tp = new TaskPartitionerStatic(this._taskSize, this._numThreads, this._iterPredVar, from, to, incr);
                break;
            }
            case FACTORING: {
                tp = new TaskPartitionerFactoring(this._taskSize, this._numThreads, this._iterPredVar, from, to, incr);
                break;
            }
            case FACTORING_CMIN: {
                tp = new TaskPartitionerFactoringCmin(this._taskSize, this._numThreads, this._taskSize, this._iterPredVar, from, to, incr);
                break;
            }
            case FACTORING_CMAX: {
                tp = new TaskPartitionerFactoringCmax(this._taskSize, this._numThreads, this._taskSize, this._iterPredVar, from, to, incr);
                break;
            }
            default: {
                throw new DMLRuntimeException("Undefined task partitioner: '" + this._taskPartitioner + "'.");
            }
        }
        return tp;
    }

    private DataPartitioner createDataPartitioner(PartitionFormat dpf, PDataPartitioner dataPartitioner, ExecutionContext ec) {
        DataPartitioner dp;
        int numRed = OptimizerUtils.isSparkExecutionMode() ? SparkExecutionContext.getDefaultParallelism(false) : 1;
        switch (dataPartitioner) {
            case LOCAL: {
                dp = new DataPartitionerLocal(dpf, this._numThreads);
                break;
            }
            case REMOTE_SPARK: {
                dp = new DataPartitionerRemoteSpark(dpf, ec, numRed, this._replicationDP, false);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unknown data partitioner: '" + dataPartitioner.name() + "'.");
            }
        }
        return dp;
    }

    private ResultMerge<?> createResultMerge(PResultMerge prm, CacheableData<?> out, CacheableData<?>[] in, String fname, boolean accum, ExecutionContext ec) {
        ResultMerge rm;
        block7: {
            block8: {
                block6: {
                    if (!(out instanceof FrameObject)) break block6;
                    rm = new ResultMergeFrameLocalMemory((FrameObject)out, (FrameObject[])in, fname, accum);
                    break block7;
                }
                if (!(out instanceof MatrixObject)) break block8;
                switch (prm) {
                    case LOCAL_MEM: {
                        rm = new ResultMergeLocalMemory((MatrixObject)out, (MatrixObject[])in, fname, accum);
                        break block7;
                    }
                    case LOCAL_FILE: {
                        rm = new ResultMergeLocalFile((MatrixObject)out, (MatrixObject[])in, fname, accum);
                        break block7;
                    }
                    case LOCAL_AUTOMATIC: {
                        rm = new ResultMergeLocalAutomatic((MatrixObject)out, (MatrixObject[])in, fname, accum);
                        break block7;
                    }
                    case REMOTE_SPARK: {
                        int numMap;
                        int numRed = numMap = Math.max(this._numThreads, SparkExecutionContext.getDefaultParallelism(true));
                        rm = new ResultMergeRemoteSpark((MatrixObject)out, (MatrixObject[])in, fname, accum, ec, numMap, numRed);
                        break block7;
                    }
                    default: {
                        throw new DMLRuntimeException("Undefined result merge: '" + prm + "'.");
                    }
                }
            }
            throw new DMLRuntimeException("Unsupported result merge data: " + out.getClass().getSimpleName());
        }
        return rm;
    }

    private boolean checkSparkAndRecompileToCP(long tid) {
        if (!OptTreeConverter.rContainsSparkInstruction(this, true)) {
            return false;
        }
        ParForStatementBlock sb = (ParForStatementBlock)this.getStatementBlock();
        if (sb == null) {
            LOG.warn((Object)"Missing parfor statement block for recompile.");
            return false;
        }
        HashSet<String> fnStack = new HashSet<String>();
        Recompiler.recompileProgramBlockHierarchy2Forced(this._childBlocks, tid, fnStack, Types.ExecType.CP);
        return true;
    }

    private void releaseForcedRecompile(long tid) {
        Recompiler.recompileProgramBlockHierarchy2Forced(this._childBlocks, tid, new HashSet<String>(), null);
    }

    private void mergeLineage(ExecutionContext ec, Lineage[] lineages) {
        if (!DMLScript.LINEAGE) {
            return;
        }
        for (ParForStatementBlock.ResultVar var : this._resultVars) {
            LineageItem retIn = ec.getLineage().get(var._name);
            LineageItem current = lineages[0].get(var._name);
            for (int i = 1; i < lineages.length; ++i) {
                LineageItem next = lineages[i].get(var._name);
                if (next == null) continue;
                current = current == null ? next : LineageItemUtils.replace(next, retIn, current);
            }
            ec.getLineage().set(var._name, current);
        }
    }

    private void consolidateAndCheckResults(ExecutionContext ec, long expIters, long expTasks, long numIters, long numTasks, LocalVariableMap[] results) {
        ParForStatementBlock sb;
        Timing time = new Timing(true);
        if (this.checkParallelRemoteResultMerge()) {
            int par = Math.min(this._resultVars.size(), InfrastructureAnalyzer.getLocalParallelism());
            if (InfrastructureAnalyzer.isLocalMode()) {
                int parmem = (int)Math.floor(OptimizerUtils.getLocalMemBudget());
                par = Math.min(par, Math.max(parmem, 1));
            }
            try {
                int i;
                LocalTaskQueue<ParForStatementBlock.ResultVar> q = new LocalTaskQueue<ParForStatementBlock.ResultVar>();
                for (ParForStatementBlock.ResultVar var : this._resultVars) {
                    if (!(ec.getVariable(var._name) instanceof MatrixObject)) continue;
                    q.enqueueTask(var);
                }
                q.closeInput();
                ResultMergeWorker[] rmWorkers = new ResultMergeWorker[par];
                for (i = 0; i < par; ++i) {
                    rmWorkers[i] = new ResultMergeWorker(q, results, ec);
                }
                for (i = 0; i < par; ++i) {
                    rmWorkers[i].start();
                }
                for (i = 0; i < par; ++i) {
                    rmWorkers[i].join();
                    if (rmWorkers[i].finishedNoError()) continue;
                    throw new DMLRuntimeException("Error occured in parallel result merge worker.");
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        } else {
            for (ParForStatementBlock.ResultVar var : this._resultVars) {
                Data[] in;
                Data dat = ec.getVariable(var._name);
                if (dat instanceof MatrixObject | dat instanceof FrameObject) {
                    CacheableData out = (CacheableData)dat;
                    Stream<Object> tmp = Arrays.stream(results).map(vars -> vars.get(var._name));
                    in = dat instanceof MatrixObject ? (CacheableData[])tmp.toArray(MatrixObject[]::new) : (CacheableData[])tmp.toArray(FrameObject[]::new);
                    String fname = this.constructResultMergeFileName();
                    ResultMerge<?> rm = this.createResultMerge(this._resultMerge, out, (CacheableData<?>[])in, fname, var._isAccum, ec);
                    Object outNew = rm.executeSerialMerge();
                    Data exdata = ec.removeVariable(var._name);
                    if (exdata != null && exdata != outNew) {
                        ec.cleanupDataObject(exdata);
                    }
                    ParForProgramBlock.cleanWorkerResultVariables(ec, out, in, true);
                    ec.setVariable(var._name, (Data)outNew);
                    continue;
                }
                if (!(dat instanceof ListObject)) continue;
                ListObject oldList = (ListObject)dat;
                ListObject newList = new ListObject(oldList);
                in = (ListObject[])Arrays.stream(results).map(vars -> vars.get(var._name)).toArray(ListObject[]::new);
                block7: for (int i = 0; i < oldList.getLength(); ++i) {
                    Data compare = oldList.slice(i);
                    for (int j = 0; j < in.length; ++j) {
                        Data tmp = ((ListObject)in[j]).slice(i);
                        if (compare == tmp) continue;
                        newList.set(i, tmp);
                        continue block7;
                    }
                }
                ec.setVariable(var._name, newList);
            }
        }
        if ((sb = (ParForStatementBlock)this.getStatementBlock()) != null && ec.getVariables() != null) {
            ParForProgramBlock.createEmptyUnscopedVariables(ec.getVariables(), sb);
        }
        if (numTasks != expTasks || numIters != expIters) {
            throw new DMLRuntimeException("PARFOR: Number of executed tasks does not match the number of created tasks: tasks " + numTasks + "/" + expTasks + ", iters " + numIters + "/" + expIters + ".");
        }
        if (DMLScript.STATISTICS) {
            ParForStatistics.incrementMergeTime((long)time.stop());
        }
    }

    private boolean checkParallelRemoteResultMerge() {
        return this._resultVars.size() > 1 && this._resultMerge == PResultMerge.REMOTE_SPARK;
    }

    private void setParForProgramBlockIDs(int IDPrefix) {
        this._IDPrefix = IDPrefix;
        this._ID = this._IDPrefix == -1 ? _pfIDSeq.getNextID() : IDHandler.concatIntIDsToLong(this._IDPrefix, (int)_pfIDSeq.getNextID());
    }

    private void setLocalParWorkerIDs() {
        if (this._numThreads <= 0) {
            return;
        }
        this._pwIDs = new long[this._numThreads];
        for (int i = 0; i < this._numThreads; ++i) {
            this._pwIDs[i] = this._IDPrefix == -1 ? _pwIDSeq.getNextID() : IDHandler.concatIntIDsToLong(this._IDPrefix, (int)_pwIDSeq.getNextID());
            if (!this._monitor) continue;
            StatisticMonitor.putPfPwMapping(this._ID, this._pwIDs[i]);
        }
    }

    private String constructResultFileName() {
        String scratchSpaceLoc = ConfigurationManager.getScratchSpace();
        StringBuilder sb = new StringBuilder();
        sb.append(scratchSpaceLoc);
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        sb.append(PARFOR_MR_RESULT_TMP_FNAME.replaceAll("%ID%", String.valueOf(this._ID)));
        return sb.toString();
    }

    private String constructResultMergeFileName() {
        String scratchSpaceLoc = ConfigurationManager.getScratchSpace();
        String fname = PARFOR_MR_RESULTMERGE_FNAME;
        fname = fname.replaceAll("%ID%", String.valueOf(this._ID));
        fname = fname.replaceAll("%VAR%", String.valueOf(this._resultVarsIDSeq.getNextID()));
        StringBuilder sb = new StringBuilder();
        sb.append(scratchSpaceLoc);
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        sb.append(fname);
        return sb.toString();
    }

    private String constructDataPartitionsFileName() {
        String scratchSpaceLoc = ConfigurationManager.getScratchSpace();
        String fname = PARFOR_DATAPARTITIONS_FNAME;
        fname = fname.replaceAll("%ID%", String.valueOf(this._ID));
        fname = fname.replaceAll("%VAR%", String.valueOf(this._dpVarsIDSeq.getNextID()));
        StringBuilder sb = new StringBuilder();
        sb.append(scratchSpaceLoc);
        sb.append("/");
        sb.append("_p");
        sb.append(DMLScript.getUUID());
        sb.append(fname);
        return sb.toString();
    }

    private void setMemoryBudget() {
        if (this._recompileMemoryBudget > 0.0) {
            this._oldMemoryBudget = InfrastructureAnalyzer.getLocalMaxMemory();
            long newMaxMem = (long)(this._recompileMemoryBudget / OptimizerUtils.MEM_UTIL_FACTOR);
            InfrastructureAnalyzer.setLocalMaxMemory(newMaxMem);
        }
    }

    private void resetMemoryBudget() {
        if (this._recompileMemoryBudget > 0.0) {
            InfrastructureAnalyzer.setLocalMaxMemory((long)this._oldMemoryBudget);
        }
    }

    private void resetOptimizerFlags() {
        this._variablesDPOriginal.removeAll();
        this._colocatedDPMatrix = null;
        this._replicationDP = 1;
        this._replicationExport = -1;
        this._jvmReuse = true;
        this._recompileMemoryBudget = -1.0;
        this._enableRuntimePiggybacking = false;
        this._variablesRP = null;
        this._variablesECache = null;
    }

    @Override
    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in parfor program block generated from parfor statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }

    private class ResultMergeWorker
    extends Thread {
        private final LocalTaskQueue<ParForStatementBlock.ResultVar> _q;
        private final LocalVariableMap[] _refVars;
        private final ExecutionContext _ec;
        private boolean _success = false;

        public ResultMergeWorker(LocalTaskQueue<ParForStatementBlock.ResultVar> q, LocalVariableMap[] results, ExecutionContext ec) {
            this._q = q;
            this._refVars = results;
            this._ec = ec;
        }

        public boolean finishedNoError() {
            return this._success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ParForStatementBlock.ResultVar var;
                while ((var = this._q.dequeueTask()) != LocalTaskQueue.NO_MORE_TASKS) {
                    CacheableData<?> out = null;
                    LocalVariableMap localVariableMap = this._ec.getVariables();
                    synchronized (localVariableMap) {
                        out = this._ec.getCacheableData(var._name);
                    }
                    Stream<Object> tmp = Arrays.stream(this._refVars).map(vars -> vars.get(var._name));
                    CacheableData[] in = out instanceof MatrixObject ? (CacheableData[])tmp.toArray(MatrixObject[]::new) : (CacheableData[])tmp.toArray(FrameObject[]::new);
                    String fname = ParForProgramBlock.this.constructResultMergeFileName();
                    ResultMerge<?> rm = ParForProgramBlock.this.createResultMerge(ParForProgramBlock.this._resultMerge, out, in, fname, var._isAccum, this._ec);
                    Object outNew = rm.executeSerialMerge();
                    LocalVariableMap localVariableMap2 = this._ec.getVariables();
                    synchronized (localVariableMap2) {
                        this._ec.getVariables().put(var._name, (Data)outNew);
                    }
                    ParForProgramBlock.cleanWorkerResultVariables(this._ec, out, in, false);
                }
                this._success = true;
            }
            catch (Exception ex) {
                ProgramBlock.LOG.error((Object)"Error executing result merge: ", (Throwable)ex);
            }
        }
    }

    public static enum POptMode {
        NONE,
        RULEBASED,
        CONSTRAINED,
        HEURISTIC;

    }

    public static enum PResultMerge {
        LOCAL_MEM,
        LOCAL_FILE,
        LOCAL_AUTOMATIC,
        REMOTE_SPARK,
        UNSPECIFIED;


        public boolean isLocal() {
            return this == LOCAL_MEM || this == LOCAL_FILE || this == LOCAL_AUTOMATIC;
        }
    }

    public static enum PDataPartitioner {
        NONE,
        LOCAL,
        REMOTE_SPARK,
        UNSPECIFIED;

    }

    public static class PartitionFormat
    implements Serializable {
        private static final long serialVersionUID = 4729309847778707801L;
        public static final PartitionFormat NONE = new PartitionFormat(PDataPartitionFormat.NONE, -1);
        public static final PartitionFormat ROW_WISE = new PartitionFormat(PDataPartitionFormat.ROW_WISE, -1);
        public static final PartitionFormat COLUMN_WISE = new PartitionFormat(PDataPartitionFormat.COLUMN_WISE, -1);
        public final PDataPartitionFormat _dpf;
        public final int _N;

        public PartitionFormat(PDataPartitionFormat dpf, int N) {
            this._dpf = dpf;
            this._N = N;
        }

        public int hashCode() {
            return UtilFunctions.intHashCode(this._dpf.ordinal(), this._N);
        }

        public boolean equals(Object o) {
            return o instanceof PartitionFormat && this._dpf == ((PartitionFormat)o)._dpf && this._N == ((PartitionFormat)o)._N;
        }

        public String toString() {
            return this._dpf.name() + "," + this._N;
        }

        public static PartitionFormat valueOf(String value) {
            String[] parts = value.split(",");
            return new PartitionFormat(PDataPartitionFormat.parsePDataPartitionFormat(parts[0]), Integer.parseInt(parts[1]));
        }

        public boolean isBlockwise() {
            return this._dpf == PDataPartitionFormat.COLUMN_BLOCK_WISE_N || this._dpf == PDataPartitionFormat.ROW_BLOCK_WISE_N;
        }

        public boolean isRowwise() {
            return this._dpf == PDataPartitionFormat.ROW_WISE || this._dpf == PDataPartitionFormat.ROW_BLOCK_WISE || this._dpf == PDataPartitionFormat.ROW_BLOCK_WISE_N;
        }

        public long getNumParts(DataCharacteristics mc) {
            switch (this._dpf) {
                case ROW_WISE: {
                    return mc.getRows();
                }
                case ROW_BLOCK_WISE: {
                    return mc.getNumRowBlocks();
                }
                case ROW_BLOCK_WISE_N: {
                    return (long)Math.ceil((double)mc.getRows() / (double)this._N);
                }
                case COLUMN_WISE: {
                    return mc.getCols();
                }
                case COLUMN_BLOCK_WISE: {
                    return mc.getNumColBlocks();
                }
                case COLUMN_BLOCK_WISE_N: {
                    return (long)Math.ceil((double)mc.getCols() / (double)this._N);
                }
            }
            throw new RuntimeException("Unsupported partition format: " + this._dpf);
        }

        public long getNumRows(DataCharacteristics mc) {
            switch (this._dpf) {
                case ROW_WISE: {
                    return 1L;
                }
                case ROW_BLOCK_WISE: {
                    return mc.getBlocksize();
                }
                case ROW_BLOCK_WISE_N: {
                    return this._N;
                }
                case COLUMN_WISE: {
                    return mc.getRows();
                }
                case COLUMN_BLOCK_WISE: {
                    return mc.getRows();
                }
                case COLUMN_BLOCK_WISE_N: {
                    return mc.getRows();
                }
            }
            throw new RuntimeException("Unsupported partition format: " + this._dpf);
        }

        public long getNumColumns(DataCharacteristics mc) {
            switch (this._dpf) {
                case ROW_WISE: {
                    return mc.getCols();
                }
                case ROW_BLOCK_WISE: {
                    return mc.getCols();
                }
                case ROW_BLOCK_WISE_N: {
                    return mc.getCols();
                }
                case COLUMN_WISE: {
                    return 1L;
                }
                case COLUMN_BLOCK_WISE: {
                    return mc.getBlocksize();
                }
                case COLUMN_BLOCK_WISE_N: {
                    return this._N;
                }
            }
            throw new RuntimeException("Unsupported partition format: " + this._dpf);
        }
    }

    public static enum PDataPartitionFormat {
        NONE,
        ROW_WISE,
        ROW_BLOCK_WISE,
        ROW_BLOCK_WISE_N,
        COLUMN_WISE,
        COLUMN_BLOCK_WISE,
        COLUMN_BLOCK_WISE_N,
        BLOCK_WISE_M_N;


        public static PDataPartitionFormat parsePDataPartitionFormat(String s) {
            if (s.equalsIgnoreCase("ROW_WISE")) {
                return ROW_WISE;
            }
            if (s.equalsIgnoreCase("ROW_BLOCK_WISE")) {
                return ROW_BLOCK_WISE;
            }
            if (s.equalsIgnoreCase("ROW_BLOCK_WISE_N")) {
                return ROW_BLOCK_WISE_N;
            }
            if (s.equalsIgnoreCase("COLUMN_WISE")) {
                return COLUMN_WISE;
            }
            if (s.equalsIgnoreCase("COLUMN_BLOCK_WISE")) {
                return COLUMN_BLOCK_WISE;
            }
            if (s.equalsIgnoreCase("COLUMN_BLOCK_WISE_N")) {
                return COLUMN_BLOCK_WISE_N;
            }
            if (s.equalsIgnoreCase("BLOCK_WISE_M_N")) {
                return BLOCK_WISE_M_N;
            }
            return NONE;
        }
    }

    public static enum PTaskPartitioner {
        FIXED,
        NAIVE,
        STATIC,
        FACTORING,
        FACTORING_CMIN,
        FACTORING_CMAX,
        UNSPECIFIED;

    }

    public static enum PExecMode {
        LOCAL,
        REMOTE_SPARK,
        REMOTE_SPARK_DP,
        UNSPECIFIED;

    }
}

