/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.junit.Assert;

public class InstallDependencyForIntegrationTests {
    public static void main(String[] args) throws IOException, DMLRuntimeException, InterruptedException {
        boolean enableGPU;
        boolean skip = Boolean.parseBoolean(args[0]);
        if (!skip) {
            InstallDependencyForIntegrationTests.runRScript(true);
        }
        if (args.length >= 2 && (enableGPU = Boolean.parseBoolean(args[1]))) {
            String baseDir = "src" + File.separator + "main" + File.separator + "cpp" + File.separator + "kernels" + File.separator;
            System.out.println("==============================================");
            System.out.println("Compiling the kernels into ptx");
            String cmd = "nvcc -ptx " + baseDir + "SystemDS.cu -o " + baseDir + "SystemDS.ptx";
            Process child = InstallDependencyForIntegrationTests.runCommand(cmd);
            System.out.println("==============================================");
            try {
                if (child.exitValue() != 0) {
                    throw new DMLRuntimeException("Compiling the kernels into ptx was unsuccessful.");
                }
            }
            catch (IllegalThreadStateException ie) {
                child.destroy();
            }
            if (!new File(baseDir + "SystemDS.ptx").exists()) {
                throw new DMLRuntimeException("Compiling the kernels into ptx was unsuccessful.");
            }
        }
    }

    private static Process runCommand(String cmd) throws IOException, InterruptedException {
        Process child = Runtime.getRuntime().exec(cmd);
        int c = 0;
        while ((c = child.getInputStream().read()) != -1) {
            System.out.print((char)c);
        }
        while ((c = child.getErrorStream().read()) != -1) {
            System.err.print((char)c);
        }
        child.waitFor();
        return child;
    }

    protected static void runRScript(boolean newWay) {
        String cmd;
        String executionFile = "./src/test/scripts/installDependencies.R";
        if (!newWay) {
            executionFile = executionFile + "t";
            cmd = "R -f " + executionFile;
        } else {
            cmd = "Rscript " + executionFile;
        }
        if (System.getProperty("os.name").contains("Windows")) {
            cmd = cmd.replace('/', '\\');
            executionFile = executionFile.replace('/', '\\');
        }
        if (!newWay) {
            InstallDependencyForIntegrationTests.printRScript(executionFile);
        }
        try {
            long t0 = System.nanoTime();
            System.out.println("Installing packages required for running integration tests ...");
            Process child = InstallDependencyForIntegrationTests.runCommand(cmd);
            try {
                if (child.exitValue() != 0) {
                    throw new Exception("ERROR: R has ended irregularly.\nscript file: " + executionFile);
                }
            }
            catch (IllegalThreadStateException ie) {
                child.destroy();
            }
            System.out.println("Done installing packages required for running integration tests.");
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("failed to run script " + executionFile);
            errorMessage.append("\nexception: " + e.toString());
            errorMessage.append("\nmessage: " + e.getMessage());
            errorMessage.append("\nstack trace:");
            for (StackTraceElement ste : e.getStackTrace()) {
                errorMessage.append("\n>" + ste);
            }
            Assert.fail((String)errorMessage.toString());
        }
    }

    public static void printRScript(String dmlScriptFile) {
        try {
            System.out.println("Running script: " + dmlScriptFile + "\n");
            System.out.println("******************* R script *******************");
            try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(dmlScriptFile)));){
                String content;
                while ((content = in.readLine()) != null) {
                    System.out.println(content);
                }
            }
            System.out.println("**************************************************\n\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("unable to print R script: " + e.getMessage()));
        }
    }
}

